/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.character;

import es.eucm.eadventure.common.data.animation.ImageLoaderFactory;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.common.loader.InputStreamCreator;
import es.eucm.eadventure.common.loader.Loader;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.DataControlWithResources;
import es.eucm.eadventure.editor.control.controllers.EditorImageLoader;
import es.eucm.eadventure.editor.control.controllers.character.NPCDataControl;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.elementpanels.general.LooksPanel;
import es.eucm.eadventure.editor.gui.otherpanels.AnimationPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class NPCLooksPanel
extends LooksPanel
implements Updateable {
    public static final int STANDING = 0;
    public static final int TALKING = 1;
    public static final int USING = 2;
    public static final int WALKING = 3;
    private static final long serialVersionUID = 1L;
    private JPanel imagePanel;
    private NPCDataControl npcDataControl;

    public NPCLooksPanel(DataControlWithResources dataControlWithResources) {
        super(dataControlWithResources);
    }

    @Override
    protected void createPreview() {
        this.npcDataControl = (NPCDataControl)this.dataControl;
        if (this.imagePanel != null) {
            this.lookPanel.remove(this.imagePanel);
        }
        this.imagePanel = this.createImagePanel();
        this.lookPanel.add((Component)this.imagePanel, this.cLook);
        this.lookPanel.setPreferredSize(new Dimension(0, 800));
    }

    @Override
    public void updatePreview() {
        if (this.imagePanel != null) {
            this.lookPanel.remove(this.imagePanel);
        }
        this.imagePanel = this.createImagePanel();
        this.lookPanel.add((Component)this.imagePanel, this.cLook);
        this.lookPanel.repaint();
    }

    private JPanel createImagePanel() {
        this.imagePanel = new JPanel();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        if (this.selectedResourceGroup == 3) {
            this.imagePanel.setLayout(new GridLayout(1, 4));
            string4 = TC.get((String)"Resources.DescriptionCharacterAnimationWalkRight");
            string3 = this.npcDataControl.getAnimationPath("walkright");
            string2 = TC.get((String)"Resources.DescriptionCharacterAnimationWalkLeft");
            string = this.npcDataControl.getAnimationPath("walkleft");
            string6 = TC.get((String)"Resources.DescriptionCharacterAnimationWalkUp");
            string5 = this.npcDataControl.getAnimationPath("walkup");
            string8 = TC.get((String)"Resources.DescriptionCharacterAnimationWalkDown");
            string7 = this.npcDataControl.getAnimationPath("walkdown");
        } else if (this.selectedResourceGroup == 0) {
            this.imagePanel.setLayout(new GridLayout(1, 4));
            string4 = TC.get((String)"Resources.DescriptionCharacterAnimationStandRight");
            string3 = this.npcDataControl.getAnimationPath("standright");
            string2 = TC.get((String)"Resources.DescriptionCharacterAnimationStandLeft");
            string = this.npcDataControl.getAnimationPath("standleft");
            string6 = TC.get((String)"Resources.DescriptionCharacterAnimationStandUp");
            string5 = this.npcDataControl.getAnimationPath("standup");
            string8 = TC.get((String)"Resources.DescriptionCharacterAnimationStandDown");
            string7 = this.npcDataControl.getAnimationPath("standdown");
        } else if (this.selectedResourceGroup == 1) {
            this.imagePanel.setLayout(new GridLayout(1, 4));
            string4 = TC.get((String)"Resources.DescriptionCharacterAnimationSpeakRight");
            string3 = this.npcDataControl.getAnimationPath("speakright");
            string2 = TC.get((String)"Resources.DescriptionCharacterAnimationSpeakLeft");
            string = this.npcDataControl.getAnimationPath("speakleft");
            string6 = TC.get((String)"Resources.DescriptionCharacterAnimationSpeakUp");
            string5 = this.npcDataControl.getAnimationPath("speakup");
            string8 = TC.get((String)"Resources.DescriptionCharacterAnimationSpeakDown");
            string7 = this.npcDataControl.getAnimationPath("speakdown");
        } else if (this.selectedResourceGroup == 2) {
            this.imagePanel.setLayout(new GridLayout(1, 2));
            string4 = TC.get((String)"Resources.DescriptionCharacterAnimationUseRight");
            string3 = this.npcDataControl.getAnimationPath("useright");
            string2 = TC.get((String)"Resources.DescriptionCharacterAnimationUseLeft");
            string = this.npcDataControl.getAnimationPath("useleft");
        }
        this.imagePanel.add(this.createAnimationPanel(string, string2));
        this.imagePanel.add(this.createAnimationPanel(string3, string4));
        if (this.selectedResourceGroup != 2) {
            this.imagePanel.add(this.createAnimationPanel(string5, string6));
            this.imagePanel.add(this.createAnimationPanel(string7, string8));
        }
        return this.imagePanel;
    }

    private JPanel createAnimationPanel(String string, String string2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string2));
        if (string != null) {
            if (string.endsWith(".eaa")) {
                jPanel.add((Component)new AnimationPanel(false, Loader.loadAnimation((InputStreamCreator)AssetsController.getInputStreamCreator(), (String)string, (ImageLoaderFactory)new EditorImageLoader())), "Center");
            } else {
                jPanel.add((Component)new AnimationPanel(false, string + "_01.png"), "Center");
            }
        } else {
            jPanel.add((Component)new AnimationPanel(false, ""), "Center");
        }
        return jPanel;
    }

    @Override
    public void updateResources() {
        super.updateResources();
        if (this.getParent() != null && this.getParent().getParent() != null) {
            this.getParent().getParent().repaint();
        }
    }
}

