/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.character;

import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.VoiceManager;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.character.NPCDataControl;
import es.eucm.eadventure.editor.gui.auxiliar.components.TextPreviewPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NPCDialogPanel
extends JPanel {
    private static final long serialVersionUID = 3457765490477715761L;
    private NPCDataControl dataControl;
    private TextPreviewPanel textPreviewPanel;
    private JComboBox voicesComboBox;
    private JTextField trySynthesizer;
    private JCheckBox alwaysSynthesizer;
    private String[] checkVoices;
    private JButton bubbleBkgButton;
    private JButton bubbleBorderButton;
    private JCheckBox showsSpeechBubbles;
    private JButton playText;

    public NPCDialogPanel(NPCDataControl nPCDataControl) {
        int n;
        this.dataControl = nPCDataControl;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 2, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 0;
        JPanel jPanel = this.createTextColorPanel();
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 2));
        String[] stringArray = this.availableVoices();
        this.voicesComboBox = new JComboBox<String>(stringArray);
        this.checkVoices = stringArray;
        this.voicesComboBox.addItemListener(new VoiceComboBoxListener());
        if (nPCDataControl.getVoice() != null) {
            for (n = 1; n < this.checkVoices.length; ++n) {
                if (!this.checkVoices[n].equals(nPCDataControl.getVoice())) continue;
                this.voicesComboBox.setSelectedIndex(n);
            }
        }
        jPanel2.add(this.voicesComboBox);
        this.alwaysSynthesizer = new JCheckBox(TC.get((String)"Synthesizer.CheckAlways"));
        this.alwaysSynthesizer.addItemListener(new VoiceCheckVoxListener());
        this.alwaysSynthesizer.setSelected(nPCDataControl.isAlwaysSynthesizer());
        jPanel2.add(this.alwaysSynthesizer);
        this.trySynthesizer = new JTextField();
        jPanel2.add(this.trySynthesizer);
        this.playText = new JButton(TC.get((String)"Synthesizer.ButtonPlay"));
        this.playText.addActionListener(new VoiceButtonListener());
        jPanel2.add(this.playText);
        n = this.voicesComboBox.getSelectedIndex();
        boolean bl = n != 0;
        this.alwaysSynthesizer.setEnabled(bl);
        this.trySynthesizer.setEnabled(bl);
        this.playText.setEnabled(bl);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), TC.get((String)"Synthesizer.BorderVoices"), 1, 2);
        jPanel2.setBorder(titledBorder);
        this.add((Component)jPanel2, gridBagConstraints);
    }

    private JPanel createTextColorPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.1;
        this.showsSpeechBubbles = new JCheckBox(TC.get((String)"Player.ShowsSpeechBubble"));
        jPanel.add((Component)this.showsSpeechBubbles, gridBagConstraints);
        this.showsSpeechBubbles.setSelected(this.dataControl.getShowsSpeechBubbles());
        this.showsSpeechBubbles.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (NPCDialogPanel.this.showsSpeechBubbles.isSelected() != NPCDialogPanel.this.dataControl.getShowsSpeechBubbles().booleanValue()) {
                    NPCDialogPanel.this.dataControl.setShowsSpeechBubbles(NPCDialogPanel.this.showsSpeechBubbles.isSelected());
                    if (NPCDialogPanel.this.bubbleBkgButton != null && NPCDialogPanel.this.bubbleBorderButton != null) {
                        NPCDialogPanel.this.bubbleBkgButton.setEnabled(NPCDialogPanel.this.dataControl.getShowsSpeechBubbles());
                        NPCDialogPanel.this.bubbleBorderButton.setEnabled(NPCDialogPanel.this.dataControl.getShowsSpeechBubbles());
                    }
                    if (NPCDialogPanel.this.textPreviewPanel != null) {
                        NPCDialogPanel.this.textPreviewPanel.setShowsSpeechBubbles(NPCDialogPanel.this.showsSpeechBubbles.isSelected());
                    }
                }
            }
        });
        this.textPreviewPanel = new TextPreviewPanel(this.dataControl.getTextFrontColor(), this.dataControl.getTextBorderColor(), this.dataControl.getShowsSpeechBubbles(), this.dataControl.getBubbleBkgColor(), this.dataControl.getBubbleBorderColor());
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipady = 40;
        jPanel.add((Component)this.textPreviewPanel, gridBagConstraints);
        JButton jButton = new JButton(TC.get((String)"Player.FrontColor"));
        jButton.addActionListener(new ChangeTextColorListener(0));
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.ipady = 0;
        jPanel.add((Component)jButton, gridBagConstraints);
        JButton jButton2 = new JButton(TC.get((String)"Player.BorderColor"));
        jButton2.addActionListener(new ChangeTextColorListener(1));
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jButton2, gridBagConstraints);
        this.bubbleBkgButton = new JButton(TC.get((String)"Player.BubbleBkgColor"));
        this.bubbleBkgButton.addActionListener(new ChangeTextColorListener(2));
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.bubbleBkgButton, gridBagConstraints);
        this.bubbleBkgButton.setEnabled(this.dataControl.getShowsSpeechBubbles());
        this.bubbleBorderButton = new JButton(TC.get((String)"Player.BubbleBorderColor"));
        this.bubbleBorderButton.addActionListener(new ChangeTextColorListener(3));
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.bubbleBorderButton, gridBagConstraints);
        this.bubbleBorderButton.setEnabled(this.dataControl.getShowsSpeechBubbles());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Player.TextColor")));
        return jPanel;
    }

    private String[] availableVoices() {
        System.setProperty("freetts.voices", "com.sun.speech.freetts.en.us.cmu_us_kal.KevinVoiceDirectory");
        VoiceManager voiceManager = VoiceManager.getInstance();
        Voice[] voiceArray = voiceManager.getVoices();
        String[] stringArray = new String[voiceArray.length + 1];
        stringArray[0] = TC.get((String)"Synthesizer.Empty");
        for (int i = 0; i < voiceArray.length; ++i) {
            stringArray[i + 1] = voiceArray[i].getName();
        }
        return stringArray;
    }

    public boolean updateFields() {
        this.showsSpeechBubbles.setSelected(this.dataControl.getShowsSpeechBubbles());
        this.bubbleBkgButton.setEnabled(this.dataControl.getShowsSpeechBubbles());
        this.bubbleBorderButton.setEnabled(this.dataControl.getShowsSpeechBubbles());
        this.textPreviewPanel.setBubbleBkgColor(this.dataControl.getBubbleBkgColor());
        this.textPreviewPanel.setBubbleBorderColor(this.dataControl.getBubbleBorderColor());
        this.textPreviewPanel.setTextBorderColor(this.dataControl.getTextBorderColor());
        this.textPreviewPanel.setTextFrontColor(this.dataControl.getTextFrontColor());
        this.textPreviewPanel.setShowsSpeechBubbles(this.dataControl.getShowsSpeechBubbles());
        this.textPreviewPanel.updateUI();
        if (this.dataControl.getVoice() != null) {
            for (int i = 1; i < this.checkVoices.length; ++i) {
                if (!this.checkVoices[i].equals(this.dataControl.getVoice())) continue;
                this.voicesComboBox.setSelectedIndex(i);
            }
        }
        this.alwaysSynthesizer.setSelected(this.dataControl.isAlwaysSynthesizer());
        this.repaint();
        return true;
    }

    private class ChangeTextColorListener
    implements ActionListener {
        public static final int FRONT_COLOR = 0;
        public static final int BORDER_COLOR = 1;
        public static final int BUBBLEBKG_COLOR = 2;
        public static final int BUBBLEBORDER_COLOR = 3;
        private int color;
        private JColorChooser colorChooser;
        private TextPreviewPanel colorPreviewPanel;

        public ChangeTextColorListener(int n) {
            this.color = n;
            this.colorChooser = new JColorChooser();
            this.colorPreviewPanel = new TextPreviewPanel(NPCDialogPanel.this.dataControl.getTextFrontColor(), NPCDialogPanel.this.dataControl.getTextBorderColor(), NPCDialogPanel.this.dataControl.getShowsSpeechBubbles(), NPCDialogPanel.this.dataControl.getBubbleBkgColor(), NPCDialogPanel.this.dataControl.getBubbleBorderColor());
            this.colorPreviewPanel.setPreferredSize(new Dimension(400, 40));
            this.colorPreviewPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.colorChooser.setPreviewPanel(this.colorPreviewPanel);
            this.colorChooser.getSelectionModel().addChangeListener(new UpdatePreviewPanelListener());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.color == 0) {
                this.colorChooser.setColor(NPCDialogPanel.this.dataControl.getTextFrontColor());
            } else if (this.color == 1) {
                this.colorChooser.setColor(NPCDialogPanel.this.dataControl.getTextBorderColor());
            } else if (this.color == 2) {
                this.colorChooser.setColor(NPCDialogPanel.this.dataControl.getBubbleBkgColor());
            } else if (this.color == 3) {
                this.colorChooser.setColor(NPCDialogPanel.this.dataControl.getBubbleBorderColor());
            }
            this.colorPreviewPanel.setTextFrontColor(NPCDialogPanel.this.dataControl.getTextFrontColor());
            this.colorPreviewPanel.setTextBorderColor(NPCDialogPanel.this.dataControl.getTextBorderColor());
            JDialog jDialog = null;
            if (this.color == 0) {
                jDialog = JColorChooser.createDialog(null, TC.get((String)"Player.FrontColor"), true, this.colorChooser, new UpdateColorListener(), null);
            } else if (this.color == 1) {
                jDialog = JColorChooser.createDialog(null, TC.get((String)"Player.BorderColor"), true, this.colorChooser, new UpdateColorListener(), null);
            } else if (this.color == 2) {
                jDialog = JColorChooser.createDialog(null, TC.get((String)"Player.BubbleBkgColor"), true, this.colorChooser, new UpdateColorListener(), null);
            } else if (this.color == 3) {
                jDialog = JColorChooser.createDialog(null, TC.get((String)"Player.BubbleBorderColor"), true, this.colorChooser, new UpdateColorListener(), null);
            }
            jDialog.setResizable(false);
            jDialog.setVisible(true);
        }

        private class UpdatePreviewPanelListener
        implements ChangeListener {
            private UpdatePreviewPanelListener() {
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (ChangeTextColorListener.this.color == 0) {
                    ChangeTextColorListener.this.colorPreviewPanel.setTextFrontColor(ChangeTextColorListener.this.colorChooser.getColor());
                } else if (ChangeTextColorListener.this.color == 1) {
                    ChangeTextColorListener.this.colorPreviewPanel.setTextBorderColor(ChangeTextColorListener.this.colorChooser.getColor());
                } else if (ChangeTextColorListener.this.color == 2) {
                    ChangeTextColorListener.this.colorPreviewPanel.setBubbleBkgColor(ChangeTextColorListener.this.colorChooser.getColor());
                } else if (ChangeTextColorListener.this.color == 3) {
                    ChangeTextColorListener.this.colorPreviewPanel.setBubbleBorderColor(ChangeTextColorListener.this.colorChooser.getColor());
                }
            }
        }

        private class UpdateColorListener
        implements ActionListener {
            private UpdateColorListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ChangeTextColorListener.this.color == 0) {
                    NPCDialogPanel.this.dataControl.setTextFrontColor(ChangeTextColorListener.this.colorChooser.getColor());
                    NPCDialogPanel.this.textPreviewPanel.setTextFrontColor(ChangeTextColorListener.this.colorChooser.getColor());
                } else if (ChangeTextColorListener.this.color == 1) {
                    NPCDialogPanel.this.dataControl.setTextBorderColor(ChangeTextColorListener.this.colorChooser.getColor());
                    NPCDialogPanel.this.textPreviewPanel.setTextBorderColor(ChangeTextColorListener.this.colorChooser.getColor());
                } else if (ChangeTextColorListener.this.color == 2) {
                    NPCDialogPanel.this.dataControl.setBubbleBkgColor(ChangeTextColorListener.this.colorChooser.getColor());
                    NPCDialogPanel.this.textPreviewPanel.setBubbleBkgColor(ChangeTextColorListener.this.colorChooser.getColor());
                } else if (ChangeTextColorListener.this.color == 3) {
                    NPCDialogPanel.this.dataControl.setBubbleBorderColor(ChangeTextColorListener.this.colorChooser.getColor());
                    NPCDialogPanel.this.textPreviewPanel.setBubbleBorderColor(ChangeTextColorListener.this.colorChooser.getColor());
                }
            }
        }
    }

    private class VoiceCheckVoxListener
    implements ItemListener {
        private VoiceCheckVoxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            NPCDialogPanel.this.dataControl.setAlwaysSynthesizer(NPCDialogPanel.this.alwaysSynthesizer.isSelected());
        }
    }

    private class VoiceButtonListener
    implements ActionListener {
        private VoiceButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (NPCDialogPanel.this.voicesComboBox.getSelectedIndex() != 0 && NPCDialogPanel.this.trySynthesizer.getText() != null) {
                VoiceManager voiceManager = VoiceManager.getInstance();
                Voice voice = voiceManager.getVoice((String)NPCDialogPanel.this.voicesComboBox.getSelectedItem());
                voice.allocate();
                voice.speak(NPCDialogPanel.this.trySynthesizer.getText());
            }
        }
    }

    private class VoiceComboBoxListener
    implements ItemListener {
        private VoiceComboBoxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl;
            int n = NPCDialogPanel.this.voicesComboBox.getSelectedIndex();
            boolean bl2 = n != 0;
            boolean bl3 = bl = NPCDialogPanel.this.dataControl.getVoice() != null && !NPCDialogPanel.this.dataControl.getVoice().equals(new String(""));
            if (bl != bl2) {
                NPCDialogPanel.this.alwaysSynthesizer.setEnabled(bl2);
                NPCDialogPanel.this.trySynthesizer.setText("");
                NPCDialogPanel.this.trySynthesizer.setEnabled(bl2);
                NPCDialogPanel.this.playText.setEnabled(bl2);
            }
            if (n != 0) {
                NPCDialogPanel.this.dataControl.setVoice((String)NPCDialogPanel.this.voicesComboBox.getSelectedItem());
            } else {
                NPCDialogPanel.this.dataControl.setVoice(new String(""));
            }
        }
    }
}

