/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.book;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.book.BookPage;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.book.BookPagesListDataControl;
import es.eucm.eadventure.editor.gui.editdialogs.HTMLEditDialog;
import es.eucm.eadventure.editor.gui.elementpanels.book.BookPagesPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ResourceCellRendererEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private static final long serialVersionUID = 8128260157985286632L;
    private BookPage value;
    private JTextField textField;
    private JButton createButton;
    private JButton editButton;
    private JButton selectButton;
    private JLabel validPage;
    private BookPagesListDataControl control;
    private BookPagesPanel parentPanel;
    private boolean oldValid;

    public ResourceCellRendererEditor(BookPagesListDataControl bookPagesListDataControl, BookPagesPanel bookPagesPanel) {
        this.control = bookPagesListDataControl;
        this.parentPanel = bookPagesPanel;
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.value = (BookPage)object;
        return this.createComponent(bl, jTable.getSelectionBackground());
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.value = (BookPage)object;
        if (jTable.getSelectedRow() == n) {
            return this.createComponent(bl, jTable.getSelectionBackground());
        }
        this.validPage = new JLabel();
        this.validateContentSource();
        return new JLabel(this.value.getUri(), this.validPage.getIcon(), 2);
    }

    private Component createComponent(boolean bl, Color color) {
        JPanel jPanel = new JPanel();
        if (bl) {
            jPanel.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 0, color));
        }
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.validPage = new JLabel();
        this.validateContentSource();
        this.validPage.setPreferredSize(new Dimension(16, 16));
        jPanel.add((Component)this.validPage, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.textField = this.value == null ? new JTextField("") : new JTextField(this.value.getUri());
        this.textField.setEditable(this.value != null && this.value.getType() == 0);
        this.textField.getDocument().addDocumentListener(new URLChangeListener());
        jPanel.add((Component)this.textField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        JPanel jPanel2 = new JPanel();
        this.selectButton = new JButton(TC.get((String)"Resources.Select"));
        this.selectButton.addActionListener(new ExamineButtonListener());
        this.selectButton.setEnabled(this.value != null && !this.textField.isEditable());
        jPanel2.add(this.selectButton);
        this.createButton = new JButton(TC.get((String)"Resources.Create"));
        this.createButton.addActionListener(new CreateButtonListener());
        this.createButton.setEnabled(this.value != null && !this.textField.isEditable() && this.value.getType() != 2);
        jPanel2.add(this.createButton);
        this.editButton = new JButton(TC.get((String)"Resources.Edit"));
        this.editButton.addActionListener(new EditButtonListener());
        this.editButton.setEnabled(this.value != null && !this.textField.isEditable() && this.textField.getText().length() > 0 && this.value.getType() != 2);
        jPanel2.add(this.editButton);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    private void validateContentSource() {
        ImageIcon imageIcon = new ImageIcon("img/icons/deleteContent.png");
        ImageIcon imageIcon2 = new ImageIcon("img/icons/okIcon.png");
        if (this.value == null || !this.control.isValidPage(this.value)) {
            this.validPage.setIcon(imageIcon);
            if (this.value == null || this.value.getType() == 0) {
                this.validPage.setToolTipText(TC.get((String)"BookPage.NotValidURL"));
            } else if (this.value == null || this.value.getType() == 2) {
                this.validPage.setToolTipText(TC.get((String)"BookPage.NotValidImage"));
            } else {
                this.validPage.setToolTipText(TC.get((String)"BookPage.NotValidResource"));
            }
            this.oldValid = false;
        } else {
            this.validPage.setIcon(imageIcon2);
            this.validPage.setToolTipText(TC.get((String)"BookPage.Valid"));
            if (!this.oldValid) {
                this.parentPanel.updatePreview();
            }
            this.oldValid = true;
        }
    }

    private class EditButtonListener
    implements ActionListener {
        private EditButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = null;
            if (ResourceCellRendererEditor.this.control.getSelectedPage().getUri() != null && ResourceCellRendererEditor.this.control.getSelectedPage().getUri().compareTo("") != 0) {
                string = Controller.getInstance().getProjectFolder() + "/" + ResourceCellRendererEditor.this.control.getSelectedPage().getUri();
            }
            HTMLEditDialog hTMLEditDialog = new HTMLEditDialog(string, null);
            File file = new File(hTMLEditDialog.getHtmlEditController().getFilename());
            String string2 = "assets/styledtext/" + file.getName();
            ResourceCellRendererEditor.this.control.getSelectedPage().setUri(string2);
            ResourceCellRendererEditor.this.textField.setText(ResourceCellRendererEditor.this.control.getSelectedPage().getUri());
        }
    }

    private class CreateButtonListener
    implements ActionListener {
        private CreateButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = null;
            string = AssetsController.TempFileGenerator.generateTempFileAbsolutePath("html");
            File file = new File(string);
            try {
                file.createNewFile();
                AssetsController.addSingleAsset(7, file.getAbsolutePath());
                String string2 = "assets/styledtext/" + file.getName();
                ResourceCellRendererEditor.this.control.getSelectedPage().setUri(string2);
                ResourceCellRendererEditor.this.textField.setText(ResourceCellRendererEditor.this.control.getSelectedPage().getUri());
                ResourceCellRendererEditor.this.editButton.setEnabled(true);
                ResourceCellRendererEditor.this.parentPanel.updatePreview();
            }
            catch (IOException iOException) {
                ReportDialog.GenerateErrorReport((Exception)iOException, (boolean)true, (String)"UNKNOWERROR");
            }
        }
    }

    private class ExamineButtonListener
    implements ActionListener {
        private ExamineButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ResourceCellRendererEditor.this.control.getSelectedPage().getType() == 1 || ResourceCellRendererEditor.this.control.getSelectedPage().getType() == 2) {
                if (ResourceCellRendererEditor.this.control.getSelectedPage().getType() == 1 && ResourceCellRendererEditor.this.control.editStyledTextAssetPath()) {
                    ResourceCellRendererEditor.this.textField.setText(ResourceCellRendererEditor.this.control.getSelectedPage().getUri());
                    ResourceCellRendererEditor.this.editButton.setEnabled(true);
                    ResourceCellRendererEditor.this.validateContentSource();
                } else if (ResourceCellRendererEditor.this.control.getSelectedPage().getType() == 2 && ResourceCellRendererEditor.this.control.editImageAssetPath()) {
                    ResourceCellRendererEditor.this.textField.setText(ResourceCellRendererEditor.this.control.getSelectedPage().getUri());
                    ResourceCellRendererEditor.this.editButton.setEnabled(true);
                    ResourceCellRendererEditor.this.validateContentSource();
                }
            }
            ResourceCellRendererEditor.this.parentPanel.updatePreview();
        }
    }

    private class URLChangeListener
    implements DocumentListener {
        private Thread updater;
        private boolean stop = false;
        private boolean changed = false;
        private long lastUpdate = -1L;

        private synchronized void setChanged(boolean bl) {
            this.changed = bl;
        }

        private synchronized boolean hasChanged() {
            return this.changed;
        }

        private synchronized long getLastUpdate() {
            return this.lastUpdate;
        }

        private synchronized void setLastUpdate(long l) {
            this.lastUpdate = l;
        }

        private synchronized boolean isStop() {
            return this.stop;
        }

        public synchronized void stop() {
            this.stop = true;
        }

        public URLChangeListener() {
            this.updater = new Thread(){

                @Override
                public void run() {
                    while (!URLChangeListener.this.isStop()) {
                        if (URLChangeListener.this.getLastUpdate() != -1L && System.currentTimeMillis() - URLChangeListener.this.getLastUpdate() > 1000L && URLChangeListener.this.hasChanged() && ResourceCellRendererEditor.this.control.getSelectedPage() != null && ResourceCellRendererEditor.this.control.getSelectedPage().getType() == 0 && ResourceCellRendererEditor.this.control.editURL(ResourceCellRendererEditor.this.textField.getText())) {
                            ResourceCellRendererEditor.this.validateContentSource();
                            URLChangeListener.this.setChanged(false);
                        }
                        try {
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            };
            this.updater.start();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setLastUpdate(System.currentTimeMillis());
            this.setChanged(true);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.insertUpdate(documentEvent);
        }
    }
}

