/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.book;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.book.BookParagraphDataControl;
import es.eucm.eadventure.editor.control.controllers.book.BookParagraphsListDataControl;
import es.eucm.eadventure.editor.gui.elementpanels.book.IconTextPanel;
import es.eucm.eadventure.editor.gui.elementpanels.book.ParagraphCellRendererEditor;
import es.eucm.eadventure.editor.gui.otherpanels.bookpanels.BookParagraphPreviewPanel;
import java.awt.Component;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class ParagraphsTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private BookParagraphsListDataControl dataControl;

    public ParagraphsTable(BookParagraphsListDataControl bookParagraphsListDataControl, BookParagraphPreviewPanel bookParagraphPreviewPanel) {
        this.setModel(new ParagraphsTableModel());
        this.getColumnModel().setColumnSelectionAllowed(false);
        this.setDragEnabled(false);
        this.getColumnModel().getColumn(0).setMaxWidth(130);
        this.getColumnModel().getColumn(0).setMinWidth(130);
        this.getColumnModel().getColumn(0).setCellRenderer(new ParagraphsTableCellRenderer());
        this.getColumnModel().getColumn(1).setCellEditor(new ParagraphCellRendererEditor(bookParagraphPreviewPanel));
        this.getColumnModel().getColumn(1).setCellRenderer(new ParagraphCellRendererEditor(bookParagraphPreviewPanel));
        this.getSelectionModel().setSelectionMode(0);
        this.dataControl = bookParagraphsListDataControl;
        this.setRowHeight(22);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ParagraphsTable.this.setRowHeight(22);
                if (ParagraphsTable.this.getSelectedRow() != -1) {
                    ParagraphsTable.this.setRowHeight(ParagraphsTable.this.getSelectedRow(), 50);
                }
            }
        });
    }

    private class ParagraphsTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private ParagraphsTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof BookParagraphDataControl) {
                String string = TC.getElement((int)((BookParagraphDataControl)object).getType());
                if (((BookParagraphDataControl)object).getType() == 14) {
                    return new IconTextPanel("img/icons/titleBookParagraph.png", string, bl);
                }
                if (((BookParagraphDataControl)object).getType() == 16) {
                    return new IconTextPanel("img/icons/bulletBookParagraph.png", string, bl);
                }
                if (((BookParagraphDataControl)object).getType() == 15) {
                    return new IconTextPanel("img/icons/textBookParagraph.png", string, bl);
                }
                if (((BookParagraphDataControl)object).getType() == 17) {
                    return new IconTextPanel("img/icons/imageBookParagraph.png", string, bl);
                }
                return null;
            }
            return new JLabel(object.toString());
        }
    }

    private class ParagraphsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private ParagraphsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ParagraphsTable.this.dataControl.getBookParagraphs().size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                List<BookParagraphDataControl> list = ParagraphsTable.this.dataControl.getBookParagraphs();
                return list.get(n);
            }
            if (n2 == 1) {
                return ParagraphsTable.this.dataControl.getBookParagraphs().get(n);
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return TC.get((String)"BookParagraphsList.ParagraphType");
            }
            if (n == 1) {
                return TC.get((String)"BookParagraphsList.Content");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n == ParagraphsTable.this.getSelectedRow() && n2 > 0;
        }
    }
}

