/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.book;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.book.BookParagraphDataControl;
import es.eucm.eadventure.editor.gui.otherpanels.bookpanels.BookParagraphPreviewPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ParagraphCellRendererEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private static final long serialVersionUID = 8128260157985286632L;
    private BookParagraphDataControl value;
    private JTextPane textPane;
    private JTextField textField;
    private BookParagraphPreviewPanel previewPanel;

    public ParagraphCellRendererEditor(BookParagraphPreviewPanel bookParagraphPreviewPanel) {
        this.previewPanel = bookParagraphPreviewPanel;
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.value = (BookParagraphDataControl)object;
        return this.createComponent(bl, jTable.getSelectionBackground());
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.value = (BookParagraphDataControl)object;
        if (jTable.getSelectedRow() == n) {
            return this.createComponent(bl, jTable.getSelectionBackground());
        }
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        String string = "";
        if (this.value != null) {
            if (this.value.getType() == 14 || this.value.getType() == 15 || this.value.getType() == 16) {
                string = this.value.getParagraphContent();
            }
            if (this.value.getType() == 17) {
                return new JLabel(this.value.getParagraphContent());
            }
        }
        string.replace('\n', '\\');
        return new JLabel(string);
    }

    private Component createComponent(boolean bl, Color color) {
        JPanel jPanel = new JPanel();
        if (bl) {
            jPanel.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 0, color));
        }
        if (this.value != null) {
            if (this.value.getType() == 14 || this.value.getType() == 15 || this.value.getType() == 16) {
                this.createTextPanel(jPanel);
            }
            if (this.value.getType() == 17) {
                this.createImagePanel(jPanel);
            }
        }
        return jPanel;
    }

    private void createTextPanel(JPanel jPanel) {
        this.textPane = new JTextPane();
        this.textPane.setText(this.value.getParagraphContent());
        this.textPane.setAutoscrolls(true);
        this.textPane.getDocument().addDocumentListener(new TextAreaChangesListener());
        JScrollPane jScrollPane = new JScrollPane(this.textPane, 20, 31);
        jScrollPane.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ParagraphCellRendererEditor.this.textPane.requestFocusInWindow();
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        this.textPane.requestFocusInWindow();
    }

    private void createImagePanel(JPanel jPanel) {
        ImageIcon imageIcon = new ImageIcon("img/icons/deleteContent.png");
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JButton jButton = new JButton(imageIcon);
        jButton.addActionListener(new DeleteContentButtonListener());
        jButton.setPreferredSize(new Dimension(20, 20));
        jButton.setMaximumSize(new Dimension(20, 20));
        jButton.setToolTipText(TC.get((String)"Resources.DeleteAsset"));
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.textField = new JTextField(this.value.getParagraphContent());
        this.textField.setEditable(false);
        jPanel.add((Component)this.textField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        JButton jButton2 = new JButton(TC.get((String)"Resources.Select"));
        jButton2.addActionListener(new ExamineButtonListener());
        jPanel.add((Component)jButton2, gridBagConstraints);
    }

    private class ExamineButtonListener
    implements ActionListener {
        private ExamineButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ParagraphCellRendererEditor.this.value.editImagePath();
            ParagraphCellRendererEditor.this.textField.setText(ParagraphCellRendererEditor.this.value.getParagraphContent());
            ParagraphCellRendererEditor.this.previewPanel.updatePreview();
        }
    }

    private class DeleteContentButtonListener
    implements ActionListener {
        private DeleteContentButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ParagraphCellRendererEditor.this.textField.setText(null);
            ParagraphCellRendererEditor.this.value.deleteImageParagraphContent();
            ParagraphCellRendererEditor.this.previewPanel.updatePreview();
        }
    }

    private class TextAreaChangesListener
    implements DocumentListener {
        private TextAreaChangesListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            ParagraphCellRendererEditor.this.value.setParagraphTextContent(ParagraphCellRendererEditor.this.textPane.getText());
            ParagraphCellRendererEditor.this.previewPanel.updatePreview();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            ParagraphCellRendererEditor.this.value.setParagraphTextContent(ParagraphCellRendererEditor.this.textPane.getText());
            ParagraphCellRendererEditor.this.previewPanel.updatePreview();
        }
    }
}

