/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.book;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.book.BookPagesListDataControl;
import es.eucm.eadventure.editor.gui.elementpanels.book.BookPagesPanel;
import es.eucm.eadventure.editor.gui.elementpanels.book.ContentTypeCellRendererEditor;
import es.eucm.eadventure.editor.gui.elementpanels.book.MarginsCellRendererEditor;
import es.eucm.eadventure.editor.gui.elementpanels.book.ResourceCellRendererEditor;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class PagesTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private BookPagesListDataControl dataControl;

    public PagesTable(BookPagesListDataControl bookPagesListDataControl, BookPagesPanel bookPagesPanel) {
        this.setModel(new ParagraphsTableModel());
        this.getColumnModel().setColumnSelectionAllowed(false);
        this.setDragEnabled(false);
        this.getColumnModel().getColumn(0).setCellEditor(new ContentTypeCellRendererEditor(bookPagesListDataControl));
        this.getColumnModel().getColumn(0).setCellRenderer(new ContentTypeCellRendererEditor(bookPagesListDataControl));
        this.getColumnModel().getColumn(0).setMaxWidth(160);
        this.getColumnModel().getColumn(0).setMinWidth(140);
        this.getColumnModel().getColumn(1).setCellEditor(new ResourceCellRendererEditor(bookPagesListDataControl, bookPagesPanel));
        this.getColumnModel().getColumn(1).setCellRenderer(new ResourceCellRendererEditor(bookPagesListDataControl, bookPagesPanel));
        this.getColumnModel().getColumn(2).setCellEditor(new MarginsCellRendererEditor(bookPagesListDataControl, bookPagesPanel));
        this.getColumnModel().getColumn(2).setCellRenderer(new MarginsCellRendererEditor(bookPagesListDataControl, bookPagesPanel));
        this.getColumnModel().getColumn(2).setMaxWidth(130);
        this.getColumnModel().getColumn(2).setMinWidth(130);
        this.getSelectionModel().setSelectionMode(0);
        this.dataControl = bookPagesListDataControl;
        this.setRowHeight(22);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PagesTable.this.setRowHeight(22);
                if (PagesTable.this.getSelectedRow() != -1) {
                    PagesTable.this.setRowHeight(PagesTable.this.getSelectedRow(), 65);
                }
            }
        });
    }

    private class ParagraphsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private ParagraphsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return PagesTable.this.dataControl.getBookPages().size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return PagesTable.this.dataControl.getBookPages().get(n);
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return TC.get((String)"BookPagesList.Type");
            }
            if (n == 1) {
                return TC.get((String)"BookPagesList.Content");
            }
            if (n == 2) {
                return TC.get((String)"BookPagesList.Margins");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n == PagesTable.this.getSelectedRow();
        }
    }
}

