/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.book;

import es.eucm.eadventure.common.data.chapter.book.BookPage;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.book.BookPagesListDataControl;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ContentTypeCellRendererEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private static final long serialVersionUID = 8128260157985286632L;
    private BookPage value;
    private int row;
    private JComboBox typeCombo;
    private BookPagesListDataControl control;

    public ContentTypeCellRendererEditor(BookPagesListDataControl bookPagesListDataControl) {
        this.control = bookPagesListDataControl;
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.value = (BookPage)object;
        this.row = n;
        return this.createComponent(bl, jTable.getSelectionBackground(), jTable);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.value = (BookPage)object;
        this.row = n;
        if (jTable.getSelectedRow() == n) {
            return this.createComponent(bl, jTable.getSelectionBackground(), jTable);
        }
        if (this.value.getType() == 1) {
            return new JLabel(TC.get((String)"BookPageType.Resource"));
        }
        if (this.value.getType() == 0) {
            return new JLabel(TC.get((String)"BookPageType.URL"));
        }
        if (this.value.getType() == 2) {
            return new JLabel(TC.get((String)"BookPageType.Image"));
        }
        return new JLabel("");
    }

    private Component createComponent(boolean bl, Color color, JTable jTable) {
        JPanel jPanel = new JPanel();
        if (bl) {
            jPanel.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 0, color));
        }
        String[] stringArray = new String[]{TC.get((String)"BookPageType.Resource"), TC.get((String)"BookPageType.URL"), TC.get((String)"BookPageType.Image")};
        this.typeCombo = new JComboBox<String>(stringArray);
        if (this.value.getType() == 1) {
            this.typeCombo.setSelectedIndex(0);
        } else if (this.value.getType() == 0) {
            this.typeCombo.setSelectedIndex(1);
        } else if (this.value.getType() == 2) {
            this.typeCombo.setSelectedIndex(2);
        }
        this.typeCombo.addActionListener(new OptionChangedListener(jTable));
        jPanel.add(this.typeCombo);
        return jPanel;
    }

    private class OptionChangedListener
    implements ActionListener {
        private JTable table;

        public OptionChangedListener(JTable jTable) {
            this.table = jTable;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ContentTypeCellRendererEditor.this.typeCombo.getSelectedIndex() == 0) {
                ContentTypeCellRendererEditor.this.control.setType(1);
            } else if (ContentTypeCellRendererEditor.this.typeCombo.getSelectedIndex() == 1) {
                ContentTypeCellRendererEditor.this.control.setType(0);
            } else if (ContentTypeCellRendererEditor.this.typeCombo.getSelectedIndex() == 2) {
                ContentTypeCellRendererEditor.this.control.setType(2);
            }
            ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
            this.table.changeSelection(ContentTypeCellRendererEditor.this.row, 0, false, false);
        }
    }
}

