/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.book;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.book.BookDataControl;
import es.eucm.eadventure.editor.control.controllers.book.BookParagraphDataControl;
import es.eucm.eadventure.editor.control.tools.books.AddParagraphElementTool;
import es.eucm.eadventure.editor.control.tools.books.DeleteParagraphElementTool;
import es.eucm.eadventure.editor.control.tools.books.MoveParagraphElementDownTool;
import es.eucm.eadventure.editor.control.tools.books.MoveParagraphElementUpTool;
import es.eucm.eadventure.editor.gui.DataControlsPanel;
import es.eucm.eadventure.editor.gui.auxiliar.components.JFiller;
import es.eucm.eadventure.editor.gui.elementpanels.book.ParagraphsTable;
import es.eucm.eadventure.editor.gui.elementpanels.general.TableScrollPane;
import es.eucm.eadventure.editor.gui.otherpanels.bookpanels.BookParagraphPreviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BookParagraphsPanel
extends JPanel
implements DataControlsPanel {
    private static final long serialVersionUID = 1L;
    public static final int VERTICAL_SPLIT_POSITION = 150;
    private BookDataControl dataControl;
    private JPanel paragraphsPanel;
    private ParagraphsTable paragraphsTable;
    private BookParagraphPreviewPanel previewPanel;
    private JButton deleteButton;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JSplitPane infoAndPreview;

    public BookParagraphsPanel(BookDataControl bookDataControl) {
        this.dataControl = bookDataControl;
        this.previewPanel = new BookParagraphPreviewPanel(bookDataControl, bookDataControl.getBookParagraphsList());
        this.createParagraphsPanel(this.previewPanel);
        this.paragraphsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                BookParagraphsPanel.this.updateSelectedParagraph();
            }
        });
        this.previewPanel.setMinimumSize(new Dimension(100, 150));
        this.paragraphsPanel.setMinimumSize(new Dimension(0, 100));
        this.infoAndPreview = new JSplitPane(0, this.paragraphsPanel, this.previewPanel);
        this.infoAndPreview.setOneTouchExpandable(true);
        this.infoAndPreview.setDividerLocation(150);
        this.infoAndPreview.setResizeWeight(0.0);
        this.infoAndPreview.setDividerSize(10);
        this.infoAndPreview.setContinuousLayout(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.infoAndPreview, "Center");
    }

    private void updateSelectedParagraph() {
        if (this.paragraphsTable.getSelectedRow() < 0 || this.paragraphsTable.getSelectedRow() >= this.dataControl.getBookParagraphsList().getBookParagraphs().size()) {
            this.deleteButton.setEnabled(false);
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
        } else {
            this.deleteButton.setEnabled(true);
            this.moveUpButton.setEnabled(this.dataControl.getBookParagraphsList().getBookParagraphs().size() > 1 && this.paragraphsTable.getSelectedRow() > 0);
            this.moveDownButton.setEnabled(this.dataControl.getBookParagraphsList().getBookParagraphs().size() > 1 && this.paragraphsTable.getSelectedRow() < this.paragraphsTable.getRowCount() - 1);
        }
        this.previewPanel.updatePreview();
    }

    private void createParagraphsPanel(BookParagraphPreviewPanel bookParagraphPreviewPanel) {
        this.paragraphsPanel = new JPanel();
        this.paragraphsPanel.setLayout(new BorderLayout());
        this.paragraphsTable = new ParagraphsTable(this.dataControl.getBookParagraphsList(), bookParagraphPreviewPanel);
        this.paragraphsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    MouseEvent mouseEvent2 = new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), 16, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    for (MouseListener mouseListener : mouseEvent.getComponent().getMouseListeners()) {
                        mouseListener.mousePressed(mouseEvent2);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    JPopupMenu jPopupMenu = BookParagraphsPanel.this.getCompletePopupMenu();
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.paragraphsPanel.add((Component)new TableScrollPane(this.paragraphsTable, 22, 31), "Center");
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(new ImageIcon("img/icons/addNode.png"));
        jButton.setContentAreaFilled(false);
        jButton.setFocusable(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setToolTipText(TC.get((String)"BookParagraphs.AddParagraph"));
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu = BookParagraphsPanel.this.getAddChildPopupMenu();
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
        this.deleteButton = new JButton(new ImageIcon("img/icons/deleteNode.png"));
        this.deleteButton.setContentAreaFilled(false);
        this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteButton.setBorder(BorderFactory.createEmptyBorder());
        this.deleteButton.setFocusable(false);
        this.deleteButton.setToolTipText(TC.get((String)"BookParagraphs.DeleteParagraph"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BookParagraphsPanel.this.delete();
            }
        });
        this.moveUpButton = new JButton(new ImageIcon("img/icons/moveNodeUp.png"));
        this.moveUpButton.setContentAreaFilled(false);
        this.moveUpButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveUpButton.setBorder(BorderFactory.createEmptyBorder());
        this.moveUpButton.setFocusable(false);
        this.moveUpButton.setToolTipText(TC.get((String)"BookParagraphs.MoveParagraphUp"));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BookParagraphsPanel.this.moveUp();
            }
        });
        this.moveDownButton = new JButton(new ImageIcon("img/icons/moveNodeDown.png"));
        this.moveDownButton.setContentAreaFilled(false);
        this.moveDownButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveDownButton.setBorder(BorderFactory.createEmptyBorder());
        this.moveDownButton.setFocusable(false);
        this.moveDownButton.setToolTipText(TC.get((String)"BookParagraphs.MoveParagraphDown"));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BookParagraphsPanel.this.moveDown();
            }
        });
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.moveUpButton, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.moveDownButton, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.deleteButton, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)new JFiller(), gridBagConstraints);
        this.paragraphsPanel.add((Component)jPanel, "East");
    }

    public JPopupMenu getAddChildPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.dataControl.getBookParagraphsList().getAddableElements().length > 0) {
            for (int n : this.dataControl.getBookParagraphsList().getAddableElements()) {
                JMenuItem jMenuItem = new JMenuItem(TC.get((String)("TreeNode.AddElement" + n)));
                jMenuItem.setEnabled(true);
                jMenuItem.addActionListener(new AddElementActionListener(n));
                jPopupMenu.add(jMenuItem);
            }
        } else {
            JMenuItem jMenuItem = new JMenuItem(TC.get((String)"TreeNode.AddElement"));
            jMenuItem.setEnabled(false);
            jPopupMenu.add(jMenuItem);
        }
        return jPopupMenu;
    }

    public JPopupMenu getCompletePopupMenu() {
        JPopupMenu jPopupMenu = this.getAddChildPopupMenu();
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem(TC.get((String)"TreeNode.DeleteElement"));
        jMenuItem.setEnabled(this.deleteButton.isEnabled());
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BookParagraphsPanel.this.delete();
            }
        });
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem(TC.get((String)"TreeNode.MoveElementUp"));
        JMenuItem jMenuItem3 = new JMenuItem(TC.get((String)"TreeNode.MoveElementDown"));
        jMenuItem2.setEnabled(this.moveUpButton.isEnabled());
        jMenuItem3.setEnabled(this.moveDownButton.isEnabled());
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BookParagraphsPanel.this.moveUp();
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BookParagraphsPanel.this.moveDown();
            }
        });
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.add(jMenuItem3);
        return jPopupMenu;
    }

    private void delete() {
        BookParagraphDataControl bookParagraphDataControl = this.dataControl.getBookParagraphsList().getBookParagraphs().get(this.paragraphsTable.getSelectedRow());
        Controller.getInstance().addTool(new DeleteParagraphElementTool(this.dataControl, bookParagraphDataControl));
        this.paragraphsTable.clearSelection();
        this.paragraphsTable.updateUI();
    }

    private void moveUp() {
        int n = this.paragraphsTable.getSelectedRow();
        BookParagraphDataControl bookParagraphDataControl = this.dataControl.getBookParagraphsList().getBookParagraphs().get(n);
        Controller.getInstance().addTool(new MoveParagraphElementUpTool(this.dataControl, bookParagraphDataControl));
        this.paragraphsTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
        this.paragraphsTable.updateUI();
    }

    private void moveDown() {
        int n = this.paragraphsTable.getSelectedRow();
        BookParagraphDataControl bookParagraphDataControl = this.dataControl.getBookParagraphsList().getBookParagraphs().get(n);
        Controller.getInstance().addTool(new MoveParagraphElementDownTool(this.dataControl, bookParagraphDataControl));
        this.paragraphsTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
        this.paragraphsTable.updateUI();
    }

    @Override
    public void setSelectedItem(List<Searchable> list) {
        if (list.size() > 0) {
            for (int i = 0; i < this.dataControl.getBookParagraphsList().getBookParagraphs().size(); ++i) {
                if (this.dataControl.getBookParagraphsList().getBookParagraphs().get(i) != list.get(list.size() - 1)) continue;
                this.paragraphsTable.changeSelection(i, i, false, false);
            }
        }
    }

    private class AddElementActionListener
    implements ActionListener {
        int type;

        public AddElementActionListener(int n) {
            this.type = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = BookParagraphsPanel.this.paragraphsTable.getSelectedRow();
            Controller.getInstance().addTool(new AddParagraphElementTool(BookParagraphsPanel.this.dataControl, this.type, n));
            BookParagraphsPanel.this.paragraphsTable.clearSelection();
            if (n != -1 && n < BookParagraphsPanel.this.dataControl.getBookParagraphsList().getBookParagraphs().size() - 1) {
                BookParagraphsPanel.this.paragraphsTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
            }
            BookParagraphsPanel.this.paragraphsTable.updateUI();
        }
    }
}

