/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.book;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.book.BookDataControl;
import es.eucm.eadventure.editor.gui.elementpanels.ElementPanel;
import es.eucm.eadventure.editor.gui.elementpanels.PanelTab;
import es.eucm.eadventure.editor.gui.elementpanels.book.BookAppPanel;
import es.eucm.eadventure.editor.gui.elementpanels.book.BookDocPanel;
import es.eucm.eadventure.editor.gui.elementpanels.book.BookPagesPanel;
import es.eucm.eadventure.editor.gui.elementpanels.book.BookParagraphsPanel;
import javax.swing.JComponent;

public class BookPanel
extends ElementPanel {
    private static final long serialVersionUID = 1L;

    public BookPanel(BookDataControl bookDataControl) {
        this.addTab(new BookContentPanel(bookDataControl));
        this.addTab(new BookAppPanelTab(bookDataControl));
        this.addTab(new BookDocPanelTab(bookDataControl));
    }

    private class BookContentPanel
    extends PanelTab {
        private BookDataControl dataControl;

        public BookContentPanel(BookDataControl bookDataControl) {
            super(TC.get((String)"Book.Contents"), bookDataControl);
            this.setToolTipText(TC.get((String)"Book.Contents.Tip"));
            this.dataControl = bookDataControl;
        }

        @Override
        protected JComponent getTabComponent() {
            if (this.dataControl.getType() == 0) {
                return new BookParagraphsPanel(this.dataControl);
            }
            return new BookPagesPanel(this.dataControl);
        }

        @Override
        public DataControl getDataControl() {
            if (this.dataControl.getType() == 0) {
                return this.dataControl.getBookParagraphsList();
            }
            return super.getDataControl();
        }
    }

    private class BookAppPanelTab
    extends PanelTab {
        private BookDataControl dataControl;

        public BookAppPanelTab(BookDataControl bookDataControl) {
            super(TC.get((String)"Book.App"), bookDataControl);
            this.setToolTipText(TC.get((String)"Book.App.Tip"));
            this.dataControl = bookDataControl;
        }

        @Override
        protected JComponent getTabComponent() {
            return new BookAppPanel(this.dataControl);
        }
    }

    private class BookDocPanelTab
    extends PanelTab {
        private BookDataControl dataControl;

        public BookDocPanelTab(BookDataControl bookDataControl) {
            super(TC.get((String)"Book.Doc"), bookDataControl);
            this.setToolTipText(TC.get((String)"Book.Doc.Tip"));
            this.dataControl = bookDataControl;
        }

        @Override
        protected JComponent getTabComponent() {
            return new BookDocPanel(this.dataControl);
        }
    }
}

