/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.book;

import es.eucm.eadventure.common.data.chapter.book.BookPage;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.book.BookDataControl;
import es.eucm.eadventure.editor.control.controllers.book.BookPagesListDataControl;
import es.eucm.eadventure.editor.gui.auxiliar.components.JFiller;
import es.eucm.eadventure.editor.gui.displaydialogs.StyledBookDialog;
import es.eucm.eadventure.editor.gui.editdialogs.ExportBookDialog;
import es.eucm.eadventure.editor.gui.elementpanels.book.PagesTable;
import es.eucm.eadventure.editor.gui.elementpanels.general.TableScrollPane;
import es.eucm.eadventure.editor.gui.otherpanels.bookpanels.BookPagePreviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class BookPagesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private BookDataControl dataControl;
    private JPanel pagesPanel;
    private PagesTable pagesTable;
    private JPanel previewPanelContainer;
    private JButton deleteButton;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JSplitPane infoAndPreview;
    private BookPagePreviewPanel bookPanel;

    public BookPagesPanel(BookDataControl bookDataControl) {
        this.dataControl = bookDataControl;
        this.createPagesPanel();
        this.previewPanelContainer = new JPanel();
        this.previewPanelContainer.setLayout(new BorderLayout());
        this.bookPanel = new BookPagePreviewPanel(this.dataControl, false, this.pagesTable);
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(TC.get((String)"Book.Preview"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StyledBookDialog styledBookDialog = new StyledBookDialog(BookPagesPanel.this.dataControl);
                styledBookDialog.setVisible(true);
            }
        });
        JButton jButton2 = new JButton(TC.get((String)"Export.Book"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportBookDialog exportBookDialog = new ExportBookDialog(BookPagesPanel.this.dataControl);
                exportBookDialog.setVisible(true);
            }
        });
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.previewPanelContainer.add((Component)jPanel, "South");
        this.updateSelectedPage();
        this.previewPanelContainer.setMinimumSize(new Dimension(100, 150));
        this.pagesPanel.setMinimumSize(new Dimension(0, 150));
        this.infoAndPreview = new JSplitPane(0, this.pagesPanel, this.previewPanelContainer);
        this.infoAndPreview.setOneTouchExpandable(true);
        this.infoAndPreview.setDividerLocation(150);
        this.infoAndPreview.setResizeWeight(0.0);
        this.infoAndPreview.setDividerSize(10);
        this.infoAndPreview.setContinuousLayout(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.infoAndPreview, "Center");
        if (this.dataControl.getBookPagesList().getSelectedPage() != null) {
            int n = this.dataControl.getBookPagesList().getBookPages().indexOf(this.dataControl.getBookPagesList().getSelectedPage());
            this.pagesTable.changeSelection(n, 0, false, false);
        }
    }

    public void updatePreview() {
        BookPage bookPage = this.dataControl.getBookPagesList().getSelectedPage();
        if (bookPage != null) {
            this.previewPanelContainer.updateUI();
        }
    }

    private void updateSelectedPage() {
        int n = this.pagesTable.getSelectedRow();
        this.dataControl.getBookPagesList().changeCurrentPage(n);
        if (n < 0 || n >= this.dataControl.getBookPagesList().getBookPages().size()) {
            this.deleteButton.setEnabled(false);
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
        } else {
            this.deleteButton.setEnabled(true);
            this.moveUpButton.setEnabled(this.dataControl.getBookPagesList().getBookPages().size() > 1 && n > 0);
            this.moveDownButton.setEnabled(this.dataControl.getBookPagesList().getBookPages().size() > 1 && n < this.pagesTable.getRowCount() - 1);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.ipadx = 800;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weighty = 0.9;
            this.bookPanel.setCurrentBookPage(n);
            this.previewPanelContainer.add((Component)this.bookPanel, "Center");
        }
        this.previewPanelContainer.updateUI();
        this.previewPanelContainer.repaint();
    }

    private void createPagesPanel() {
        this.pagesPanel = new JPanel();
        this.pagesPanel.setLayout(new BorderLayout());
        this.pagesTable = new PagesTable(this.dataControl.getBookPagesList(), this);
        this.pagesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    MouseEvent mouseEvent2 = new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), 16, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    for (MouseListener mouseListener : mouseEvent.getComponent().getMouseListeners()) {
                        mouseListener.mousePressed(mouseEvent2);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    JPopupMenu jPopupMenu = BookPagesPanel.this.getCompletePopupMenu();
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.pagesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    BookPagesPanel.this.setCursor(new Cursor(3));
                    BookPagesPanel.this.updateSelectedPage();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BookPagesPanel.this.setCursor(new Cursor(0));
                        }
                    });
                }
            }
        });
        this.pagesPanel.add((Component)new TableScrollPane(this.pagesTable, 22, 31), "Center");
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(new ImageIcon("img/icons/addNode.png"));
        jButton.setContentAreaFilled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setToolTipText(TC.get((String)"BookPages.AddPage"));
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                BookPagesPanel.this.addPage();
            }
        });
        this.deleteButton = new JButton(new ImageIcon("img/icons/deleteNode.png"));
        this.deleteButton.setContentAreaFilled(false);
        this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteButton.setBorder(BorderFactory.createEmptyBorder());
        this.deleteButton.setToolTipText(TC.get((String)"BookPages.DeletePage"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BookPagesPanel.this.deletePage();
            }
        });
        this.moveUpButton = new JButton(new ImageIcon("img/icons/moveNodeUp.png"));
        this.moveUpButton.setContentAreaFilled(false);
        this.moveUpButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveUpButton.setBorder(BorderFactory.createEmptyBorder());
        this.moveUpButton.setToolTipText(TC.get((String)"BookPages.MovePageUp"));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BookPagesPanel.this.movePageUp();
            }
        });
        this.moveDownButton = new JButton(new ImageIcon("img/icons/moveNodeDown.png"));
        this.moveDownButton.setContentAreaFilled(false);
        this.moveDownButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveDownButton.setBorder(BorderFactory.createEmptyBorder());
        this.moveDownButton.setToolTipText(TC.get((String)"BookPages.MovePageDown"));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BookPagesPanel.this.movePageDown();
            }
        });
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.moveUpButton, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.moveDownButton, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.deleteButton, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)new JFiller(), gridBagConstraints);
        this.pagesPanel.add((Component)jPanel, "East");
    }

    public JPopupMenu getCompletePopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(TC.get((String)"TreeNode.AddElement43"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BookPagesPanel.this.addPage();
            }
        });
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem(TC.get((String)"TreeNode.DeleteElement"));
        jMenuItem2.setEnabled(this.deleteButton.isEnabled());
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BookPagesPanel.this.deletePage();
            }
        });
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem(TC.get((String)"TreeNode.MoveElementUp"));
        JMenuItem jMenuItem4 = new JMenuItem(TC.get((String)"TreeNode.MoveElementDown"));
        jMenuItem3.setEnabled(this.moveUpButton.isEnabled());
        jMenuItem4.setEnabled(this.moveDownButton.isEnabled());
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BookPagesPanel.this.movePageUp();
            }
        });
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BookPagesPanel.this.movePageDown();
            }
        });
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.add(jMenuItem4);
        return jPopupMenu;
    }

    private void addPage() {
        if (this.dataControl.getBookPagesList().addPage() != null) {
            int n = this.pagesTable.getSelectedRow();
            n = n != -1 ? ++n : this.dataControl.getBookPagesList().getBookPages().size() - 1;
            this.pagesTable.clearSelection();
            ((AbstractTableModel)this.pagesTable.getModel()).fireTableDataChanged();
            this.pagesTable.changeSelection(n, 0, false, false);
        }
    }

    private void deletePage() {
        BookPagesListDataControl bookPagesListDataControl = this.dataControl.getBookPagesList();
        BookPage bookPage = bookPagesListDataControl.getSelectedPage();
        int n = bookPagesListDataControl.getIndexSelectedPage();
        if (bookPage != null && bookPagesListDataControl.deletePage(bookPage)) {
            this.pagesTable.clearSelection();
            ((AbstractTableModel)this.pagesTable.getModel()).fireTableDataChanged();
            int n2 = n - 1 >= 0 ? n - 1 : 0;
            this.pagesTable.changeSelection(n2, 0, false, false);
        }
    }

    private void movePageUp() {
        int n = this.pagesTable.getSelectedRow();
        BookPagesListDataControl bookPagesListDataControl = this.dataControl.getBookPagesList();
        BookPage bookPage = bookPagesListDataControl.getSelectedPage();
        if (bookPage != null && bookPagesListDataControl.movePageUp(bookPage)) {
            ((AbstractTableModel)this.pagesTable.getModel()).fireTableDataChanged();
            this.pagesTable.changeSelection(n - 1, 0, false, false);
        }
    }

    private void movePageDown() {
        int n = this.pagesTable.getSelectedRow();
        BookPagesListDataControl bookPagesListDataControl = this.dataControl.getBookPagesList();
        BookPage bookPage = bookPagesListDataControl.getSelectedPage();
        if (bookPage != null && bookPagesListDataControl.movePageDown(bookPage)) {
            ((AbstractTableModel)this.pagesTable.getModel()).fireTableDataChanged();
            this.pagesTable.changeSelection(n + 1, 0, false, false);
        }
    }

    public BookDataControl getDataControl() {
        return this.dataControl;
    }
}

