/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.book;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.DataControlWithResources;
import es.eucm.eadventure.editor.control.controllers.book.BookDataControl;
import es.eucm.eadventure.editor.gui.elementpanels.book.ArrowsPositionPanel;
import es.eucm.eadventure.editor.gui.elementpanels.general.LooksPanel;
import es.eucm.eadventure.editor.gui.elementpanels.general.ResourcesPanel;
import es.eucm.eadventure.editor.gui.otherpanels.bookpanels.BookArrowPositionPreviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class BookAppPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private BookDataControl bookDataControl;
    private LooksPanel bookLooks;

    public BookAppPanel(BookDataControl bookDataControl) {
        this.bookDataControl = bookDataControl;
        String[] stringArray = new String[bookDataControl.getResourcesCount()];
        for (int i = 0; i < bookDataControl.getResourcesCount(); ++i) {
            stringArray[i] = TC.get((String)"ResourcesList.ResourcesBlockNumber") + (i + 1);
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 3.0;
        this.bookLooks = new BookLooksPanel(this.bookDataControl);
        this.add((Component)this.bookLooks, gridBagConstraints);
    }

    private class BookLooksPanel
    extends LooksPanel {
        private static final long serialVersionUID = 1L;
        private BookArrowPositionPreviewPanel imagePanel;

        public BookLooksPanel(DataControlWithResources dataControlWithResources) {
            super(dataControlWithResources);
        }

        @Override
        protected void createPreview() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            this.imagePanel = new BookArrowPositionPreviewPanel(BookAppPanel.this.bookDataControl);
            ArrowsPositionPanel arrowsPositionPanel = new ArrowsPositionPanel(this.imagePanel);
            this.imagePanel.setArrowsPositionPanel(arrowsPositionPanel);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Book.Preview")));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            jPanel.add((Component)this.imagePanel, "Center");
            gridBagConstraints.gridx = 1;
            jPanel.add((Component)arrowsPositionPanel, "East");
            this.lookPanel.add((Component)jPanel, this.cLook);
        }

        @Override
        public void updatePreview() {
            this.imagePanel.loadImages(BookAppPanel.this.bookDataControl);
            this.imagePanel.repaint();
            if (this.getParent() != null && this.getParent().getParent() != null) {
                this.getParent().getParent().repaint();
            }
        }

        @Override
        public void updateResources() {
            super.updateResources();
            this.reorganizeResourcesPanel(this.resourcesPanel);
            if (this.getParent() != null && this.getParent().getParent() != null) {
                this.getParent().getParent().repaint();
            }
        }

        private void reorganizeResourcesPanel(ResourcesPanel resourcesPanel) {
            Component[] componentArray = resourcesPanel.getComponents();
            resourcesPanel.removeAll();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            resourcesPanel.add(componentArray[0], gridBagConstraints);
            int n = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.5;
            for (int i = 1; i < 3; ++i) {
                int n2 = 0;
                while (n2 < 2) {
                    gridBagConstraints.gridx = n2++;
                    gridBagConstraints.gridy = i;
                    resourcesPanel.add(componentArray[n], gridBagConstraints);
                    componentArray[n].repaint();
                    ++n;
                }
            }
        }
    }
}

