/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.book;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.gui.otherpanels.bookpanels.BookArrowPositionPreviewPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ArrowsPositionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private BookArrowPositionPreviewPanel bookPreview;
    private JSpinner xPreviousPageSpinner = new JSpinner();
    private JSpinner yPreviousPageSpinner = new JSpinner();
    private JSpinner xNextPageSpinner = new JSpinner();
    private JSpinner yNextPageSpinner = new JSpinner();
    private static final int SPINNER_LEFT = 0;
    private static final int SPINNER_RIGHT = 1;
    private static final int SPINNER_X = 2;
    private static final int SPINNER_Y = 3;
    private static boolean addTool = false;

    public ArrowsPositionPanel(BookArrowPositionPreviewPanel bookArrowPositionPreviewPanel) {
        this.bookPreview = bookArrowPositionPreviewPanel;
        this.xPreviousPageSpinner.setMinimumSize(new Dimension(200, 20));
        this.yPreviousPageSpinner.setMinimumSize(new Dimension(200, 20));
        this.xNextPageSpinner.setMinimumSize(new Dimension(200, 20));
        this.yNextPageSpinner.setMinimumSize(new Dimension(200, 20));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.01;
        this.add((Component)this.getButtonPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JButton jButton = new JButton(TC.get((String)"Arrows.DefaultPosition"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrowsPositionPanel.this.bookPreview.setDefaultArrowsPosition();
                ArrowsPositionPanel.this.updateSpinners(false);
                ArrowsPositionPanel.this.setAddTool(true);
                ArrowsPositionPanel.this.bookPreview.repaint();
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jButton, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Previous page"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        jPanel2.add((Component)new JLabel(TC.get((String)"SPEP.XCoordinate")), gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        jPanel2.add((Component)this.xPreviousPageSpinner, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        jPanel2.add((Component)new JLabel(TC.get((String)"SPEP.YCoordinate")), gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        jPanel2.add((Component)this.yPreviousPageSpinner, gridBagConstraints2);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Next page"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        jPanel3.add((Component)new JLabel(TC.get((String)"SPEP.XCoordinate")), gridBagConstraints3);
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        jPanel3.add((Component)this.xNextPageSpinner, gridBagConstraints3);
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        jPanel3.add((Component)new JLabel(TC.get((String)"SPEP.YCoordinate")), gridBagConstraints3);
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 1;
        jPanel3.add((Component)this.yNextPageSpinner, gridBagConstraints3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        this.updateSpinners(false);
        this.setAddTool(true);
        this.yPreviousPageSpinner.addChangeListener(new CoordinateChange(3, 0));
        this.xNextPageSpinner.addChangeListener(new CoordinateChange(2, 1));
        this.yNextPageSpinner.addChangeListener(new CoordinateChange(3, 1));
        this.xPreviousPageSpinner.addChangeListener(new CoordinateChange(2, 0));
        return jPanel;
    }

    public void updateSpinners(boolean bl) {
        this.setAddTool(bl);
        this.xPreviousPageSpinner.setValue(this.bookPreview.getPreviousPagePosition().x);
        this.yPreviousPageSpinner.setValue(this.bookPreview.getPreviousPagePosition().y);
        this.xNextPageSpinner.setValue(this.bookPreview.getNextPagePosition().x);
        this.yNextPageSpinner.setValue(this.bookPreview.getNextPagePosition().y);
    }

    public void setAddTool(boolean bl) {
        addTool = bl;
    }

    public class CoordinateChange
    implements ChangeListener {
        private int coordinate;
        private int side;

        public CoordinateChange(int n, int n2) {
            this.coordinate = n;
            this.side = n2;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n = (Integer)((JSpinner)changeEvent.getSource()).getValue();
            this.update(n);
        }

        private void update(int n) {
            if (this.side == 0) {
                Point point = ArrowsPositionPanel.this.bookPreview.getPreviousPagePosition();
                Point point2 = (Point)point.clone();
                if (this.coordinate == 2) {
                    point.x = n;
                } else if (this.coordinate == 3) {
                    point.y = n;
                }
                if (addTool) {
                    ArrowsPositionPanel.this.bookPreview.setPreviousPagePosition((Point)point.clone(), point2);
                } else {
                    ArrowsPositionPanel.this.bookPreview.setPreviousPagePosition(point.x, point.y);
                }
            } else if (this.side == 1) {
                Point point = ArrowsPositionPanel.this.bookPreview.getNextPagePosition();
                Point point3 = (Point)point.clone();
                if (this.coordinate == 2) {
                    point.x = n;
                } else if (this.coordinate == 3) {
                    point.y = n;
                }
                if (addTool) {
                    ArrowsPositionPanel.this.bookPreview.setNextPagePosition((Point)point.clone(), point3);
                } else {
                    ArrowsPositionPanel.this.bookPreview.setNextPagePosition(point.x, point.y);
                }
            }
            ArrowsPositionPanel.this.updateSpinners(false);
            ArrowsPositionPanel.this.setAddTool(true);
            ArrowsPositionPanel.this.bookPreview.repaint();
        }
    }
}

