/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.assessment;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.assessment.AssessmentRuleDataControl;
import es.eucm.eadventure.editor.gui.editdialogs.ConditionsDialog;
import es.eucm.eadventure.editor.gui.elementpanels.assessment.AssessmentPropertiesPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicButtonUI;

public class TimedAssessmentRulePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private AssessmentRuleDataControl assessmentRuleDataControl;
    private JTextArea conceptTextArea;
    private JTextArea textTextArea;
    private int currentEffect;
    private JButton addEffectBlock;
    private JButton deleteEffectBlock;
    private JSpinner minTime;
    private JSpinner maxTime;
    private AssessmentPropertiesPanel propPanel;
    private JButton endConditionsButton;
    public int numEffects;
    public int currentTab;
    private JTabbedPane container2;
    private boolean scorm12;
    private boolean scorm2004;
    private static final MouseListener buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.setBorderPainted(false);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.setBorderPainted(false);
            }
        }
    };

    public TimedAssessmentRulePanel(AssessmentRuleDataControl assessmentRuleDataControl, boolean bl, boolean bl2) {
        this.assessmentRuleDataControl = assessmentRuleDataControl;
        this.scorm12 = bl;
        this.scorm2004 = bl2;
        this.numEffects = 0;
        this.currentTab = 0;
        this.currentEffect = this.assessmentRuleDataControl.getEffectsCount() > 0 ? 0 : -1;
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"AssessmentRule.Title")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 5, 1, 5);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipady = 20;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout());
        this.conceptTextArea = new JTextArea(assessmentRuleDataControl.getConcept(), 4, 0);
        this.conceptTextArea.setLineWrap(true);
        this.conceptTextArea.setWrapStyleWord(true);
        this.conceptTextArea.getDocument().addDocumentListener(new DocumentationTextAreaChangesListener(null));
        jPanel2.add((Component)new JScrollPane(this.conceptTextArea, 22, 31), gridBagConstraints2);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"AssessmentRule.Concept")));
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        JButton jButton = new JButton(TC.get((String)"GeneralText.EditInitConditions"));
        jButton.addActionListener(new InitConditionsButtonListener());
        JCheckBox jCheckBox = new JCheckBox(TC.get((String)"Timer.UsesEndConditionShort"));
        jCheckBox.setSelected(this.assessmentRuleDataControl.isUsesEndConditions());
        jCheckBox.addChangeListener(new UseEndConditionsCheckListener());
        this.endConditionsButton = new JButton(TC.get((String)"GeneralText.EditEndConditions"));
        this.endConditionsButton.setEnabled(this.assessmentRuleDataControl.isUsesEndConditions());
        this.endConditionsButton.addActionListener(new EndConditionsButtonListener());
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        jPanel3.add((Component)jCheckBox, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.anchor = 10;
        jPanel3.add((Component)jButton, gridBagConstraints2);
        gridBagConstraints2.gridy = 2;
        jPanel3.add((Component)this.endConditionsButton, gridBagConstraints2);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"AssessmentRule.Conditions")));
        ++gridBagConstraints.gridy;
        gridBagConstraints.ipady = -10;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        this.container2 = new JTabbedPane();
        this.addEffectBlock = new AddTabButton(new ImageIcon("img/icons/addNode.png"));
        this.addEffectBlock.setContentAreaFilled(false);
        this.addEffectBlock.setBorder(BorderFactory.createEmptyBorder());
        JPanel jPanel4 = new JPanel();
        jPanel4.add(new JLabel("No hay ningun efecto creado               "));
        jPanel4.setMinimumSize(new Dimension(200, 200));
        this.container2.add(jPanel4);
        this.container2.setTabComponentAt(0, this.addEffectBlock);
        this.container2.addChangeListener(new EffectsTabPaneListener());
        if (this.currentEffect != -1) {
            for (int i = 0; i < this.assessmentRuleDataControl.getEffectsCount(); ++i) {
                this.currentEffect = i;
                JPanel jPanel5 = this.createEffectPanel();
                this.container2.add(jPanel5);
                this.deleteEffectBlock = new DeleteTabButton(new ImageIcon("img/icons/deleteNode.png"));
                this.deleteEffectBlock.setContentAreaFilled(false);
                this.deleteEffectBlock.setBorder(BorderFactory.createEmptyBorder());
                JPanel jPanel6 = new JPanel(new GridLayout(0, 2));
                jPanel6.add(new JLabel("#" + i));
                jPanel6.add(this.deleteEffectBlock);
                this.container2.setTabComponentAt(i + 1, jPanel6);
            }
            this.numEffects = this.currentEffect + 1;
            this.currentEffect = 0;
            this.currentTab = 1;
            this.container2.setSelectedIndex(this.currentTab);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.75;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.setMinimumSize(new Dimension(200, 250));
        jPanel.setMaximumSize(new Dimension(200, 250));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"AssessmentRule.Conditions")));
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.container2.setMaximumSize(new Dimension(250, 250));
        this.container2.setMinimumSize(new Dimension(250, 250));
        this.add((Component)this.container2, gridBagConstraints);
        this.updateUI();
    }

    private JPanel createEffectPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"AssessmentRule.Effect.Title")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(1, 5, 1, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(TC.get((String)"TimedAssessmentRule.MinTime"));
        JLabel jLabel2 = new JLabel(TC.get((String)"TimedAssessmentRule.MaxTime"));
        if (this.currentEffect >= 0) {
            int n = this.assessmentRuleDataControl.getMinTime(this.currentEffect);
            int n2 = 0;
            int n3 = Integer.MAX_VALUE;
            int n4 = 1;
            this.minTime = new JSpinner(new SpinnerNumberModel(n, n2, n3, n4));
            n2 = n + 1;
            n = this.assessmentRuleDataControl.getMaxTime(this.currentEffect);
            this.maxTime = new JSpinner(new SpinnerNumberModel(n, n2, n3, n4));
        } else {
            this.minTime = new JSpinner();
            this.maxTime = new JSpinner();
        }
        this.minTime.addChangeListener(new TimeMinListener(this.minTime, this.maxTime));
        this.maxTime.addChangeListener(new TimeMaxListener(this.maxTime));
        this.minTime.setMaximumSize(new Dimension(5, 5));
        this.maxTime.setMaximumSize(new Dimension(5, 5));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(1, 5, 1, 5);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridwidth = 1;
        jPanel2.add((Component)jLabel, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.ipadx = -60;
        jPanel2.add((Component)this.minTime, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.ipadx = 1;
        jPanel2.add((Component)jLabel2, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.ipadx = -60;
        jPanel2.add((Component)this.maxTime, gridBagConstraints2);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"TimedAssessmentRule.Time")));
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.ipady = 10;
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout());
        this.textTextArea = this.currentEffect >= 0 ? new JTextArea(this.assessmentRuleDataControl.getEffectText(this.currentEffect), 4, 0) : new JTextArea("", 4, 0);
        this.textTextArea.setLineWrap(true);
        this.textTextArea.setWrapStyleWord(true);
        this.textTextArea.getDocument().addDocumentListener(new DocumentationTextAreaChangesListener(this.textTextArea));
        jPanel3.add(new JScrollPane(this.textTextArea, 22, 31));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"AssessmentRule.Effect.Text"), 2, 2));
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.ipady = -9;
        gridBagConstraints.weighty = 0.8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 2;
        this.propPanel = new AssessmentPropertiesPanel(this.assessmentRuleDataControl, this.scorm12, this.scorm2004);
        if (this.currentEffect >= 0) {
            this.propPanel.setCurrentIndex(this.currentEffect);
        }
        jPanel.add((Component)this.propPanel, gridBagConstraints);
        return jPanel;
    }

    private class DeleteTabButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = -1916833906840632247L;

        public DeleteTabButton(ImageIcon imageIcon) {
            super(imageIcon);
            int n = 17;
            this.setPreferredSize(new Dimension(n, n));
            this.setToolTipText("remove this effect");
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(buttonMouseListener);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TimedAssessmentRulePanel.this.currentEffect = TimedAssessmentRulePanel.this.container2.getSelectedIndex() - 1;
            if (TimedAssessmentRulePanel.this.currentEffect >= 0) {
                TimedAssessmentRulePanel.this.assessmentRuleDataControl.removeEffectBlock(TimedAssessmentRulePanel.this.currentEffect);
                --TimedAssessmentRulePanel.this.numEffects;
                TimedAssessmentRulePanel.this.container2.remove(TimedAssessmentRulePanel.this.currentEffect + 1);
            }
        }
    }

    private class AddTabButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = -657186905921501288L;

        public AddTabButton(ImageIcon imageIcon) {
            super(imageIcon);
            int n = 17;
            this.setPreferredSize(new Dimension(n, n));
            this.setToolTipText("Add effect");
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(buttonMouseListener);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TimedAssessmentRulePanel.this.assessmentRuleDataControl.addEffectBlock(TimedAssessmentRulePanel.this.numEffects);
            TimedAssessmentRulePanel.this.currentEffect = -1;
            JPanel jPanel = TimedAssessmentRulePanel.this.createEffectPanel();
            TimedAssessmentRulePanel.this.propPanel.setEnabled(true);
            TimedAssessmentRulePanel.this.propPanel.setCurrentIndex(TimedAssessmentRulePanel.this.numEffects);
            TimedAssessmentRulePanel.this.textTextArea.setEditable(true);
            TimedAssessmentRulePanel.this.deleteEffectBlock = new DeleteTabButton(new ImageIcon("img/icons/deleteNode.png"));
            TimedAssessmentRulePanel.this.deleteEffectBlock.setContentAreaFilled(false);
            TimedAssessmentRulePanel.this.deleteEffectBlock.setFocusable(false);
            JPanel jPanel2 = new JPanel(new GridLayout(0, 2));
            jPanel2.setOpaque(false);
            jPanel2.add(new JLabel("#" + Integer.toString(TimedAssessmentRulePanel.this.numEffects)));
            jPanel2.setFocusable(false);
            ++TimedAssessmentRulePanel.this.numEffects;
            jPanel2.add(TimedAssessmentRulePanel.this.deleteEffectBlock);
            TimedAssessmentRulePanel.this.container2.add((Component)jPanel, TimedAssessmentRulePanel.this.numEffects);
            TimedAssessmentRulePanel.this.container2.setTabComponentAt(TimedAssessmentRulePanel.this.numEffects, jPanel2);
            TimedAssessmentRulePanel.this.container2.setSelectedIndex(TimedAssessmentRulePanel.this.numEffects);
        }
    }

    private class UseEndConditionsCheckListener
    implements ChangeListener {
        private UseEndConditionsCheckListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (((JCheckBox)changeEvent.getSource()).isSelected() != TimedAssessmentRulePanel.this.assessmentRuleDataControl.isUsesEndConditions()) {
                TimedAssessmentRulePanel.this.assessmentRuleDataControl.setUsesEndConditions(((JCheckBox)changeEvent.getSource()).isSelected());
                TimedAssessmentRulePanel.this.endConditionsButton.setEnabled(((JCheckBox)changeEvent.getSource()).isSelected());
            }
        }
    }

    private class EndConditionsButtonListener
    implements ActionListener {
        private EndConditionsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new ConditionsDialog(TimedAssessmentRulePanel.this.assessmentRuleDataControl.getEndConditions());
        }
    }

    private class InitConditionsButtonListener
    implements ActionListener {
        private InitConditionsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new ConditionsDialog(TimedAssessmentRulePanel.this.assessmentRuleDataControl.getInitConditions());
        }
    }

    private class TimeMaxListener
    implements ChangeListener {
        private JSpinner maxT;

        public TimeMaxListener(JSpinner jSpinner) {
            this.maxT = jSpinner;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n = ((Number)this.maxT.getValue()).intValue();
            TimedAssessmentRulePanel.this.currentEffect = TimedAssessmentRulePanel.this.container2.getSelectedIndex() - 1;
            TimedAssessmentRulePanel.this.assessmentRuleDataControl.setMaxTime(n, TimedAssessmentRulePanel.this.currentEffect);
            this.maxT.updateUI();
        }
    }

    private class TimeMinListener
    implements ChangeListener {
        private JSpinner minT;
        private JSpinner maxT;

        public TimeMinListener(JSpinner jSpinner, JSpinner jSpinner2) {
            this.minT = jSpinner;
            this.maxT = jSpinner2;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n = ((Number)this.minT.getValue()).intValue();
            TimedAssessmentRulePanel.this.currentEffect = TimedAssessmentRulePanel.this.container2.getSelectedIndex() - 1;
            TimedAssessmentRulePanel.this.assessmentRuleDataControl.setMinTime(n, TimedAssessmentRulePanel.this.currentEffect);
            this.maxT.setModel(new SpinnerNumberModel(TimedAssessmentRulePanel.this.assessmentRuleDataControl.getMaxTime(TimedAssessmentRulePanel.this.currentEffect), n + 1, Integer.MAX_VALUE, 1));
            this.maxT.updateUI();
            this.minT.updateUI();
        }
    }

    private class EffectsTabPaneListener
    implements ChangeListener {
        private EffectsTabPaneListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n = TimedAssessmentRulePanel.this.currentTab;
            TimedAssessmentRulePanel.this.currentTab = TimedAssessmentRulePanel.this.container2.getSelectedIndex();
            if (n != TimedAssessmentRulePanel.this.currentTab) {
                if (TimedAssessmentRulePanel.this.currentTab > 0) {
                    TimedAssessmentRulePanel.this.minTime.setModel(new SpinnerNumberModel(TimedAssessmentRulePanel.this.assessmentRuleDataControl.getMinTime(TimedAssessmentRulePanel.this.currentTab - 1), 0, Integer.MAX_VALUE, 1));
                    TimedAssessmentRulePanel.this.maxTime.setModel(new SpinnerNumberModel(TimedAssessmentRulePanel.this.assessmentRuleDataControl.getMaxTime(TimedAssessmentRulePanel.this.currentTab - 1), TimedAssessmentRulePanel.this.assessmentRuleDataControl.getMinTime(TimedAssessmentRulePanel.this.currentTab - 1) + 1, Integer.MAX_VALUE, 1));
                    TimedAssessmentRulePanel.this.minTime.updateUI();
                    TimedAssessmentRulePanel.this.maxTime.updateUI();
                    TimedAssessmentRulePanel.this.deleteEffectBlock.setEnabled(true);
                    TimedAssessmentRulePanel.this.textTextArea.setText(TimedAssessmentRulePanel.this.assessmentRuleDataControl.getEffectText(TimedAssessmentRulePanel.this.currentTab - 1));
                    TimedAssessmentRulePanel.this.propPanel.setEnabled(true);
                    TimedAssessmentRulePanel.this.propPanel.setCurrentIndex(TimedAssessmentRulePanel.this.currentTab - 1);
                    TimedAssessmentRulePanel.this.propPanel.updateUI();
                } else if (n == 0 && TimedAssessmentRulePanel.this.container2.getTabCount() > 1) {
                    TimedAssessmentRulePanel.this.container2.setSelectedIndex(1);
                } else if (n < TimedAssessmentRulePanel.this.container2.getTabCount()) {
                    TimedAssessmentRulePanel.this.container2.setSelectedIndex(n);
                } else {
                    TimedAssessmentRulePanel.this.container2.setSelectedIndex(0);
                }
            }
        }
    }

    private class DocumentationTextAreaChangesListener
    implements DocumentListener {
        private JTextArea textArea;

        public DocumentationTextAreaChangesListener(JTextArea jTextArea) {
            this.textArea = jTextArea;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (documentEvent.getDocument() == TimedAssessmentRulePanel.this.conceptTextArea.getDocument()) {
                TimedAssessmentRulePanel.this.assessmentRuleDataControl.setConcept(TimedAssessmentRulePanel.this.conceptTextArea.getText());
            } else if (documentEvent.getDocument() == this.textArea.getDocument()) {
                TimedAssessmentRulePanel.this.currentEffect = TimedAssessmentRulePanel.this.container2.getSelectedIndex() - 1;
                if (TimedAssessmentRulePanel.this.currentEffect >= 0) {
                    TimedAssessmentRulePanel.this.assessmentRuleDataControl.setEffectText(TimedAssessmentRulePanel.this.currentEffect, this.textArea.getText());
                }
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (documentEvent.getDocument() == TimedAssessmentRulePanel.this.conceptTextArea.getDocument()) {
                TimedAssessmentRulePanel.this.assessmentRuleDataControl.setConcept(TimedAssessmentRulePanel.this.conceptTextArea.getText());
            } else if (documentEvent.getDocument() == this.textArea.getDocument()) {
                TimedAssessmentRulePanel.this.currentEffect = TimedAssessmentRulePanel.this.container2.getSelectedIndex() - 1;
                if (TimedAssessmentRulePanel.this.currentEffect >= 0) {
                    TimedAssessmentRulePanel.this.assessmentRuleDataControl.setEffectText(TimedAssessmentRulePanel.this.currentEffect, this.textArea.getText());
                }
            }
        }
    }
}

