/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.assessment;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.config.SCORMConfigData;
import es.eucm.eadventure.editor.control.controllers.assessment.AssessmentRuleDataControl;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.auxiliar.components.JFiller;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class AssessmentPropertiesPanel
extends JPanel
implements Updateable {
    private static final long serialVersionUID = 1L;
    private AssessmentRuleDataControl assessmentRuleDataControl;
    private TitledBorder border;
    private JTable propertiesTable;
    private JScrollPane tableScrollPanel;
    private JButton movePropertyUpButton;
    private JButton movePropertyDownButton;
    private JButton insertPropertyButton;
    private JButton deletePropertyButton;
    private int currentIndex;

    public AssessmentPropertiesPanel(AssessmentRuleDataControl assessmentRuleDataControl, boolean bl, boolean bl2) {
        JComboBox<Object> jComboBox;
        this.assessmentRuleDataControl = assessmentRuleDataControl;
        this.border = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), TC.get((String)"AssessmentRule.Effect.PropertiesTitle"), 2, 2);
        this.setBorder(this.border);
        this.setLayout(new BorderLayout());
        this.propertiesTable = new JTable(new NodeTableModel());
        this.propertiesTable.setAutoCreateColumnsFromModel(false);
        this.propertiesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AssessmentPropertiesPanel.this.propertiesTable.setRowHeight(22);
                if (AssessmentPropertiesPanel.this.propertiesTable.getSelectedRow() != -1) {
                    AssessmentPropertiesPanel.this.propertiesTable.setRowHeight(AssessmentPropertiesPanel.this.propertiesTable.getSelectedRow(), 32);
                }
            }
        });
        this.propertiesTable.setSelectionMode(0);
        this.propertiesTable.setCellSelectionEnabled(false);
        this.propertiesTable.setColumnSelectionAllowed(false);
        this.propertiesTable.setRowSelectionAllowed(true);
        if (bl) {
            jComboBox = new JComboBox<Object>(SCORMConfigData.getPartsOfModel12(1).toArray());
            this.propertiesTable.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(jComboBox));
        }
        if (bl2) {
            jComboBox = new JComboBox<Object>(SCORMConfigData.getPartsOfModel2004(1).toArray());
            this.propertiesTable.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(jComboBox));
        }
        this.propertiesTable.getColumnModel().getColumn(1).setCellEditor(new AssessmentPropertyCellRenderer());
        this.propertiesTable.getColumnModel().getColumn(1).setCellRenderer(new AssessmentPropertyCellRenderer());
        this.propertiesTable.setIntercellSpacing(new Dimension(1, 1));
        this.propertiesTable.getSelectionModel().addListSelectionListener(new NodeTableSelectionListener());
        this.tableScrollPanel = new JScrollPane(this.propertiesTable, 22, 31);
        this.movePropertyUpButton = new JButton(new ImageIcon("img/icons/moveNodeUp.png"));
        this.movePropertyUpButton.setContentAreaFilled(false);
        this.movePropertyUpButton.setMargin(new Insets(0, 0, 0, 0));
        this.movePropertyUpButton.setBorder(BorderFactory.createEmptyBorder());
        this.movePropertyUpButton.setToolTipText(TC.get((String)"AssessmentProperties.MoveUp"));
        this.movePropertyUpButton.addActionListener(new ListenerButtonMoveLineUp());
        this.movePropertyUpButton.setEnabled(false);
        this.movePropertyDownButton = new JButton(new ImageIcon("img/icons/moveNodeDown.png"));
        this.movePropertyDownButton.setContentAreaFilled(false);
        this.movePropertyDownButton.setMargin(new Insets(0, 0, 0, 0));
        this.movePropertyDownButton.setBorder(BorderFactory.createEmptyBorder());
        this.movePropertyDownButton.setToolTipText(TC.get((String)"AssessmentProperties.MoveDown"));
        this.movePropertyDownButton.addActionListener(new ListenerButtonMoveLineDown());
        this.movePropertyDownButton.setEnabled(false);
        this.insertPropertyButton = new JButton(new ImageIcon("img/icons/addNode.png"));
        this.insertPropertyButton.setContentAreaFilled(false);
        this.insertPropertyButton.setMargin(new Insets(0, 0, 0, 0));
        this.insertPropertyButton.setBorder(BorderFactory.createEmptyBorder());
        this.insertPropertyButton.setToolTipText(TC.get((String)"AssessmentProperties.InsertProperty"));
        this.insertPropertyButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu = AssessmentPropertiesPanel.this.getAddChildPopupMenu();
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
        this.deletePropertyButton = new JButton(new ImageIcon("img/icons/deleteNode.png"));
        this.deletePropertyButton.setContentAreaFilled(false);
        this.deletePropertyButton.setMargin(new Insets(0, 0, 0, 0));
        this.deletePropertyButton.setBorder(BorderFactory.createEmptyBorder());
        this.deletePropertyButton.setToolTipText(TC.get((String)"AssessmentProperties.DeleteProperty"));
        this.deletePropertyButton.addActionListener(new ListenerButtonDeleteLine());
        this.addComponents();
    }

    public JPopupMenu getAddChildPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Add value property");
        jMenuItem.setEnabled(true);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AssessmentPropertiesPanel.this.propertiesTable.getSelectedRow();
                if (n == -1) {
                    n = AssessmentPropertiesPanel.this.propertiesTable.getRowCount() - 1;
                }
                if (AssessmentPropertiesPanel.this.assessmentRuleDataControl.addBlankProperty(n + 1, AssessmentPropertiesPanel.this.currentIndex)) {
                    AssessmentPropertiesPanel.this.propertiesTable.setRowSelectionInterval(n + 1, n + 1);
                    AssessmentPropertiesPanel.this.propertiesTable.scrollRectToVisible(AssessmentPropertiesPanel.this.propertiesTable.getCellRect(n + 1, 0, true));
                    AssessmentPropertiesPanel.this.propertiesTable.revalidate();
                }
            }
        });
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Add var/flag property");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AssessmentPropertiesPanel.this.propertiesTable.getSelectedRow();
                if (n == -1) {
                    n = AssessmentPropertiesPanel.this.propertiesTable.getRowCount() - 1;
                }
                String string = "No flags/vars";
                if (Controller.getInstance().getVarFlagSummary().getFlagCount() != 0) {
                    string = Controller.getInstance().getVarFlagSummary().getFlag(0);
                } else if (Controller.getInstance().getVarFlagSummary().getVarCount() != 0) {
                    string = Controller.getInstance().getVarFlagSummary().getVar(0);
                }
                if (AssessmentPropertiesPanel.this.assessmentRuleDataControl.addBlankProperty(n + 1, AssessmentPropertiesPanel.this.currentIndex, string)) {
                    AssessmentPropertiesPanel.this.propertiesTable.setRowSelectionInterval(n + 1, n + 1);
                    AssessmentPropertiesPanel.this.propertiesTable.scrollRectToVisible(AssessmentPropertiesPanel.this.propertiesTable.getCellRect(n + 1, 0, true));
                    AssessmentPropertiesPanel.this.propertiesTable.revalidate();
                }
            }
        });
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    private void addComponents() {
        this.removeAll();
        this.movePropertyUpButton.setEnabled(false);
        this.movePropertyDownButton.setEnabled(false);
        this.deletePropertyButton.setEnabled(false);
        this.add((Component)this.tableScrollPanel, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.insertPropertyButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.movePropertyUpButton, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.movePropertyDownButton, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.deletePropertyButton, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 2.0;
        jPanel.add((Component)new JFiller(), gridBagConstraints);
        this.add((Component)jPanel, "East");
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int n) {
        this.currentIndex = n;
        this.propertiesTable.setEditingRow(-1);
        this.propertiesTable.setEditingColumn(-1);
        this.propertiesTable.updateUI();
        this.propertiesTable.clearSelection();
    }

    @Override
    public boolean updateFields() {
        int n = this.propertiesTable.getSelectedRow();
        if (this.propertiesTable.getCellEditor() != null) {
            this.propertiesTable.getCellEditor().cancelCellEditing();
        }
        ((AbstractTableModel)this.propertiesTable.getModel()).fireTableDataChanged();
        this.propertiesTable.getSelectionModel().setSelectionInterval(n, n);
        return true;
    }

    private class AssessmentPropertyCellRenderer
    extends AbstractCellEditor
    implements TableCellEditor,
    TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private AssessmentRuleDataControl value;

        private AssessmentPropertyCellRenderer() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.value = (AssessmentRuleDataControl)object;
            if (this.value.isRegular(n, AssessmentPropertiesPanel.this.currentIndex)) {
                return this.prepareRegular(n, bl, jTable);
            }
            return this.prepareValue(n, bl, jTable);
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.value = (AssessmentRuleDataControl)object;
            if (this.value.isRegular(n, AssessmentPropertiesPanel.this.currentIndex)) {
                return this.prepareRegular(n, bl, jTable);
            }
            return this.prepareValue(n, bl, jTable);
        }

        private JComboBox prepareValue(int n, boolean bl, JTable jTable) {
            JComboBox<String> jComboBox = null;
            String string = this.value.getPropertyValue(n, AssessmentPropertiesPanel.this.currentIndex);
            String[] stringArray = Controller.getInstance().getVarFlagSummary().getVarsAndFlags();
            jComboBox = new JComboBox<String>(stringArray);
            jComboBox.setEditable(false);
            jComboBox.setSelectedItem(string);
            jComboBox.addActionListener(new ComboListener(n, AssessmentPropertiesPanel.this.currentIndex, jComboBox));
            if (bl) {
                jComboBox.setBorder(BorderFactory.createMatteBorder(2, 0, 2, 0, jTable.getSelectionBackground()));
            }
            return jComboBox;
        }

        private JPanel prepareRegular(int n, boolean bl, JTable jTable) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            JTextField jTextField = new JTextField(this.value.getPropertyValue(n, AssessmentPropertiesPanel.this.currentIndex));
            jTextField.addActionListener(new ModifyRegular(n, AssessmentPropertiesPanel.this.currentIndex, jTextField));
            jPanel.add((Component)jTextField, "Center");
            if (bl) {
                jPanel.setBorder(BorderFactory.createMatteBorder(2, 0, 2, 0, jTable.getSelectionBackground()));
            }
            return jPanel;
        }

        private class ModifyRegular
        implements ActionListener {
            private int rowIndex;
            private int currentIndex;
            private JTextField textField;

            public ModifyRegular(int n, int n2, JTextField jTextField) {
                this.rowIndex = n;
                this.currentIndex = n2;
                this.textField = jTextField;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AssessmentPropertyCellRenderer.this.value.setPropertyValue(this.rowIndex, this.currentIndex, this.textField.getText());
            }
        }

        private class ComboListener
        implements ActionListener {
            private int rowIndex;
            private int currentIndex;
            private JComboBox combo;

            public ComboListener(int n, int n2, JComboBox jComboBox) {
                this.rowIndex = n;
                this.currentIndex = n2;
                this.combo = jComboBox;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AssessmentPropertyCellRenderer.this.value.setPropertyValue(this.rowIndex, this.currentIndex, this.combo.getSelectedItem().toString());
            }
        }
    }

    private class NodeTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        @Override
        public String getColumnName(int n) {
            String string = "";
            if (n == 0) {
                string = "Id";
            } else if (n == 1) {
                string = "Value/Var/Flag";
            }
            return string;
        }

        @Override
        public int getRowCount() {
            int n = 0;
            if (AssessmentPropertiesPanel.this.assessmentRuleDataControl != null) {
                n = AssessmentPropertiesPanel.this.assessmentRuleDataControl.getPropertyCount(AssessmentPropertiesPanel.this.currentIndex);
            }
            return n;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (object != null && !object.toString().trim().equals("")) {
                if (n2 == 0) {
                    AssessmentPropertiesPanel.this.propertiesTable.updateUI();
                    AssessmentPropertiesPanel.this.assessmentRuleDataControl.setPropertyId(n, AssessmentPropertiesPanel.this.currentIndex, object.toString());
                }
                this.fireTableCellUpdated(n, n2);
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object object = null;
            switch (n2) {
                case 0: {
                    object = AssessmentPropertiesPanel.this.assessmentRuleDataControl.getPropertyId(n, AssessmentPropertiesPanel.this.currentIndex);
                    break;
                }
                case 1: {
                    object = AssessmentPropertiesPanel.this.assessmentRuleDataControl;
                }
            }
            return object;
        }
    }

    private class NodeTableSelectionListener
    implements ListSelectionListener {
        private NodeTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (listSelectionModel.isSelectionEmpty()) {
                AssessmentPropertiesPanel.this.movePropertyUpButton.setEnabled(false);
                AssessmentPropertiesPanel.this.movePropertyDownButton.setEnabled(false);
                AssessmentPropertiesPanel.this.deletePropertyButton.setEnabled(false);
            } else {
                AssessmentPropertiesPanel.this.movePropertyUpButton.setEnabled(true);
                AssessmentPropertiesPanel.this.movePropertyDownButton.setEnabled(true);
                AssessmentPropertiesPanel.this.deletePropertyButton.setEnabled(true);
            }
        }
    }

    private class ListenerButtonDeleteLine
    implements ActionListener {
        private ListenerButtonDeleteLine() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = AssessmentPropertiesPanel.this.propertiesTable.getSelectedRow();
            AssessmentPropertiesPanel.this.assessmentRuleDataControl.deleteProperty(n, AssessmentPropertiesPanel.this.currentIndex);
            if (AssessmentPropertiesPanel.this.assessmentRuleDataControl.getPropertyCount(AssessmentPropertiesPanel.this.currentIndex) == 0) {
                AssessmentPropertiesPanel.this.propertiesTable.clearSelection();
            } else if (AssessmentPropertiesPanel.this.assessmentRuleDataControl.getPropertyCount(AssessmentPropertiesPanel.this.currentIndex) == n) {
                AssessmentPropertiesPanel.this.propertiesTable.setRowSelectionInterval(n - 1, n - 1);
            }
            AssessmentPropertiesPanel.this.propertiesTable.revalidate();
        }
    }

    private class ListenerButtonInsertLine
    implements ActionListener {
        private ListenerButtonInsertLine() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = AssessmentPropertiesPanel.this.propertiesTable.getSelectedRow();
            if (n == -1) {
                n = AssessmentPropertiesPanel.this.propertiesTable.getRowCount() - 1;
            }
            if (AssessmentPropertiesPanel.this.assessmentRuleDataControl.addBlankProperty(n + 1, AssessmentPropertiesPanel.this.currentIndex)) {
                AssessmentPropertiesPanel.this.propertiesTable.setRowSelectionInterval(n + 1, n + 1);
                AssessmentPropertiesPanel.this.propertiesTable.scrollRectToVisible(AssessmentPropertiesPanel.this.propertiesTable.getCellRect(n + 1, 0, true));
                AssessmentPropertiesPanel.this.propertiesTable.revalidate();
            }
        }
    }

    private class ListenerButtonMoveLineDown
    implements ActionListener {
        private ListenerButtonMoveLineDown() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = AssessmentPropertiesPanel.this.propertiesTable.getSelectedRow();
            if (AssessmentPropertiesPanel.this.assessmentRuleDataControl.movePropertyDown(n, AssessmentPropertiesPanel.this.currentIndex)) {
                AssessmentPropertiesPanel.this.propertiesTable.setRowSelectionInterval(n + 1, n + 1);
                AssessmentPropertiesPanel.this.propertiesTable.scrollRectToVisible(AssessmentPropertiesPanel.this.propertiesTable.getCellRect(n + 1, 0, true));
            }
        }
    }

    private class ListenerButtonMoveLineUp
    implements ActionListener {
        private ListenerButtonMoveLineUp() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = AssessmentPropertiesPanel.this.propertiesTable.getSelectedRow();
            if (AssessmentPropertiesPanel.this.assessmentRuleDataControl.movePropertyUp(n, AssessmentPropertiesPanel.this.currentIndex)) {
                AssessmentPropertiesPanel.this.propertiesTable.setRowSelectionInterval(n - 1, n - 1);
                AssessmentPropertiesPanel.this.propertiesTable.scrollRectToVisible(AssessmentPropertiesPanel.this.propertiesTable.getCellRect(n - 1, 0, true));
            }
        }
    }
}

