/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.assessment;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.assessment.AssessmentProfileDataControl;
import es.eucm.eadventure.editor.control.controllers.assessment.AssessmentRuleDataControl;
import es.eucm.eadventure.editor.control.tools.adaptation.AddRuleTool;
import es.eucm.eadventure.editor.control.tools.adaptation.DeleteRuleTool;
import es.eucm.eadventure.editor.control.tools.adaptation.DuplicateRuleTool;
import es.eucm.eadventure.editor.gui.DataControlsPanel;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.auxiliar.components.JFiller;
import es.eucm.eadventure.editor.gui.editdialogs.GenericOptionPaneDialog;
import es.eucm.eadventure.editor.gui.elementpanels.assessment.AssessmentPropertiesPanel;
import es.eucm.eadventure.editor.gui.elementpanels.assessment.AssessmentRulesTableModel;
import es.eucm.eadventure.editor.gui.elementpanels.assessment.TimedAssessmentRulePanel;
import es.eucm.eadventure.editor.gui.elementpanels.general.TableScrollPane;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.ConditionsCellRendererEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class AssessmentEditionPanel
extends JPanel
implements DataControlsPanel,
Updateable {
    private static final long serialVersionUID = -6772977555087637745L;
    private JPanel profileTypePanel;
    private JPanel feedbackPanel;
    private JPanel ruleListPanel;
    private JButton duplicate;
    private JComboBox comboProfile;
    private JPanel rulesInfoPanel;
    private JCheckBox showReportAtEnd;
    private JTextField sendByEmailText;
    private JCheckBox sendByEmailCheck;
    private JCheckBox smtpSSL;
    private JTextField smtpServer;
    private JTextField smtpPort;
    private JTextField smtpUser;
    private JTextField smtpPwd;
    private JPanel smtpConfig;
    private JButton saveSmtpConfig;
    private JButton delete;
    private JTable informationTable;
    private JTextArea conceptTextArea;
    private JTextArea textTextArea;
    private AssessmentProfileDataControl dataControl;
    private AssessmentRuleDataControl currentRuleDataControl;

    public AssessmentEditionPanel(AssessmentProfileDataControl assessmentProfileDataControl) {
        this.dataControl = assessmentProfileDataControl;
        this.createProfileTypePanel();
        this.createFeedbackPanel();
        this.createRuleListPanel();
        this.rulesInfoPanel = new JPanel(new GridBagLayout());
        this.createRulesInfoPanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.profileTypePanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.feedbackPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        ++gridBagConstraints.gridy;
        this.add((Component)this.ruleListPanel, gridBagConstraints);
        gridBagConstraints.ipady = 50;
        ++gridBagConstraints.gridy;
        this.add((Component)this.rulesInfoPanel, gridBagConstraints);
    }

    private void createRulesInfoPanel() {
        if (this.informationTable.getSelectedRow() < 0 || this.informationTable.getSelectedRow() >= this.dataControl.getAssessmentRules().size()) {
            this.rulesInfoPanel.removeAll();
            JPanel jPanel = new JPanel();
            JLabel jLabel = new JLabel(TC.get((String)"AssessmentProfile.Empty"));
            jPanel.add(jLabel);
            this.rulesInfoPanel.add(jPanel);
            this.rulesInfoPanel.setMinimumSize(new Dimension(0, 190));
            this.rulesInfoPanel.updateUI();
        } else {
            this.rulesInfoPanel.removeAll();
            this.currentRuleDataControl = this.dataControl.getAssessmentRules().get(this.informationTable.getSelectedRow());
            if (this.currentRuleDataControl.isTimedRule()) {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                this.rulesInfoPanel.setLayout(new GridBagLayout());
                this.rulesInfoPanel.add((Component)new TimedAssessmentRulePanel(this.currentRuleDataControl, this.dataControl.isScorm12(), this.dataControl.isScorm2004()), gridBagConstraints);
                this.rulesInfoPanel.updateUI();
            } else {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                gridBagConstraints.fill = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.gridy = 0;
                ++gridBagConstraints.gridy;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.ipady = 20;
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                this.conceptTextArea = new JTextArea(this.currentRuleDataControl.getConcept(), 4, 0);
                this.conceptTextArea.setLineWrap(true);
                this.conceptTextArea.setWrapStyleWord(true);
                this.conceptTextArea.getDocument().addDocumentListener(new DocumentationTextAreaChangesListener());
                jPanel.add((Component)new JScrollPane(this.conceptTextArea, 22, 31), "Center");
                jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"AssessmentRule.Concept")));
                ++gridBagConstraints.gridy;
                gridBagConstraints.ipady = 0;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                this.rulesInfoPanel.add((Component)jPanel, gridBagConstraints);
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new GridBagLayout());
                jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"AssessmentRule.Effect.Title")));
                GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.gridx = 0;
                gridBagConstraints2.gridy = 0;
                gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
                gridBagConstraints2.fill = 1;
                gridBagConstraints2.weightx = 1.0;
                gridBagConstraints2.weighty = 0.2;
                JPanel jPanel3 = new JPanel();
                jPanel3.setLayout(new GridLayout());
                this.textTextArea = new JTextArea(this.currentRuleDataControl.getEffectText(0), 4, 0);
                this.textTextArea.setLineWrap(true);
                this.textTextArea.setWrapStyleWord(true);
                this.textTextArea.getDocument().addDocumentListener(new DocumentationTextAreaChangesListener());
                jPanel3.add(new JScrollPane(this.textTextArea, 22, 31));
                jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"AssessmentRule.Effect.Text"), 2, 2));
                jPanel2.add((Component)jPanel3, gridBagConstraints2);
                gridBagConstraints2.weighty = 0.8;
                gridBagConstraints2.fill = 1;
                gridBagConstraints2.gridy = 1;
                AssessmentPropertiesPanel assessmentPropertiesPanel = new AssessmentPropertiesPanel(this.currentRuleDataControl, this.dataControl.isScorm12(), this.dataControl.isScorm2004());
                jPanel2.add((Component)assessmentPropertiesPanel, gridBagConstraints2);
                gridBagConstraints.gridx = 1;
                this.rulesInfoPanel.add((Component)jPanel2, gridBagConstraints);
                this.rulesInfoPanel.updateUI();
            }
        }
    }

    private void createRuleListPanel() {
        AssessmentRulesTableModel assessmentRulesTableModel = new AssessmentRulesTableModel(this.dataControl);
        this.informationTable = new JTable(assessmentRulesTableModel);
        assessmentRulesTableModel.setTable(this.informationTable);
        this.informationTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AssessmentEditionPanel.this.createRulesInfoPanel();
                if (AssessmentEditionPanel.this.informationTable.getSelectedRow() == -1) {
                    AssessmentEditionPanel.this.delete.setEnabled(false);
                    AssessmentEditionPanel.this.duplicate.setEnabled(false);
                } else {
                    AssessmentEditionPanel.this.delete.setEnabled(true);
                    AssessmentEditionPanel.this.duplicate.setEnabled(true);
                }
            }
        });
        this.informationTable.getSelectionModel().setSelectionMode(0);
        JComboBox<String> jComboBox = new JComboBox<String>(new String[]{TC.get((String)"AssessmentRule.Importance.VeryLow"), TC.get((String)"AssessmentRule.Importance.Low"), TC.get((String)"AssessmentRule.Importance.Normal"), TC.get((String)"AssessmentRule.Importance.High"), TC.get((String)"AssessmentRule.Importance.VeryHigh")});
        this.informationTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(jComboBox));
        this.informationTable.getColumnModel().getColumn(2).setCellEditor(new ConditionsCellRendererEditor());
        this.informationTable.getColumnModel().getColumn(2).setCellRenderer(new ConditionsCellRendererEditor());
        this.informationTable.getColumnModel().getColumn(3).setCellEditor(this.informationTable.getDefaultEditor(Boolean.class));
        this.informationTable.getColumnModel().getColumn(3).setCellRenderer(this.informationTable.getDefaultRenderer(Boolean.class));
        this.ruleListPanel = new JPanel();
        this.ruleListPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"AssessmentRulesList.ListTitle")));
        this.ruleListPanel.setLayout(new BorderLayout());
        this.ruleListPanel.add((Component)new TableScrollPane(this.informationTable, 22, 31), "Center");
        JButton jButton = new JButton(new ImageIcon("img/icons/addNode.png"));
        jButton.setContentAreaFilled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setFocusable(false);
        jButton.setToolTipText(TC.get((String)"AdaptationProfile.AddRule"));
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu = AssessmentEditionPanel.this.getAddChildPopupMenu();
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
        this.duplicate = new JButton(new ImageIcon("img/icons/duplicateNode.png"));
        this.duplicate.setContentAreaFilled(false);
        this.duplicate.setMargin(new Insets(0, 0, 0, 0));
        this.duplicate.setBorder(BorderFactory.createEmptyBorder());
        this.duplicate.setToolTipText(TC.get((String)"AdaptationProfile.Duplicate"));
        this.duplicate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Controller.getInstance().addTool(new DuplicateRuleTool(AssessmentEditionPanel.this.dataControl, 38, AssessmentEditionPanel.this.informationTable.getSelectedRow()))) {
                    ((AssessmentRulesTableModel)AssessmentEditionPanel.this.informationTable.getModel()).fireTableDataChanged();
                    AssessmentEditionPanel.this.informationTable.changeSelection(AssessmentEditionPanel.this.dataControl.getAssessmentRules().size() - 1, 0, false, false);
                }
            }
        });
        this.duplicate.setEnabled(false);
        this.delete = new JButton(new ImageIcon("img/icons/deleteNode.png"));
        this.delete.setContentAreaFilled(false);
        this.delete.setMargin(new Insets(0, 0, 0, 0));
        this.delete.setBorder(BorderFactory.createEmptyBorder());
        this.delete.setFocusable(false);
        this.delete.setToolTipText(TC.get((String)"AdaptationProfile.DeleteRule"));
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Controller.getInstance().addTool(new DeleteRuleTool(AssessmentEditionPanel.this.dataControl, 38, AssessmentEditionPanel.this.informationTable.getSelectedRow()))) {
                    AssessmentEditionPanel.this.informationTable.clearSelection();
                    ((AssessmentRulesTableModel)AssessmentEditionPanel.this.informationTable.getModel()).fireTableDataChanged();
                    AssessmentEditionPanel.this.createRulesInfoPanel();
                }
            }
        });
        this.delete.setEnabled(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.duplicate, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.delete, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)new JFiller(), gridBagConstraints);
        this.ruleListPanel.add((Component)jPanel, "East");
    }

    public void createProfileTypePanel() {
        this.profileTypePanel = new JPanel(new BorderLayout());
        this.profileTypePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"AssessmentRule.ProfileType")));
        String[] stringArray = new String[]{TC.get((String)"AdaptationRulesList.Scorm2004"), TC.get((String)"AdaptationRulesList.Scorm12"), TC.get((String)"AdaptationRulesList.Normal")};
        this.comboProfile = new JComboBox<String>(stringArray);
        if (this.dataControl.isScorm12()) {
            this.comboProfile.setSelectedIndex(1);
        } else if (this.dataControl.isScorm2004()) {
            this.comboProfile.setSelectedIndex(0);
        } else {
            this.comboProfile.setSelectedIndex(2);
        }
        this.comboProfile.addActionListener(new ComboListener(this.comboProfile.getSelectedIndex()));
        this.profileTypePanel.add((Component)this.comboProfile, "Center");
    }

    public void createFeedbackPanel() {
        this.feedbackPanel = this.createFeedbackPanel(this.dataControl);
    }

    private JPanel createFeedbackPanel(AssessmentProfileDataControl assessmentProfileDataControl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"AssessmentProfile.Feedback.Title")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        this.showReportAtEnd = new JCheckBox(TC.get((String)"AssessmentProfile.Feedback.ShowReportAtEnd"));
        if (assessmentProfileDataControl.isShowReportAtEnd()) {
            this.showReportAtEnd.setSelected(true);
        }
        this.showReportAtEnd.addActionListener(new ShowReportAtEndActionListener());
        jPanel.add((Component)this.showReportAtEnd, gridBagConstraints);
        this.sendByEmailCheck = new JCheckBox(TC.get((String)"AssessmentProfile.Feedback.SendByEmail"));
        this.sendByEmailCheck.setEnabled(this.dataControl.isShowReportAtEnd());
        this.sendByEmailCheck.setSelected(this.dataControl.isShowReportAtEnd() && this.dataControl.isSendByEmail());
        this.sendByEmailCheck.addActionListener(new SendByEmailActionListener());
        this.sendByEmailText = new JTextField();
        this.sendByEmailText.setEnabled(this.dataControl.isShowReportAtEnd() && this.dataControl.isSendByEmail());
        if (this.dataControl.isSendByEmail() && this.dataControl.isShowReportAtEnd()) {
            this.sendByEmailText.setText(this.dataControl.getEmail());
        }
        this.sendByEmailText.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                AssessmentEditionPanel.this.dataControl.setEmail(AssessmentEditionPanel.this.sendByEmailText.getText());
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.0;
        jPanel2.add((Component)this.sendByEmailCheck, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.weightx = 3.0;
        gridBagConstraints2.fill = 2;
        jPanel2.add((Component)this.sendByEmailText, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.fill = 0;
        JButton jButton = new JButton(TC.get((String)"AssessmentProfile.Feedback.EditSMTPConfiguration"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new SMTPDialog();
            }
        });
        jPanel2.add((Component)jButton, gridBagConstraints2);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.smtpConfig = this.createSmtpConfigPanel();
        if (!this.dataControl.isSendByEmail()) {
            this.smtpSSL.setEnabled(false);
            this.smtpServer.setEnabled(false);
            this.smtpPort.setEnabled(false);
            this.smtpUser.setEnabled(false);
            this.smtpPwd.setEnabled(false);
        }
        return jPanel;
    }

    private JPanel createSmtpConfigPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(5, 2));
        this.smtpSSL = new JCheckBox("Use SSL");
        jPanel2.add(this.smtpSSL);
        jPanel2.add(new JLabel(""));
        this.smtpServer = new JTextField();
        jPanel2.add(new JLabel("SMTP SERVER"));
        jPanel2.add(this.smtpServer);
        this.smtpPort = new JTextField();
        jPanel2.add(new JLabel("SMTP PORT"));
        jPanel2.add(this.smtpPort);
        this.smtpUser = new JTextField();
        jPanel2.add(new JLabel("SMTP USER"));
        jPanel2.add(this.smtpUser);
        this.smtpPwd = new JPasswordField();
        ((JPasswordField)this.smtpPwd).setEchoChar('*');
        jPanel2.add(new JLabel("SMTP PASSWORD"));
        jPanel2.add(this.smtpPwd);
        if (this.dataControl.isSendByEmail()) {
            this.smtpSSL.setSelected(this.dataControl.isSmtpSSL());
            this.smtpServer.setText(this.dataControl.getSmtpServer());
            this.smtpPort.setText(this.dataControl.getSmtpPort());
            this.smtpUser.setText(this.dataControl.getSmtpUser());
            this.smtpPwd.setText(this.dataControl.getSmtpPwd());
        }
        jPanel.add((Component)jPanel2, "Center");
        this.saveSmtpConfig = new JButton(TC.get((String)"Assessment.SMTPConfig.save"));
        this.saveSmtpConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (this.validatePort(AssessmentEditionPanel.this.smtpPort.getText())) {
                    AssessmentEditionPanel.this.dataControl.setSmtpServer(AssessmentEditionPanel.this.smtpServer.getText());
                    AssessmentEditionPanel.this.dataControl.setSmtpPort(AssessmentEditionPanel.this.smtpPort.getText());
                    AssessmentEditionPanel.this.dataControl.setSmtpPwd(AssessmentEditionPanel.this.smtpPwd.getText());
                    AssessmentEditionPanel.this.dataControl.setSmtpSSL(AssessmentEditionPanel.this.smtpSSL.isSelected());
                    AssessmentEditionPanel.this.dataControl.setSmtpUser(AssessmentEditionPanel.this.smtpUser.getText());
                } else {
                    GenericOptionPaneDialog.showMessageDialog(null, TC.get((String)"Assessment.SMTPConfig.InvalidData"), TC.get((String)"Assessment.SMTPConfig.InvalidData"), 0);
                }
            }

            private boolean validatePort(String string) {
                try {
                    int n = Integer.parseInt(string);
                    if (n > 0 && n < 16000) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        });
        jPanel.add((Component)this.saveSmtpConfig, "South");
        return jPanel;
    }

    public JPopupMenu getAddChildPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(TC.get((String)"AdaptationProfile.AddRule"));
        jMenuItem.setEnabled(true);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Controller.getInstance().addTool(new AddRuleTool(AssessmentEditionPanel.this.dataControl, 38))) {
                    ((AssessmentRulesTableModel)AssessmentEditionPanel.this.informationTable.getModel()).fireTableDataChanged();
                    AssessmentEditionPanel.this.informationTable.changeSelection(AssessmentEditionPanel.this.dataControl.getAssessmentRules().size() - 1, 0, false, false);
                }
            }
        });
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(TC.get((String)"AdaptationProfile.AddTimedRule"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Controller.getInstance().addTool(new AddRuleTool(AssessmentEditionPanel.this.dataControl, 49))) {
                    ((AssessmentRulesTableModel)AssessmentEditionPanel.this.informationTable.getModel()).fireTableDataChanged();
                    AssessmentEditionPanel.this.informationTable.changeSelection(AssessmentEditionPanel.this.dataControl.getAssessmentRules().size() - 1, 0, false, false);
                }
            }
        });
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    private void sendByEmailCheck() {
        this.sendByEmailText.setEnabled(this.sendByEmailCheck.isSelected());
        this.smtpSSL.setEnabled(this.sendByEmailCheck.isSelected());
        this.smtpServer.setEnabled(this.sendByEmailCheck.isSelected());
        this.smtpPort.setEnabled(this.sendByEmailCheck.isSelected());
        this.smtpUser.setEnabled(this.sendByEmailCheck.isSelected());
        this.smtpPwd.setEnabled(this.sendByEmailCheck.isSelected());
        if (this.sendByEmailCheck.isSelected()) {
            this.sendByEmailText.setText(this.dataControl.getEmail());
            this.smtpSSL.setSelected(this.dataControl.isSmtpSSL());
            this.smtpServer.setText(this.dataControl.getSmtpServer());
            this.smtpPort.setText(this.dataControl.getSmtpPort());
            this.smtpUser.setText(this.dataControl.getSmtpUser());
            this.smtpPwd.setText(this.dataControl.getSmtpPwd());
        } else {
            this.sendByEmailText.setText("");
            this.smtpSSL.setSelected(false);
            this.smtpServer.setText("");
            this.smtpPort.setText("");
            this.smtpUser.setText("");
            this.smtpPwd.setText("");
        }
    }

    private void showReportCheck() {
        boolean bl = this.showReportAtEnd.isSelected();
        if (this.showReportAtEnd.isSelected()) {
            this.sendByEmailCheck.setEnabled(true);
            this.sendByEmailCheck.setSelected(this.dataControl.isSendByEmail());
            this.sendByEmailText.setEnabled(this.dataControl.isSendByEmail());
            this.smtpSSL.setEnabled(this.dataControl.isSendByEmail());
            this.smtpServer.setEnabled(this.dataControl.isSendByEmail());
            this.smtpPort.setEnabled(this.dataControl.isSendByEmail());
            this.smtpUser.setEnabled(this.dataControl.isSendByEmail());
            this.smtpPwd.setEnabled(this.dataControl.isSendByEmail());
            if (this.dataControl.isSendByEmail()) {
                this.sendByEmailText.setText(this.dataControl.getEmail());
                this.smtpSSL.setSelected(this.dataControl.isSmtpSSL());
                this.smtpServer.setText(this.dataControl.getSmtpServer());
                this.smtpPort.setText(this.dataControl.getSmtpPort());
                this.smtpUser.setText(this.dataControl.getSmtpUser());
                this.smtpPwd.setText(this.dataControl.getSmtpPwd());
            }
        } else {
            this.sendByEmailCheck.setEnabled(false);
            this.sendByEmailCheck.setSelected(false);
            this.sendByEmailText.setEnabled(false);
            this.sendByEmailText.setText("");
            this.smtpSSL.setSelected(false);
            this.smtpServer.setText("");
            this.smtpPort.setText("");
            this.smtpUser.setText("");
            this.smtpPwd.setText("");
        }
    }

    @Override
    public boolean updateFields() {
        int n = this.informationTable.getSelectedRow();
        if (this.informationTable.getCellEditor() != null) {
            this.informationTable.getCellEditor().cancelCellEditing();
        }
        ((AbstractTableModel)this.informationTable.getModel()).fireTableDataChanged();
        if (this.dataControl.isScorm12()) {
            this.comboProfile.setSelectedIndex(1);
        } else if (this.dataControl.isScorm2004()) {
            this.comboProfile.setSelectedIndex(0);
        } else {
            this.comboProfile.setSelectedIndex(2);
        }
        this.showReportAtEnd.setSelected(this.dataControl.isShowReportAtEnd());
        this.showReportCheck();
        this.sendByEmailCheck.setSelected(this.dataControl.isSendByEmail());
        this.sendByEmailCheck();
        this.informationTable.getSelectionModel().setSelectionInterval(n, n);
        return true;
    }

    @Override
    public void setSelectedItem(List<Searchable> list) {
        if (list.size() > 0) {
            for (int i = 0; i < this.dataControl.getDataControls().size(); ++i) {
                if (this.dataControl.getDataControls().get(i) != list.get(list.size() - 1)) continue;
                this.informationTable.changeSelection(i, i, false, false);
            }
        }
    }

    private class ShowReportAtEndActionListener
    implements ActionListener {
        private ShowReportAtEndActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AssessmentEditionPanel.this.showReportCheck();
            AssessmentEditionPanel.this.dataControl.setShowReportAtEnd(AssessmentEditionPanel.this.showReportAtEnd.isSelected());
        }
    }

    private class SendByEmailActionListener
    implements ActionListener {
        private SendByEmailActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AssessmentEditionPanel.this.sendByEmailCheck();
            AssessmentEditionPanel.this.dataControl.setSendByEmail(AssessmentEditionPanel.this.sendByEmailCheck.isSelected());
        }
    }

    private class DocumentationTextAreaChangesListener
    implements DocumentListener {
        private DocumentationTextAreaChangesListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (documentEvent.getDocument() == AssessmentEditionPanel.this.conceptTextArea.getDocument()) {
                AssessmentEditionPanel.this.currentRuleDataControl.setConcept(AssessmentEditionPanel.this.conceptTextArea.getText());
            } else if (documentEvent.getDocument() == AssessmentEditionPanel.this.textTextArea.getDocument()) {
                AssessmentEditionPanel.this.currentRuleDataControl.setEffectText(-1, AssessmentEditionPanel.this.textTextArea.getText());
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (documentEvent.getDocument() == AssessmentEditionPanel.this.conceptTextArea.getDocument()) {
                AssessmentEditionPanel.this.currentRuleDataControl.setConcept(AssessmentEditionPanel.this.conceptTextArea.getText());
            } else if (documentEvent.getDocument() == AssessmentEditionPanel.this.textTextArea.getDocument()) {
                AssessmentEditionPanel.this.currentRuleDataControl.setEffectText(-1, AssessmentEditionPanel.this.textTextArea.getText());
            }
        }
    }

    private class SMTPDialog
    extends JDialog {
        private static final long serialVersionUID = -1152972955243725648L;

        public SMTPDialog() {
            super(Controller.getInstance().peekWindow(), TC.get((String)"AssessmentProfile.Feedback.EditSMTPConfiguration"), Dialog.ModalityType.TOOLKIT_MODAL);
            Controller.getInstance().pushWindow(this);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add(AssessmentEditionPanel.this.smtpConfig);
            this.add(jPanel);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    Controller.getInstance().popWindow();
                }
            });
            this.setSize(new Dimension(250, 200));
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
            this.setResizable(false);
            this.setVisible(true);
        }
    }

    private class ComboListener
    implements ActionListener {
        private int pastSelection;

        public ComboListener(int n) {
            this.pastSelection = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (this.pastSelection != jComboBox.getSelectedIndex()) {
                AssessmentEditionPanel.this.informationTable.clearSelection();
                if (jComboBox.getSelectedIndex() == 0) {
                    AssessmentEditionPanel.this.dataControl.changeToScorm2004Profile();
                } else if (jComboBox.getSelectedIndex() == 1) {
                    AssessmentEditionPanel.this.dataControl.changeToScorm12Profile();
                } else if (jComboBox.getSelectedIndex() == 2) {
                    AssessmentEditionPanel.this.dataControl.changeToNormalProfile();
                }
                this.pastSelection = jComboBox.getSelectedIndex();
            }
        }
    }
}

