/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.adaptation;

import es.eucm.eadventure.common.data.adaptation.AdaptationProfile;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.config.SCORMConfigData;
import es.eucm.eadventure.editor.control.controllers.adaptation.AdaptationRuleDataControl;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.auxiliar.components.JFiller;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class UOLPropertiesPanel
extends JPanel
implements Updateable {
    private static final long serialVersionUID = 1L;
    private AdaptationRuleDataControl adaptationRuleDataControl;
    private JTable propertiesTable;
    private JScrollPane tableScrollPanel;
    private JButton movePropertyUpButton;
    private JButton movePropertyDownButton;
    private JButton insertPropertyButton;
    private JButton deletePropertyButton;

    public UOLPropertiesPanel(AdaptationRuleDataControl adaptationRuleDataControl, boolean bl, boolean bl2) {
        JComboBox<Object> jComboBox;
        this.adaptationRuleDataControl = adaptationRuleDataControl;
        this.setLayout(new BorderLayout());
        this.propertiesTable = new JTable(new NodeTableModel());
        this.propertiesTable.setAutoCreateColumnsFromModel(false);
        JComboBox<String> jComboBox2 = new JComboBox<String>(AdaptationProfile.getOperations());
        this.propertiesTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(jComboBox2));
        this.propertiesTable.getColumnModel().getColumn(1).setMaxWidth(60);
        if (bl) {
            jComboBox = new JComboBox<Object>(SCORMConfigData.getPartsOfModel12(0).toArray());
            this.propertiesTable.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(jComboBox));
        }
        if (bl2) {
            jComboBox = new JComboBox<Object>(SCORMConfigData.getPartsOfModel2004(0).toArray());
            this.propertiesTable.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(jComboBox));
        }
        this.propertiesTable.setSelectionMode(0);
        this.propertiesTable.setCellSelectionEnabled(false);
        this.propertiesTable.setColumnSelectionAllowed(false);
        this.propertiesTable.setRowSelectionAllowed(true);
        this.propertiesTable.setIntercellSpacing(new Dimension(1, 1));
        this.propertiesTable.getSelectionModel().addListSelectionListener(new NodeTableSelectionListener());
        this.tableScrollPanel = new JScrollPane(this.propertiesTable, 22, 31);
        this.movePropertyUpButton = new JButton(new ImageIcon("img/icons/moveNodeUp.png"));
        this.movePropertyUpButton.setContentAreaFilled(false);
        this.movePropertyUpButton.setMargin(new Insets(0, 0, 0, 0));
        this.movePropertyUpButton.setBorder(BorderFactory.createEmptyBorder());
        this.movePropertyUpButton.setToolTipText(TC.get((String)"UOLProperties.MoveUp"));
        this.movePropertyUpButton.addActionListener(new ListenerButtonMoveLineUp());
        this.movePropertyUpButton.setEnabled(false);
        this.movePropertyDownButton = new JButton(new ImageIcon("img/icons/moveNodeDown.png"));
        this.movePropertyDownButton.setContentAreaFilled(false);
        this.movePropertyDownButton.setMargin(new Insets(0, 0, 0, 0));
        this.movePropertyDownButton.setBorder(BorderFactory.createEmptyBorder());
        this.movePropertyDownButton.setToolTipText(TC.get((String)"UOLProperties.MoveDown"));
        this.movePropertyDownButton.addActionListener(new ListenerButtonMoveLineDown());
        this.movePropertyDownButton.setEnabled(false);
        this.insertPropertyButton = new JButton(new ImageIcon("img/icons/addNode.png"));
        this.insertPropertyButton.setContentAreaFilled(false);
        this.insertPropertyButton.setMargin(new Insets(0, 0, 0, 0));
        this.insertPropertyButton.setBorder(BorderFactory.createEmptyBorder());
        this.insertPropertyButton.setToolTipText(TC.get((String)"UOLProperties.InsertProperty"));
        this.insertPropertyButton.addActionListener(new ListenerButtonInsertLine());
        this.deletePropertyButton = new JButton(new ImageIcon("img/icons/deleteNode.png"));
        this.deletePropertyButton.setContentAreaFilled(false);
        this.deletePropertyButton.setMargin(new Insets(0, 0, 0, 0));
        this.deletePropertyButton.setBorder(BorderFactory.createEmptyBorder());
        this.deletePropertyButton.setToolTipText(TC.get((String)"UOLProperties.DeleteProperty"));
        this.deletePropertyButton.addActionListener(new ListenerButtonDeleteLine());
        this.addComponents();
    }

    private void addComponents() {
        this.removeAll();
        this.movePropertyUpButton.setEnabled(false);
        this.movePropertyDownButton.setEnabled(false);
        this.deletePropertyButton.setEnabled(false);
        this.add((Component)this.tableScrollPanel, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.insertPropertyButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.movePropertyUpButton, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.movePropertyDownButton, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.deletePropertyButton, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 2.0;
        jPanel.add((Component)new JFiller(), gridBagConstraints);
        this.add((Component)jPanel, "East");
    }

    @Override
    public boolean updateFields() {
        int n = this.propertiesTable.getSelectedRow();
        if (this.propertiesTable.getCellEditor() != null) {
            this.propertiesTable.getCellEditor().cancelCellEditing();
        }
        ((AbstractTableModel)this.propertiesTable.getModel()).fireTableDataChanged();
        this.propertiesTable.getSelectionModel().setSelectionInterval(n, n);
        return true;
    }

    private class NodeTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        @Override
        public String getColumnName(int n) {
            String string = "";
            if (n == 0) {
                string = "Id";
            } else if (n == 1) {
                string = "Op";
            } else if (n == 2) {
                string = "Value";
            }
            return string;
        }

        @Override
        public int getRowCount() {
            int n = 0;
            if (UOLPropertiesPanel.this.adaptationRuleDataControl != null) {
                n = UOLPropertiesPanel.this.adaptationRuleDataControl.getUOLPropertyCount();
            }
            return n;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (object != null && !object.toString().trim().equals("") && n < UOLPropertiesPanel.this.adaptationRuleDataControl.getUOLPropertyCount()) {
                if (n2 == 0) {
                    UOLPropertiesPanel.this.propertiesTable.updateUI();
                    UOLPropertiesPanel.this.adaptationRuleDataControl.setUOLPropertyId(n, object.toString());
                }
                if (n2 == 1) {
                    UOLPropertiesPanel.this.adaptationRuleDataControl.setUOLPropertyOp(n, AdaptationProfile.getOpName((Object)object));
                }
                if (n2 == 2) {
                    UOLPropertiesPanel.this.adaptationRuleDataControl.setUOLPropertyValue(n, object.toString());
                }
                this.fireTableCellUpdated(n, n2);
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string = null;
            switch (n2) {
                case 0: {
                    string = UOLPropertiesPanel.this.adaptationRuleDataControl.getUOLPropertyId(n);
                    break;
                }
                case 1: {
                    string = AdaptationProfile.getOpRepresentation((Object)UOLPropertiesPanel.this.adaptationRuleDataControl.getUOLPropertyOp(n));
                    break;
                }
                case 2: {
                    string = UOLPropertiesPanel.this.adaptationRuleDataControl.getUOLPropertyValue(n);
                }
            }
            return string;
        }
    }

    private class NodeTableSelectionListener
    implements ListSelectionListener {
        private NodeTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (listSelectionModel.isSelectionEmpty()) {
                UOLPropertiesPanel.this.movePropertyUpButton.setEnabled(false);
                UOLPropertiesPanel.this.movePropertyDownButton.setEnabled(false);
                UOLPropertiesPanel.this.deletePropertyButton.setEnabled(false);
            } else {
                UOLPropertiesPanel.this.movePropertyUpButton.setEnabled(true);
                UOLPropertiesPanel.this.movePropertyDownButton.setEnabled(true);
                UOLPropertiesPanel.this.deletePropertyButton.setEnabled(true);
            }
        }
    }

    private class ListenerButtonDeleteLine
    implements ActionListener {
        private ListenerButtonDeleteLine() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = UOLPropertiesPanel.this.propertiesTable.getSelectedRow();
            UOLPropertiesPanel.this.adaptationRuleDataControl.deleteUOLProperty(n);
            if (UOLPropertiesPanel.this.adaptationRuleDataControl.getUOLPropertyCount() == 0) {
                UOLPropertiesPanel.this.propertiesTable.clearSelection();
            } else if (UOLPropertiesPanel.this.adaptationRuleDataControl.getUOLPropertyCount() == n) {
                UOLPropertiesPanel.this.propertiesTable.setRowSelectionInterval(n - 1, n - 1);
            }
            UOLPropertiesPanel.this.propertiesTable.revalidate();
        }
    }

    private class ListenerButtonInsertLine
    implements ActionListener {
        private ListenerButtonInsertLine() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = UOLPropertiesPanel.this.propertiesTable.getSelectedRow();
            if (n == -1) {
                n = UOLPropertiesPanel.this.propertiesTable.getRowCount() - 1;
            }
            UOLPropertiesPanel.this.adaptationRuleDataControl.addBlankUOLProperty(n + 1);
            UOLPropertiesPanel.this.propertiesTable.setRowSelectionInterval(n + 1, n + 1);
            UOLPropertiesPanel.this.propertiesTable.scrollRectToVisible(UOLPropertiesPanel.this.propertiesTable.getCellRect(n + 1, 0, true));
            UOLPropertiesPanel.this.propertiesTable.revalidate();
        }
    }

    private class ListenerButtonMoveLineDown
    implements ActionListener {
        private ListenerButtonMoveLineDown() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = UOLPropertiesPanel.this.propertiesTable.getSelectedRow();
            if (UOLPropertiesPanel.this.adaptationRuleDataControl.moveUOLPropertyDown(n)) {
                UOLPropertiesPanel.this.propertiesTable.setRowSelectionInterval(n + 1, n + 1);
                UOLPropertiesPanel.this.propertiesTable.scrollRectToVisible(UOLPropertiesPanel.this.propertiesTable.getCellRect(n + 1, 0, true));
            }
        }
    }

    private class ListenerButtonMoveLineUp
    implements ActionListener {
        private ListenerButtonMoveLineUp() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = UOLPropertiesPanel.this.propertiesTable.getSelectedRow();
            if (UOLPropertiesPanel.this.adaptationRuleDataControl.moveUOLPropertyUp(n)) {
                UOLPropertiesPanel.this.propertiesTable.setRowSelectionInterval(n - 1, n - 1);
                UOLPropertiesPanel.this.propertiesTable.scrollRectToVisible(UOLPropertiesPanel.this.propertiesTable.getCellRect(n - 1, 0, true));
            }
        }
    }
}

