/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.adaptation;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.adaptation.AdaptationProfileDataControl;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.auxiliar.components.JFiller;
import es.eucm.eadventure.editor.gui.elementpanels.adaptation.FlagsVarListRenderer;
import es.eucm.eadventure.editor.gui.elementpanels.general.TableScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

class InitialStatePanel
extends JPanel
implements Updateable {
    private static final long serialVersionUID = 1L;
    private AdaptationProfileDataControl adaptationProfileDataControl;
    private TitledBorder border;
    private JTable actionFlagsTable;
    private JScrollPane tableScrollPanel;
    private JButton insertActionFlagButton;
    private JButton deleteActionFlagButton;
    private JComboBox initialSceneCB;
    private JComboBox flagsCB;
    private NodeTableModel tableModel;

    public InitialStatePanel(AdaptationProfileDataControl adaptationProfileDataControl, boolean bl) {
        this.adaptationProfileDataControl = adaptationProfileDataControl;
        this.border = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), TC.get((String)"AdaptationRule.InitialState.Title"), 2, 2);
        this.setBorder(this.border);
        this.setLayout(new BorderLayout());
        this.tableModel = new NodeTableModel();
        this.actionFlagsTable = new JTable(this.tableModel);
        this.actionFlagsTable.setAutoCreateColumnsFromModel(false);
        this.actionFlagsTable.getColumnModel().getColumn(0).setMaxWidth(60);
        this.actionFlagsTable.getColumnModel().getColumn(1).setMaxWidth(60);
        this.actionFlagsTable.setSelectionMode(0);
        this.actionFlagsTable.setCellSelectionEnabled(false);
        this.actionFlagsTable.setColumnSelectionAllowed(false);
        this.actionFlagsTable.setRowSelectionAllowed(true);
        this.actionFlagsTable.setIntercellSpacing(new Dimension(1, 1));
        this.actionFlagsTable.getSelectionModel().addListSelectionListener(new NodeTableSelectionListener());
        this.actionFlagsTable.getSelectionModel().setSelectionMode(0);
        this.actionFlagsTable.getColumnModel().getColumn(0).setCellRenderer(this.actionFlagsTable.getDefaultRenderer(Boolean.class));
        this.actionFlagsTable.getColumnModel().getColumn(0).setCellEditor(this.actionFlagsTable.getDefaultEditor(Boolean.class));
        this.actionFlagsTable.getColumnModel().getColumn(1).setCellRenderer(this.actionFlagsTable.getDefaultRenderer(Boolean.class));
        this.actionFlagsTable.getColumnModel().getColumn(1).setCellEditor(this.actionFlagsTable.getDefaultEditor(Boolean.class));
        this.actionFlagsTable.getColumnModel().getColumn(2).setCellRenderer(new FlagsVarListRenderer());
        this.actionFlagsTable.getColumnModel().getColumn(2).setCellEditor(new FlagsVarListRenderer());
        this.actionFlagsTable.getColumnModel().getColumn(3).setCellRenderer(new FlagsVarListRenderer());
        this.actionFlagsTable.getColumnModel().getColumn(3).setCellEditor(new FlagsVarListRenderer());
        this.actionFlagsTable.setRowHeight(22);
        this.tableScrollPanel = new TableScrollPane(this.actionFlagsTable, 22, 31);
        this.tableScrollPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), TC.get((String)"AdaptationRule.InitialState.ActionFlags")));
        this.insertActionFlagButton = new JButton(new ImageIcon("img/icons/addNode.png"));
        this.insertActionFlagButton.setContentAreaFilled(false);
        this.insertActionFlagButton.setMargin(new Insets(0, 0, 0, 0));
        this.insertActionFlagButton.setBorder(BorderFactory.createEmptyBorder());
        this.insertActionFlagButton.setToolTipText(TC.get((String)"Operation.AdaptationPanel.InsertButton"));
        this.insertActionFlagButton.addActionListener(new ListenerButtonInsertLine());
        this.deleteActionFlagButton = new JButton(new ImageIcon("img/icons/deleteNode.png"));
        this.deleteActionFlagButton.setContentAreaFilled(false);
        this.deleteActionFlagButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteActionFlagButton.setBorder(BorderFactory.createEmptyBorder());
        this.deleteActionFlagButton.setToolTipText(TC.get((String)"Operation.AdaptationPanel.DeleteButton"));
        this.deleteActionFlagButton.addActionListener(new ListenerButtonDeleteLine());
        String[] stringArray = Controller.getInstance().getIdentifierSummary().getAllSceneIds();
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = TC.get((String)"GeneralText.NotSelected");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i + 1] = stringArray[i];
        }
        this.initialSceneCB = new JComboBox<String>(stringArray2);
        if (this.adaptationProfileDataControl.getInitialScene() == null) {
            this.initialSceneCB.setSelectedIndex(0);
        } else {
            this.initialSceneCB.setSelectedItem(this.adaptationProfileDataControl.getInitialScene());
        }
        this.initialSceneCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (InitialStatePanel.this.initialSceneCB.getSelectedIndex() > 0) {
                    InitialStatePanel.this.adaptationProfileDataControl.setInitialScene(InitialStatePanel.this.initialSceneCB.getSelectedItem().toString());
                }
                if (InitialStatePanel.this.initialSceneCB.getSelectedIndex() == 0) {
                    InitialStatePanel.this.adaptationProfileDataControl.setInitialScene(null);
                }
            }
        });
        this.addComponents(false);
    }

    private void addComponents(boolean bl) {
        this.removeAll();
        this.deleteActionFlagButton.setEnabled(false);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.initialSceneCB, "Center");
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"AdaptationRule.InitialState.InitialScene")));
        this.add((Component)jPanel, "North");
        this.add((Component)this.tableScrollPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)this.insertActionFlagButton, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel2.add((Component)this.deleteActionFlagButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)new JFiller(), gridBagConstraints);
        this.add((Component)jPanel2, "East");
    }

    @Override
    public boolean updateFields() {
        int n = this.actionFlagsTable.getSelectedRow();
        this.actionFlagsTable.clearSelection();
        String string = this.adaptationProfileDataControl.getInitialScene();
        if (string == null) {
            this.initialSceneCB.setSelectedIndex(0);
        } else {
            this.initialSceneCB.setSelectedItem(this.adaptationProfileDataControl.getInitialScene());
        }
        this.deleteActionFlagButton.setEnabled(false);
        if (this.actionFlagsTable.getCellEditor() != null) {
            this.actionFlagsTable.getCellEditor().stopCellEditing();
        }
        ((AbstractTableModel)this.actionFlagsTable.getModel()).fireTableDataChanged();
        this.actionFlagsTable.getSelectionModel().setSelectionInterval(n, n);
        return true;
    }

    private class NodeTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        @Override
        public String getColumnName(int n) {
            String string = "";
            if (n == 0) {
                string = "Var?";
            } else if (n == 1) {
                string = "Flag?";
            }
            if (n == 2) {
                string = TC.get((String)"Element.Action");
            } else if (n == 3) {
                string = "Var/Flag";
            }
            return string;
        }

        @Override
        public int getRowCount() {
            int n = 0;
            if (InitialStatePanel.this.adaptationProfileDataControl != null) {
                n = InitialStatePanel.this.adaptationProfileDataControl.getFlagActionCount();
            }
            return n;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n == InitialStatePanel.this.actionFlagsTable.getSelectedRow();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (object != null && !object.toString().trim().equals("") && n2 <= 1) {
                String[] stringArray;
                if (n2 == 0 && InitialStatePanel.this.adaptationProfileDataControl.isFlag(n) && InitialStatePanel.this.actionFlagsTable.getSelectedRow() == n) {
                    stringArray = Controller.getInstance().getVarFlagSummary().getVars();
                    if (stringArray.length == 0) {
                        InitialStatePanel.this.adaptationProfileDataControl.change(n, TC.get((String)"Vars.DefaultVarName"));
                    } else {
                        InitialStatePanel.this.adaptationProfileDataControl.change(n, stringArray[0]);
                    }
                }
                if (n2 == 1 && !InitialStatePanel.this.adaptationProfileDataControl.isFlag(n) && InitialStatePanel.this.actionFlagsTable.getSelectedRow() == n) {
                    stringArray = Controller.getInstance().getVarFlagSummary().getFlags();
                    if (stringArray.length == 0) {
                        InitialStatePanel.this.adaptationProfileDataControl.change(n, TC.get((String)"Vars.DefaultVarName"));
                    } else {
                        InitialStatePanel.this.adaptationProfileDataControl.change(n, stringArray[0]);
                    }
                }
                this.fireTableRowsUpdated(n, n);
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object object = null;
            switch (n2) {
                case 0: {
                    object = !InitialStatePanel.this.adaptationProfileDataControl.isFlag(n);
                    break;
                }
                case 1: {
                    object = InitialStatePanel.this.adaptationProfileDataControl.isFlag(n);
                    break;
                }
                case 2: 
                case 3: {
                    object = InitialStatePanel.this.adaptationProfileDataControl;
                }
            }
            return object;
        }
    }

    private class NodeTableSelectionListener
    implements ListSelectionListener {
        private NodeTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (listSelectionModel.isSelectionEmpty()) {
                InitialStatePanel.this.deleteActionFlagButton.setEnabled(false);
            } else {
                InitialStatePanel.this.deleteActionFlagButton.setEnabled(true);
            }
        }
    }

    private class ListenerButtonDeleteLine
    implements ActionListener {
        private ListenerButtonDeleteLine() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = InitialStatePanel.this.actionFlagsTable.getSelectedRow();
            InitialStatePanel.this.adaptationProfileDataControl.deleteFlagAction(n);
            if (InitialStatePanel.this.adaptationProfileDataControl.getFlagActionCount() == 0) {
                InitialStatePanel.this.actionFlagsTable.clearSelection();
            } else if (InitialStatePanel.this.adaptationProfileDataControl.getFlagActionCount() == n) {
                InitialStatePanel.this.actionFlagsTable.setRowSelectionInterval(n - 1, n - 1);
            }
            InitialStatePanel.this.actionFlagsTable.revalidate();
        }
    }

    private class ListenerButtonInsertLine
    implements ActionListener {
        private ListenerButtonInsertLine() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = InitialStatePanel.this.actionFlagsTable.getSelectedRow();
            if (n == -1) {
                n = InitialStatePanel.this.actionFlagsTable.getRowCount() - 1;
            }
            if (InitialStatePanel.this.adaptationProfileDataControl.addFlagAction(n + 1)) {
                InitialStatePanel.this.actionFlagsTable.setRowSelectionInterval(n + 1, n + 1);
                InitialStatePanel.this.actionFlagsTable.scrollRectToVisible(InitialStatePanel.this.actionFlagsTable.getCellRect(n + 1, 0, true));
                InitialStatePanel.this.actionFlagsTable.revalidate();
            }
        }
    }
}

