/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.adaptation;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.adaptation.AdaptationRuleDataControl;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.auxiliar.components.JFiller;
import es.eucm.eadventure.editor.gui.elementpanels.adaptation.FlagsVarListRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

class GameStatePanel
extends JPanel
implements Updateable {
    private static final long serialVersionUID = 1L;
    private AdaptationRuleDataControl adaptationRuleDataControl;
    private JTable actionFlagsTable;
    private JScrollPane tableScrollPanel;
    private JButton insertActionFlagButton;
    private JButton deleteActionFlagButton;
    private NodeTableModel tableModel;
    private JComboBox actionValues;

    public GameStatePanel(AdaptationRuleDataControl adaptationRuleDataControl) {
        this.adaptationRuleDataControl = adaptationRuleDataControl;
        this.setLayout(new BorderLayout());
        this.tableModel = new NodeTableModel();
        this.actionFlagsTable = new JTable(this.tableModel);
        this.actionFlagsTable.setAutoCreateColumnsFromModel(false);
        this.actionFlagsTable.getColumnModel().getColumn(0).setMaxWidth(60);
        this.actionFlagsTable.getColumnModel().getColumn(1).setMaxWidth(60);
        this.actionFlagsTable.setSelectionMode(0);
        this.actionFlagsTable.setCellSelectionEnabled(false);
        this.actionFlagsTable.setColumnSelectionAllowed(false);
        this.actionFlagsTable.setRowSelectionAllowed(true);
        this.actionFlagsTable.setIntercellSpacing(new Dimension(1, 1));
        this.actionFlagsTable.getSelectionModel().addListSelectionListener(new NodeTableSelectionListener());
        this.actionFlagsTable.getSelectionModel().setSelectionMode(0);
        this.actionFlagsTable.getColumnModel().getColumn(0).setCellRenderer(this.actionFlagsTable.getDefaultRenderer(Boolean.class));
        this.actionFlagsTable.getColumnModel().getColumn(0).setCellEditor(this.actionFlagsTable.getDefaultEditor(Boolean.class));
        this.actionFlagsTable.getColumnModel().getColumn(1).setCellRenderer(this.actionFlagsTable.getDefaultRenderer(Boolean.class));
        this.actionFlagsTable.getColumnModel().getColumn(1).setCellEditor(this.actionFlagsTable.getDefaultEditor(Boolean.class));
        this.actionFlagsTable.getColumnModel().getColumn(2).setCellRenderer(new FlagsVarListRenderer());
        this.actionFlagsTable.getColumnModel().getColumn(2).setCellEditor(new FlagsVarListRenderer());
        this.actionFlagsTable.getColumnModel().getColumn(3).setCellRenderer(new FlagsVarListRenderer());
        this.actionFlagsTable.getColumnModel().getColumn(3).setCellEditor(new FlagsVarListRenderer());
        this.actionFlagsTable.setRowHeight(22);
        this.tableScrollPanel = new JScrollPane(this.actionFlagsTable, 22, 31);
        this.tableScrollPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), TC.get((String)"AdaptationRule.GameState.ActionFlags")));
        this.insertActionFlagButton = new JButton(new ImageIcon("img/icons/addNode.png"));
        this.insertActionFlagButton.setContentAreaFilled(false);
        this.insertActionFlagButton.setMargin(new Insets(0, 0, 0, 0));
        this.insertActionFlagButton.setBorder(BorderFactory.createEmptyBorder());
        this.insertActionFlagButton.setToolTipText(TC.get((String)"Operation.AdaptationPanel.InsertButton"));
        this.insertActionFlagButton.addActionListener(new ListenerButtonInsertLine());
        this.deleteActionFlagButton = new JButton(new ImageIcon("img/icons/deleteNode.png"));
        this.deleteActionFlagButton.setContentAreaFilled(false);
        this.deleteActionFlagButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteActionFlagButton.setBorder(BorderFactory.createEmptyBorder());
        this.deleteActionFlagButton.setToolTipText(TC.get((String)"Operation.AdaptationPanel.DeleteButton"));
        this.deleteActionFlagButton.addActionListener(new ListenerButtonDeleteLine());
        String[] stringArray = Controller.getInstance().getIdentifierSummary().getSceneIds();
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = TC.get((String)"GeneralText.NotSelected");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i + 1] = stringArray[i];
        }
        this.addComponents();
    }

    private void addComponents() {
        this.removeAll();
        this.deleteActionFlagButton.setEnabled(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tableScrollPanel, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.insertActionFlagButton, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.deleteActionFlagButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)new JFiller(), gridBagConstraints);
        this.add((Component)jPanel, "East");
    }

    @Override
    public boolean updateFields() {
        int n = this.actionFlagsTable.getSelectedRow();
        this.deleteActionFlagButton.setEnabled(false);
        if (this.actionFlagsTable.getCellEditor() != null) {
            this.actionFlagsTable.getCellEditor().stopCellEditing();
        }
        ((AbstractTableModel)this.actionFlagsTable.getModel()).fireTableDataChanged();
        this.actionFlagsTable.getSelectionModel().setSelectionInterval(n, n);
        return true;
    }

    private class NodeTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        @Override
        public String getColumnName(int n) {
            String string = "";
            if (n == 0) {
                string = "Var?";
            } else if (n == 1) {
                string = "Flag?";
            }
            if (n == 2) {
                string = TC.get((String)"Element.Action");
            } else if (n == 3) {
                string = "Var/Flag";
            }
            return string;
        }

        @Override
        public int getRowCount() {
            int n = 0;
            if (GameStatePanel.this.adaptationRuleDataControl != null) {
                n = GameStatePanel.this.adaptationRuleDataControl.getFlagActionCount();
            }
            return n;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n == GameStatePanel.this.actionFlagsTable.getSelectedRow();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (object != null && !object.toString().trim().equals("") && n2 <= 1) {
                String[] stringArray;
                if (n2 == 0 && GameStatePanel.this.adaptationRuleDataControl.isFlag(n) && GameStatePanel.this.actionFlagsTable.getSelectedRow() == n) {
                    stringArray = Controller.getInstance().getVarFlagSummary().getVars();
                    if (stringArray.length == 0) {
                        GameStatePanel.this.adaptationRuleDataControl.change(n, "");
                    } else {
                        GameStatePanel.this.adaptationRuleDataControl.change(n, stringArray[0]);
                    }
                }
                if (n2 == 1 && !GameStatePanel.this.adaptationRuleDataControl.isFlag(n) && GameStatePanel.this.actionFlagsTable.getSelectedRow() == n) {
                    stringArray = Controller.getInstance().getVarFlagSummary().getFlags();
                    if (stringArray.length == 0) {
                        GameStatePanel.this.adaptationRuleDataControl.change(n, "");
                    } else {
                        GameStatePanel.this.adaptationRuleDataControl.change(n, stringArray[0]);
                    }
                }
                this.fireTableRowsUpdated(n, n);
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object object = null;
            switch (n2) {
                case 0: {
                    object = !GameStatePanel.this.adaptationRuleDataControl.isFlag(n);
                    break;
                }
                case 1: {
                    object = GameStatePanel.this.adaptationRuleDataControl.isFlag(n);
                    break;
                }
                case 2: 
                case 3: {
                    object = GameStatePanel.this.adaptationRuleDataControl;
                }
            }
            return object;
        }
    }

    private class NodeTableSelectionListener
    implements ListSelectionListener {
        private NodeTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (listSelectionModel.isSelectionEmpty()) {
                GameStatePanel.this.deleteActionFlagButton.setEnabled(false);
            } else {
                GameStatePanel.this.deleteActionFlagButton.setEnabled(true);
            }
        }
    }

    private class ListenerButtonDeleteLine
    implements ActionListener {
        private ListenerButtonDeleteLine() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = GameStatePanel.this.actionFlagsTable.getSelectedRow();
            GameStatePanel.this.adaptationRuleDataControl.deleteFlagAction(n);
            if (GameStatePanel.this.adaptationRuleDataControl.getFlagActionCount() == 0) {
                GameStatePanel.this.actionFlagsTable.clearSelection();
            } else if (GameStatePanel.this.adaptationRuleDataControl.getFlagActionCount() == n) {
                GameStatePanel.this.actionFlagsTable.setRowSelectionInterval(n - 1, n - 1);
            }
            GameStatePanel.this.actionFlagsTable.revalidate();
        }
    }

    private class ListenerButtonInsertLine
    implements ActionListener {
        private ListenerButtonInsertLine() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = GameStatePanel.this.actionFlagsTable.getSelectedRow();
            if (n == -1) {
                n = GameStatePanel.this.actionFlagsTable.getRowCount() - 1;
            }
            if (GameStatePanel.this.adaptationRuleDataControl.addFlagAction(n + 1)) {
                GameStatePanel.this.actionFlagsTable.setRowSelectionInterval(n + 1, n + 1);
                GameStatePanel.this.actionFlagsTable.scrollRectToVisible(GameStatePanel.this.actionFlagsTable.getCellRect(n + 1, 0, true));
                GameStatePanel.this.actionFlagsTable.revalidate();
            }
        }
    }
}

