/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.adaptation;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.adaptation.AdaptationProfileDataControl;
import es.eucm.eadventure.editor.control.controllers.adaptation.AdaptationRuleDataControl;
import es.eucm.eadventure.editor.gui.editdialogs.VarDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class FlagsVarListRenderer
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor {
    private static final long serialVersionUID = 1L;
    private DataControl value;

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.value = (DataControl)object;
        boolean bl3 = false;
        if (this.value instanceof AdaptationRuleDataControl) {
            bl3 = ((AdaptationRuleDataControl)object).isFlag(n);
        } else if (this.value instanceof AdaptationProfileDataControl) {
            bl3 = ((AdaptationProfileDataControl)object).isFlag(n);
        }
        if (n2 == 2) {
            return this.prepareAction(bl3, n, jTable, bl);
        }
        if (n2 == 3) {
            return this.prepareValue(bl3, n, bl, jTable);
        }
        return null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.value = (DataControl)object;
        boolean bl2 = false;
        if (this.value instanceof AdaptationRuleDataControl) {
            bl2 = ((AdaptationRuleDataControl)object).isFlag(n);
        } else if (this.value instanceof AdaptationProfileDataControl) {
            bl2 = ((AdaptationProfileDataControl)object).isFlag(n);
        }
        if (n2 == 2) {
            return this.prepareAction(bl2, n, jTable, bl);
        }
        if (n2 == 3) {
            return this.prepareValue(bl2, n, bl, jTable);
        }
        return null;
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    private JComboBox prepareValue(boolean bl, int n, boolean bl2, JTable jTable) {
        JComboBox<String> jComboBox = null;
        String string = null;
        if (this.value instanceof AdaptationRuleDataControl) {
            string = ((AdaptationRuleDataControl)this.value).getFlag(n);
        } else if (this.value instanceof AdaptationProfileDataControl) {
            string = ((AdaptationProfileDataControl)this.value).getFlag(n);
        }
        String[] stringArray = null;
        stringArray = bl ? Controller.getInstance().getVarFlagSummary().getFlags() : Controller.getInstance().getVarFlagSummary().getVars();
        jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setEditable(true);
        if (string == null || string.equals("") && stringArray.length > 0) {
            string = stringArray[0];
        }
        if (stringArray.length == 0) {
            if (bl) {
                string = TC.get((String)"Flags.DefaultFlagName");
                Controller.getInstance().getVarFlagSummary().addVar(string);
                Controller.getInstance().getVarFlagSummary().addVarReference(string);
            } else if (!bl) {
                string = TC.get((String)"Vars.DefaultVarName");
                Controller.getInstance().getVarFlagSummary().addVar(string);
                Controller.getInstance().getVarFlagSummary().addVarReference(string);
            }
            jComboBox.addItem(string);
        }
        jComboBox.setSelectedItem(string);
        jComboBox.addActionListener(new ComboListener(n, jComboBox, bl));
        if (bl2) {
            jComboBox.setBorder(BorderFactory.createMatteBorder(2, 0, 2, 0, jTable.getSelectionBackground()));
        }
        return jComboBox;
    }

    private JPanel prepareAction(boolean bl, int n, JTable jTable, boolean bl2) {
        Object object;
        String[] stringArray = null;
        String string = null;
        int n2 = -1;
        if (this.value instanceof AdaptationRuleDataControl) {
            string = ((AdaptationRuleDataControl)this.value).getAction(n);
        } else if (this.value instanceof AdaptationProfileDataControl) {
            string = ((AdaptationProfileDataControl)this.value).getAction(n);
        }
        if (!bl) {
            object = string.split(" ");
            n2 = ((String[])object).length < 2 ? 0 : Integer.parseInt(object[1]);
            string = object[0];
            stringArray = new String[]{TC.get((String)"Effect.Increment"), TC.get((String)"Effect.Decrement"), TC.get((String)"Effect.Option.SetValue")};
        } else {
            stringArray = new String[]{TC.get((String)"Effect.Activate"), TC.get((String)"Effect.Deactivate")};
        }
        string = this.getActionNameFromEngineName(string);
        object = new JLabel(string);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.5;
        ((JComponent)object).setOpaque(false);
        jPanel.add((Component)object, gridBagConstraints);
        jPanel.setBackground(Color.white);
        JButton jButton = new JButton(TC.get((String)"GeneralText.Edit"));
        jButton.addActionListener(new EditButtonListener(stringArray, n2, n, string));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 2));
        jPanel2.add(jPanel);
        if (!bl) {
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.5;
            JLabel jLabel = new JLabel(String.valueOf(n2));
            jPanel.add((Component)jLabel, gridBagConstraints);
        }
        jPanel2.add(jButton);
        if (bl2) {
            jPanel2.setBorder(BorderFactory.createMatteBorder(2, 0, 2, 0, jTable.getSelectionBackground()));
        }
        return jPanel2;
    }

    private String getActionNameFromEngineName(String string) {
        if (string.equalsIgnoreCase("activate")) {
            string = TC.get((String)"Effect.Activate");
        } else if (string.equalsIgnoreCase("deactivate")) {
            string = TC.get((String)"Effect.Deactivate");
        } else if (string.equalsIgnoreCase("increment")) {
            string = TC.get((String)"Effect.Increment");
        } else if (string.equalsIgnoreCase("decrement")) {
            string = TC.get((String)"Effect.Decrement");
        } else if (string.equalsIgnoreCase("set-value")) {
            string = TC.get((String)"Effect.Option.SetValue");
        }
        return string;
    }

    private String getActionNameFromi18n(String string) {
        String[] stringArray = string.split(" ");
        if (stringArray[0].equalsIgnoreCase(TC.get((String)"Effect.Activate"))) {
            stringArray[0] = "activate";
        } else if (stringArray[0].equalsIgnoreCase(TC.get((String)"Effect.Deactivate"))) {
            stringArray[0] = "deactivate";
        } else if (stringArray[0].equalsIgnoreCase(TC.get((String)"Effect.Increment"))) {
            stringArray[0] = "increment";
        } else if (stringArray[0].equalsIgnoreCase(TC.get((String)"Effect.Decrement"))) {
            stringArray[0] = "decrement";
        } else if (stringArray[0].equalsIgnoreCase(TC.get((String)"Effect.Option.SetValue"))) {
            stringArray[0] = "set-value";
        }
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        return stringArray[0] + " " + stringArray[1];
    }

    private class EditButtonListener
    implements ActionListener {
        private String[] actions;
        private int varVal;
        private int rowIndex;
        private String action;

        public EditButtonListener(String[] stringArray, int n, int n2, String string) {
            this.actions = stringArray;
            this.varVal = n;
            this.rowIndex = n2;
            this.action = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            VarDialog varDialog = new VarDialog(this.varVal, this.actions, this.action);
            if (!varDialog.getValue().equals("close")) {
                if (FlagsVarListRenderer.this.value instanceof AdaptationRuleDataControl) {
                    ((AdaptationRuleDataControl)FlagsVarListRenderer.this.value).setAction(this.rowIndex, FlagsVarListRenderer.this.getActionNameFromi18n(varDialog.getValue()));
                } else if (FlagsVarListRenderer.this.value instanceof AdaptationProfileDataControl) {
                    ((AdaptationProfileDataControl)FlagsVarListRenderer.this.value).setAction(this.rowIndex, FlagsVarListRenderer.this.getActionNameFromi18n(varDialog.getValue()));
                }
                if (this.varVal >= 0) {
                    this.varVal = Integer.parseInt(varDialog.getValue().split(" ")[1]);
                }
                FlagsVarListRenderer.this.stopCellEditing();
            }
        }
    }

    private class ComboListener
    implements ActionListener {
        private int rowIndex;
        private JComboBox combo;
        private boolean isFlag;

        public ComboListener(int n, JComboBox jComboBox, boolean bl) {
            this.rowIndex = n;
            this.combo = jComboBox;
            this.isFlag = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)this.combo.getSelectedItem();
            if (!this.isFlag) {
                if (!Controller.getInstance().getVarFlagSummary().existsVar(string) && !string.equals("")) {
                    Controller.getInstance().getVarFlagSummary().addVar(string);
                    Controller.getInstance().getVarFlagSummary().addVarReference(string);
                    this.combo.addItem(string);
                }
            } else if (this.isFlag && !Controller.getInstance().getVarFlagSummary().existsFlag(string) && !string.equals("")) {
                Controller.getInstance().getVarFlagSummary().addFlag(string);
                Controller.getInstance().getVarFlagSummary().addFlagReference(string);
                this.combo.addItem(string);
            }
            if (FlagsVarListRenderer.this.value instanceof AdaptationRuleDataControl) {
                ((AdaptationRuleDataControl)FlagsVarListRenderer.this.value).setFlag(this.rowIndex, string);
            } else if (FlagsVarListRenderer.this.value instanceof AdaptationProfileDataControl) {
                ((AdaptationProfileDataControl)FlagsVarListRenderer.this.value).setFlag(this.rowIndex, string);
            }
        }
    }
}

