/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.adaptation;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.adaptation.AdaptationProfileDataControl;
import es.eucm.eadventure.editor.control.tools.generic.ChangeStringValueTool;
import es.eucm.eadventure.editor.gui.elementpanels.adaptation.InitialSceneCellRendererEditor;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.StringCellRendererEditor;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class AdaptationRulesTable
extends JTable {
    private static final long serialVersionUID = 647135614707098595L;
    private AdaptationProfileDataControl dataControl;

    public AdaptationRulesTable(AdaptationProfileDataControl adaptationProfileDataControl) {
        this.dataControl = adaptationProfileDataControl;
        this.setModel(new AdaptationRulesTableModel());
        this.getSelectionModel().setSelectionMode(0);
        this.getColumnModel().getColumn(0).setWidth(20);
        this.getColumnModel().getColumn(0).setMaxWidth(20);
        this.getColumnModel().getColumn(1).setCellEditor(new StringCellRendererEditor());
        this.getColumnModel().getColumn(1).setCellRenderer(new StringCellRendererEditor());
        this.getColumnModel().getColumn(2).setCellEditor(new InitialSceneCellRendererEditor());
        this.getColumnModel().getColumn(2).setCellRenderer(new InitialSceneCellRendererEditor());
        this.setRowHeight(22);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AdaptationRulesTable.this.setRowHeight(22);
                if (AdaptationRulesTable.this.getSelectedRow() >= 0) {
                    AdaptationRulesTable.this.setRowHeight(AdaptationRulesTable.this.getSelectedRow(), 35);
                }
            }
        });
    }

    public void fireTableDataChanged() {
        ((AbstractTableModel)this.getModel()).fireTableDataChanged();
    }

    public class AdaptationRulesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return AdaptationRulesTable.this.dataControl.getAdaptationRules().size();
        }

        @Override
        public String getColumnName(int n) {
            String string = "";
            if (n == 0) {
                string = TC.get((String)"AdaptationRulesList.ColumnHeader0");
            } else if (n == 1) {
                string = TC.get((String)"AdaptationRule.Description");
            } else if (n == 2) {
                string = TC.get((String)"AdaptationRule.InitialState.InitialScene");
            }
            return string;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return n;
            }
            if (n2 == 1) {
                return AdaptationRulesTable.this.dataControl.getAdaptationRules().get(n).getDescription();
            }
            if (n2 == 2) {
                return AdaptationRulesTable.this.dataControl.getAdaptationRules().get(n);
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                Controller.getInstance().addTool(new ChangeStringValueTool(AdaptationRulesTable.this.dataControl.getAdaptationRules().get(n).getContent(), (String)object, "getDescription", "setDescription"));
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n == AdaptationRulesTable.this.getSelectedRow() && n2 > 0;
        }
    }
}

