/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.adaptation;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.adaptation.AdaptationProfileDataControl;
import es.eucm.eadventure.editor.control.controllers.adaptation.AdaptationRuleDataControl;
import es.eucm.eadventure.editor.control.tools.adaptation.AddRuleTool;
import es.eucm.eadventure.editor.control.tools.adaptation.DeleteRuleTool;
import es.eucm.eadventure.editor.control.tools.adaptation.DuplicateRuleTool;
import es.eucm.eadventure.editor.gui.DataControlsPanel;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.auxiliar.components.JFiller;
import es.eucm.eadventure.editor.gui.elementpanels.PanelTab;
import es.eucm.eadventure.editor.gui.elementpanels.adaptation.AdaptationRulesTable;
import es.eucm.eadventure.editor.gui.elementpanels.adaptation.GameStatePanel;
import es.eucm.eadventure.editor.gui.elementpanels.adaptation.InitialStatePanel;
import es.eucm.eadventure.editor.gui.elementpanels.adaptation.UOLPropertiesPanel;
import es.eucm.eadventure.editor.gui.elementpanels.general.TableScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class AdaptationEditionPanel
extends JPanel
implements Updateable,
DataControlsPanel {
    private static final long serialVersionUID = 1L;
    private JPanel profileTypePanel;
    private InitialStatePanel initialStatePanel;
    private JPanel ruleListPanel;
    private JTabbedPane rulesInfoPanel;
    private JButton duplicate;
    private JButton delete;
    private AdaptationProfileDataControl dataControl;
    private JTable informationTable;
    private JComboBox comboProfile;
    private JButton movePropertyUpButton;
    private JButton movePropertyDownButton;
    JLabel typeLabel;

    public AdaptationEditionPanel(AdaptationProfileDataControl adaptationProfileDataControl) {
        this.dataControl = adaptationProfileDataControl;
        this.createProfileTypePanel();
        this.createInitialState();
        this.createRuleListPanel();
        this.rulesInfoPanel = new JTabbedPane();
        this.createRulesInfoPanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.profileTypePanel, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.gridx = 1;
        this.add((Component)this.initialStatePanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipady = 100;
        ++gridBagConstraints.gridy;
        this.add((Component)this.ruleListPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.rulesInfoPanel, gridBagConstraints);
    }

    public void createProfileTypePanel() {
        this.profileTypePanel = new JPanel();
        this.profileTypePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"AssessmentRule.ProfileType")));
        String[] stringArray = new String[]{TC.get((String)"AdaptationRulesList.Scorm2004"), TC.get((String)"AdaptationRulesList.Scorm12"), TC.get((String)"AdaptationRulesList.Normal")};
        this.comboProfile = new JComboBox<String>(stringArray);
        if (this.dataControl.isScorm12()) {
            this.comboProfile.setSelectedIndex(1);
        } else if (this.dataControl.isScorm2004()) {
            this.comboProfile.setSelectedIndex(0);
        } else {
            this.comboProfile.setSelectedIndex(2);
        }
        this.comboProfile.addActionListener(new ComboListener(this.comboProfile.getSelectedIndex()));
        this.profileTypePanel.add(this.comboProfile);
    }

    public void createInitialState() {
        this.initialStatePanel = new InitialStatePanel(this.dataControl, true);
    }

    private void createRuleListPanel() {
        this.informationTable = new AdaptationRulesTable(this.dataControl);
        this.informationTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (AdaptationEditionPanel.this.informationTable.getSelectedRow() > -1) {
                    AdaptationEditionPanel.this.delete.setEnabled(true);
                    AdaptationEditionPanel.this.duplicate.setEnabled(true);
                    AdaptationEditionPanel.this.movePropertyUpButton.setEnabled(true);
                    AdaptationEditionPanel.this.movePropertyDownButton.setEnabled(true);
                } else {
                    AdaptationEditionPanel.this.delete.setEnabled(false);
                    AdaptationEditionPanel.this.duplicate.setEnabled(false);
                    AdaptationEditionPanel.this.movePropertyUpButton.setEnabled(false);
                    AdaptationEditionPanel.this.movePropertyDownButton.setEnabled(false);
                }
                AdaptationEditionPanel.this.createRulesInfoPanel();
            }
        });
        this.ruleListPanel = new JPanel();
        this.ruleListPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"AdaptationRulesList.ListTitle")));
        this.ruleListPanel.setLayout(new BorderLayout());
        this.ruleListPanel.add((Component)new TableScrollPane(this.informationTable, 22, 31), "Center");
        JButton jButton = new JButton(new ImageIcon("img/icons/addNode.png"));
        jButton.setContentAreaFilled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setToolTipText(TC.get((String)"AdaptationProfile.AddRule"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Controller.getInstance().addTool(new AddRuleTool(AdaptationEditionPanel.this.dataControl, 39))) {
                    ((AdaptationRulesTable)AdaptationEditionPanel.this.informationTable).fireTableDataChanged();
                    AdaptationEditionPanel.this.informationTable.changeSelection(AdaptationEditionPanel.this.dataControl.getAdaptationRules().size() - 1, 0, false, false);
                }
            }
        });
        this.duplicate = new JButton(new ImageIcon("img/icons/duplicateNode.png"));
        this.duplicate.setContentAreaFilled(false);
        this.duplicate.setMargin(new Insets(0, 0, 0, 0));
        this.duplicate.setBorder(BorderFactory.createEmptyBorder());
        this.duplicate.setToolTipText(TC.get((String)"AdaptationProfile.Duplicate"));
        this.duplicate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Controller.getInstance().addTool(new DuplicateRuleTool(AdaptationEditionPanel.this.dataControl, 39, AdaptationEditionPanel.this.informationTable.getSelectedRow()))) {
                    ((AdaptationRulesTable)AdaptationEditionPanel.this.informationTable).fireTableDataChanged();
                    AdaptationEditionPanel.this.informationTable.changeSelection(AdaptationEditionPanel.this.dataControl.getAdaptationRules().size() - 1, 0, false, false);
                }
            }
        });
        this.duplicate.setEnabled(false);
        this.delete = new JButton(new ImageIcon("img/icons/deleteNode.png"));
        this.delete.setContentAreaFilled(false);
        this.delete.setMargin(new Insets(0, 0, 0, 0));
        this.delete.setBorder(BorderFactory.createEmptyBorder());
        this.delete.setToolTipText(TC.get((String)"AdaptationProfile.DeleteRule"));
        this.delete.setEnabled(false);
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Controller.getInstance().addTool(new DeleteRuleTool(AdaptationEditionPanel.this.dataControl, 39, AdaptationEditionPanel.this.informationTable.getSelectedRow()))) {
                    ((AdaptationRulesTable)AdaptationEditionPanel.this.informationTable).fireTableDataChanged();
                    AdaptationEditionPanel.this.informationTable.clearSelection();
                }
            }
        });
        this.movePropertyUpButton = new JButton(new ImageIcon("img/icons/moveNodeUp.png"));
        this.movePropertyUpButton.setContentAreaFilled(false);
        this.movePropertyUpButton.setMargin(new Insets(0, 0, 0, 0));
        this.movePropertyUpButton.setBorder(BorderFactory.createEmptyBorder());
        this.movePropertyUpButton.setToolTipText(TC.get((String)"UOLProperties.MoveUp"));
        this.movePropertyUpButton.addActionListener(new ListenerButtonMoveLineUp());
        this.movePropertyUpButton.setEnabled(false);
        this.movePropertyDownButton = new JButton(new ImageIcon("img/icons/moveNodeDown.png"));
        this.movePropertyDownButton.setContentAreaFilled(false);
        this.movePropertyDownButton.setMargin(new Insets(0, 0, 0, 0));
        this.movePropertyDownButton.setBorder(BorderFactory.createEmptyBorder());
        this.movePropertyDownButton.setToolTipText(TC.get((String)"UOLProperties.MoveDown"));
        this.movePropertyDownButton.addActionListener(new ListenerButtonMoveLineDown());
        this.movePropertyDownButton.setEnabled(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.duplicate, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.movePropertyUpButton, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.movePropertyDownButton, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        jPanel.add((Component)this.delete, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)new JFiller(), gridBagConstraints);
        this.ruleListPanel.add((Component)jPanel, "East");
        this.ruleListPanel.setMinimumSize(new Dimension(0, 30));
        this.ruleListPanel.setMaximumSize(new Dimension(0, 30));
    }

    private void createRulesInfoPanel() {
        if (this.informationTable.getSelectedRow() < 0 || this.informationTable.getSelectedRow() >= this.dataControl.getAdaptationRules().size()) {
            this.rulesInfoPanel.removeAll();
            JPanel jPanel = new JPanel();
            JLabel jLabel = new JLabel(TC.get((String)"AdaptationProfile.Empty"));
            jPanel.add(jLabel);
            this.rulesInfoPanel.add(jPanel);
            this.rulesInfoPanel.setMinimumSize(new Dimension(0, 100));
            this.rulesInfoPanel.updateUI();
        } else {
            this.rulesInfoPanel.removeAll();
            UOLPropertiesPanel uOLPropertiesPanel = new UOLPropertiesPanel(this.dataControl.getAdaptationRules().get(this.informationTable.getSelectedRow()), this.dataControl.isScorm12(), this.dataControl.isScorm2004());
            this.rulesInfoPanel.addTab(TC.get((String)"AdaptationProfile.TabbedLMSState"), uOLPropertiesPanel);
            GameStatePanel gameStatePanel = new GameStatePanel(this.dataControl.getAdaptationRules().get(this.informationTable.getSelectedRow()));
            this.rulesInfoPanel.addTab(TC.get((String)"AdaptationProfile.TabbedInitialState"), gameStatePanel);
            this.rulesInfoPanel.setPreferredSize(new Dimension(0, 250));
            this.rulesInfoPanel.updateUI();
        }
    }

    @Override
    public boolean updateFields() {
        int n = this.informationTable.getSelectedRow();
        this.initialStatePanel.updateFields();
        if (this.informationTable.getCellEditor() != null) {
            this.informationTable.getCellEditor().cancelCellEditing();
        }
        ((AbstractTableModel)this.informationTable.getModel()).fireTableDataChanged();
        if (this.dataControl.isScorm12()) {
            this.comboProfile.setSelectedIndex(1);
        } else if (this.dataControl.isScorm2004()) {
            this.comboProfile.setSelectedIndex(0);
        } else {
            this.comboProfile.setSelectedIndex(2);
        }
        this.informationTable.getSelectionModel().setSelectionInterval(n, n);
        return true;
    }

    @Override
    public void setSelectedItem(List<Searchable> list) {
        if (list.size() > 0) {
            for (int i = 0; i < this.dataControl.getDataControls().size(); ++i) {
                if (this.dataControl.getDataControls().get(i) != list.get(list.size() - 1)) continue;
                this.informationTable.changeSelection(i, i, false, false);
            }
        }
    }

    private class ListenerButtonMoveLineDown
    implements ActionListener {
        private ListenerButtonMoveLineDown() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = AdaptationEditionPanel.this.informationTable.getSelectedRow();
            if (AdaptationEditionPanel.this.dataControl.moveElementDown(AdaptationEditionPanel.this.dataControl.getAdaptationRules().get(n))) {
                AdaptationEditionPanel.this.informationTable.setRowSelectionInterval(n + 1, n + 1);
                AdaptationEditionPanel.this.informationTable.scrollRectToVisible(AdaptationEditionPanel.this.informationTable.getCellRect(n + 1, 0, true));
            }
        }
    }

    private class ListenerButtonMoveLineUp
    implements ActionListener {
        private ListenerButtonMoveLineUp() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = AdaptationEditionPanel.this.informationTable.getSelectedRow();
            if (AdaptationEditionPanel.this.dataControl.moveElementUp(AdaptationEditionPanel.this.dataControl.getAdaptationRules().get(n))) {
                AdaptationEditionPanel.this.informationTable.setRowSelectionInterval(n - 1, n - 1);
                AdaptationEditionPanel.this.informationTable.scrollRectToVisible(AdaptationEditionPanel.this.informationTable.getCellRect(n - 1, 0, true));
            }
        }
    }

    private class UOLPropertiesPanelTab
    extends PanelTab {
        private AdaptationRuleDataControl dataControl;
        private boolean isScorm12;
        private boolean isScorm2004;

        public UOLPropertiesPanelTab(AdaptationRuleDataControl adaptationRuleDataControl, boolean bl, boolean bl2) {
            super(TC.get((String)"AdaptationProfile.TabbedLMSState"), adaptationRuleDataControl);
            this.dataControl = adaptationRuleDataControl;
            this.isScorm12 = bl;
            this.isScorm2004 = bl2;
        }

        @Override
        protected JComponent getTabComponent() {
            return new UOLPropertiesPanel(this.dataControl, this.isScorm12, this.isScorm2004);
        }
    }

    private class GameStatePanelTab
    extends PanelTab {
        private AdaptationRuleDataControl dataControl;

        public GameStatePanelTab(AdaptationRuleDataControl adaptationRuleDataControl) {
            super(TC.get((String)"AdaptationProfile.TabbedInitialState"), adaptationRuleDataControl);
            this.dataControl = adaptationRuleDataControl;
        }

        @Override
        protected JComponent getTabComponent() {
            return new GameStatePanel(this.dataControl);
        }
    }

    private class ComboListener
    implements ActionListener {
        private int pastSelection;

        public ComboListener(int n) {
            this.pastSelection = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (this.pastSelection != jComboBox.getSelectedIndex()) {
                AdaptationEditionPanel.this.informationTable.clearSelection();
                if (jComboBox.getSelectedIndex() == 0 && !AdaptationEditionPanel.this.dataControl.isScorm2004()) {
                    AdaptationEditionPanel.this.dataControl.changeToScorm2004Profile();
                } else if (jComboBox.getSelectedIndex() == 1 && !AdaptationEditionPanel.this.dataControl.isScorm12()) {
                    AdaptationEditionPanel.this.dataControl.changeToScorm12Profile();
                } else if (jComboBox.getSelectedIndex() == 2 && (AdaptationEditionPanel.this.dataControl.isScorm12() || AdaptationEditionPanel.this.dataControl.isScorm2004())) {
                    AdaptationEditionPanel.this.dataControl.changeToNormalProfile();
                }
                this.pastSelection = jComboBox.getSelectedIndex();
            }
        }
    }
}

