/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels;

import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.editdialogs.HelpDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class PanelTab
implements Updateable {
    private static final long serialVersionUID = -7666569367118952601L;
    private String title;
    private String toolTipText;
    private JComponent component;
    private Icon icon;
    private DataControl dataControl;
    private String helpPath;

    public PanelTab(String string, DataControl dataControl) {
        this.title = string;
        this.dataControl = dataControl;
    }

    public String getTitle() {
        return this.title;
    }

    public void setToolTipText(String string) {
        this.toolTipText = string;
    }

    public void setHelpPath(String string) {
        this.helpPath = string;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public JComponent getComponent() {
        this.component = this.getTabComponent();
        return this.component;
    }

    protected abstract JComponent getTabComponent();

    @Override
    public boolean updateFields() {
        if (this.component instanceof Updateable) {
            return ((Updateable)((Object)this.component)).updateFields();
        }
        return false;
    }

    public DataControl getDataControl() {
        return this.dataControl;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public JComponent getTab() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel(this.title, this.icon, 2);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jPanel.add((Component)jLabel, gridBagConstraints);
        if (this.helpPath != null) {
            JButton jButton = new JButton(new ImageIcon("img/icons/information.png"));
            jButton.setContentAreaFilled(false);
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jButton.setFocusable(false);
            jButton.setBorder(BorderFactory.createEmptyBorder());
            gridBagConstraints.gridx = 1;
            jPanel.add((Component)jButton, gridBagConstraints);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    new HelpDialog(PanelTab.this.helpPath);
                }
            });
        }
        jPanel.setFocusable(false);
        jPanel.setOpaque(false);
        return jPanel;
    }
}

