/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels;

import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.gui.DataControlsPanel;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.elementpanels.PanelTab;
import es.eucm.eadventure.editor.gui.structurepanel.StructureControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ElementPanel
extends JTabbedPane
implements Updateable,
DataControlsPanel {
    private static final long serialVersionUID = 1546563540388226634L;
    private List<PanelTab> tabs = new ArrayList<PanelTab>();
    private JComponent component = null;
    private int selected = -1;

    public ElementPanel() {
        this.addChangeListener(new ElementPanelTabChangeListener());
        this.setFocusable(false);
    }

    public void addTab(PanelTab panelTab) {
        this.tabs.add(panelTab);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        if (panelTab.getToolTipText() != null) {
            this.addTab(panelTab.getTitle(), panelTab.getIcon(), jPanel, panelTab.getToolTipText());
        } else {
            this.addTab(panelTab.getTitle(), panelTab.getIcon(), jPanel);
        }
    }

    @Override
    public boolean updateFields() {
        boolean bl = false;
        bl = this.tabs.get(this.getSelectedIndex()).updateFields();
        if (!bl) {
            ((JPanel)this.getSelectedComponent()).removeAll();
            PanelTab panelTab = this.tabs.get(this.getSelectedIndex());
            ((JPanel)this.getSelectedComponent()).add((Component)panelTab.getComponent(), "Center");
            ((JPanel)this.getSelectedComponent()).updateUI();
        }
        System.out.println("Element Panel UPDATED");
        return true;
    }

    @Override
    public void setSelectedItem(List<Searchable> list) {
        if (list.size() > 0) {
            for (int i = 0; i < this.tabs.size(); ++i) {
                if (this.tabs.get(i).getDataControl() != list.get(list.size() - 1)) continue;
                list.remove(list.size() - 1);
                this.setSelectedIndex(i);
                break;
            }
        }
        if (list.size() > 0 && this.component != null && this.component instanceof DataControlsPanel) {
            ((DataControlsPanel)((Object)this.component)).setSelectedItem(list);
            list = null;
        }
    }

    private class ElementPanelTabChangeListener
    implements ChangeListener {
        private ElementPanelTabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (ElementPanel.this.selected != ElementPanel.this.getSelectedIndex()) {
                ElementPanel.this.setCursor(new Cursor(3));
                if (ElementPanel.this.selected >= 0) {
                    ElementPanel.this.setTabComponentAt(ElementPanel.this.selected, new JLabel(((PanelTab)ElementPanel.this.tabs.get(ElementPanel.this.selected)).getTitle(), ((PanelTab)ElementPanel.this.tabs.get(ElementPanel.this.selected)).getIcon(), 2));
                }
                ElementPanel.this.selected = ElementPanel.this.getSelectedIndex();
                ((JPanel)ElementPanel.this.getSelectedComponent()).removeAll();
                PanelTab panelTab = (PanelTab)ElementPanel.this.tabs.get(ElementPanel.this.getSelectedIndex());
                ElementPanel.this.setTabComponentAt(ElementPanel.this.selected, panelTab.getTab());
                StructureControl.getInstance().visitDataControl(panelTab.getDataControl());
                ElementPanel.this.component = panelTab.getComponent();
                ((JPanel)ElementPanel.this.getSelectedComponent()).add((Component)ElementPanel.this.component, "Center");
                ((JPanel)ElementPanel.this.getSelectedComponent()).updateUI();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ElementPanel.this.setCursor(new Cursor(0));
                    }
                });
            }
        }
    }
}

