/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels;

import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.elementpanels.PanelTab;
import es.eucm.eadventure.editor.gui.structurepanel.StructureControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AuxTabPanel
extends JTabbedPane
implements Updateable {
    private static final long serialVersionUID = 1546563540388226634L;
    private List<PanelTab> tabs = new ArrayList<PanelTab>();
    private JComponent component = null;
    private int selected = -1;

    public AuxTabPanel() {
        this.addChangeListener(new ElementPanelTabChangeListener());
        this.setFocusable(false);
    }

    public void addTab(PanelTab panelTab) {
        this.tabs.add(panelTab);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        if (panelTab.getToolTipText() != null) {
            this.addTab(panelTab.getTitle(), panelTab.getIcon(), jPanel, panelTab.getToolTipText());
        } else {
            this.addTab(panelTab.getTitle(), panelTab.getIcon(), jPanel);
        }
    }

    @Override
    public boolean updateFields() {
        boolean bl = false;
        bl = this.tabs.get(this.getSelectedIndex()).updateFields();
        if (!bl) {
            ((JPanel)this.getSelectedComponent()).removeAll();
            PanelTab panelTab = this.tabs.get(this.getSelectedIndex());
            ((JPanel)this.getSelectedComponent()).add((Component)panelTab.getComponent(), "Center");
            ((JPanel)this.getSelectedComponent()).updateUI();
        }
        System.out.println("Element Panel UPDATED");
        return true;
    }

    @Override
    public void addTab(String string, Component component) {
        super.addTab(string, component);
        this.component = (JComponent)component;
    }

    @Override
    public void setSelectedIndex(int n) {
        super.setSelectedIndex(n);
        this.selected = n;
    }

    private class ElementPanelTabChangeListener
    implements ChangeListener {
        private ElementPanelTabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (AuxTabPanel.this.tabs.size() != 0 && AuxTabPanel.this.getSelectedComponent() != null && AuxTabPanel.this.selected != AuxTabPanel.this.getSelectedIndex()) {
                AuxTabPanel.this.setCursor(new Cursor(3));
                AuxTabPanel.this.selected = AuxTabPanel.this.getSelectedIndex();
                ((JPanel)AuxTabPanel.this.getSelectedComponent()).removeAll();
                PanelTab panelTab = (PanelTab)AuxTabPanel.this.tabs.get(AuxTabPanel.this.getSelectedIndex());
                AuxTabPanel.this.setTabComponentAt(AuxTabPanel.this.selected, panelTab.getTab());
                StructureControl.getInstance().visitDataControl(panelTab.getDataControl());
                AuxTabPanel.this.component = panelTab.getComponent();
                ((JPanel)AuxTabPanel.this.getSelectedComponent()).add((Component)AuxTabPanel.this.component, "Center");
                ((JPanel)AuxTabPanel.this.getSelectedComponent()).updateUI();
                if (AuxTabPanel.this.selected >= 0) {
                    AuxTabPanel.this.setTabComponentAt(AuxTabPanel.this.selected, new JLabel(((PanelTab)AuxTabPanel.this.tabs.get(AuxTabPanel.this.selected)).getTitle(), ((PanelTab)AuxTabPanel.this.tabs.get(AuxTabPanel.this.selected)).getIcon(), 2));
                }
                AuxTabPanel.this.updateUI();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AuxTabPanel.this.setCursor(new Cursor(0));
                    }
                });
            }
        }
    }
}

