/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs.effectdialogs;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.VarFlagsController;
import es.eucm.eadventure.editor.gui.editdialogs.effectdialogs.EffectDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class VarEffectDialog
extends EffectDialog {
    private static final long serialVersionUID = 1L;
    public static final int SET_VALUE = 0;
    public static final int INCREMENT_VAR = 1;
    public static final int DECREMENT_VAR = 2;
    private static final String[] dialogTitles = new String[]{"SetValueEffect.Title", "IncrementVarEffect.Title", "DecrementVarEffect.Title"};
    private static final String[] dialogDescriptions = new String[]{"SetValueEffect.Description", "IncrementVarEffect.Description", "DecrementVarEffect.Description"};
    private JComboBox varsComboBox;
    private JSpinner valuesSpinner;

    public VarEffectDialog(int n, HashMap<Integer, Object> hashMap) {
        super(TC.get((String)dialogTitles[n]), false);
        Object object;
        String[] stringArray = this.controller.getVarFlagSummary().getVars();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)dialogDescriptions[n]))));
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        gridBagConstraints.weightx = 0.5;
        this.varsComboBox = new JComboBox<String>(stringArray);
        this.varsComboBox.setEditable(true);
        int n2 = 1;
        if (hashMap != null) {
            object = (String)hashMap.get(7);
            if (object != null) {
                n2 = Integer.parseInt((String)object);
            }
            if (hashMap.containsKey(0)) {
                this.varsComboBox.setSelectedItem(hashMap.get(0));
            }
        }
        this.valuesSpinner = new JSpinner(new SpinnerNumberModel(n2, 0, Integer.MAX_VALUE, 1));
        jPanel.add((Component)this.varsComboBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.valuesSpinner, gridBagConstraints);
        this.add((Component)jPanel, "Center");
        this.setResizable(false);
        this.pack();
        object = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((((Dimension)object).width - this.getWidth()) / 2, (((Dimension)object).height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    @Override
    protected void pressedOKButton() {
        this.properties = new HashMap();
        VarFlagsController varFlagsController = new VarFlagsController(Controller.getInstance().getVarFlagSummary());
        String string = null;
        String string2 = null;
        if (this.varsComboBox.getSelectedItem() != null) {
            string = this.varsComboBox.getSelectedItem().toString();
            string2 = this.valuesSpinner.getValue().toString();
        }
        if (varFlagsController.existsVar(string)) {
            this.properties.put(0, string);
            this.properties.put(7, string2);
        } else {
            String string3 = varFlagsController.addShortCutFlagVar(false, string);
            if (string3 != null) {
                this.properties.put(0, string3);
                this.properties.put(7, string2);
            } else {
                this.properties = null;
            }
        }
    }
}

