/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs.effectdialogs;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.gui.editdialogs.effectdialogs.EffectDialog;
import es.eucm.eadventure.editor.gui.otherpanels.positionimagepanels.ElementImagePanel;
import es.eucm.eadventure.editor.gui.otherpanels.positionpanel.PositionPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class TriggerSceneEffectDialog
extends EffectDialog {
    private static final long serialVersionUID = 1L;
    private JComboBox scenesComboBox;
    private PositionPanel playerPositionPanel;

    public TriggerSceneEffectDialog(HashMap<Integer, Object> hashMap) {
        super(TC.get((String)"TriggerSceneEffect.Title"), true);
        String[] stringArray = this.controller.getIdentifierSummary().getSceneIds();
        boolean bl = Controller.getInstance().isPlayTransparent();
        if (stringArray.length > 0) {
            String string = this.controller.getPlayerImagePath();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            if (!bl) {
                jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"TriggerSceneEffect.Description"))));
            } else {
                jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"TriggerSceneEffect.Description.FirstPerson"))));
            }
            gridBagConstraints.insets = new Insets(2, 4, 4, 4);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.scenesComboBox = new JComboBox<String>(stringArray);
            jPanel.add((Component)this.scenesComboBox, gridBagConstraints);
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            if (hashMap != null) {
                int n = 0;
                int n2 = 0;
                if (hashMap.containsKey(0)) {
                    this.scenesComboBox.setSelectedItem(hashMap.get(0));
                }
                if (hashMap.containsKey(3)) {
                    n = Integer.parseInt((String)hashMap.get(3));
                }
                if (hashMap.containsKey(4)) {
                    n2 = Integer.parseInt((String)hashMap.get(4));
                }
                if (n > 5000) {
                    n = 5000;
                }
                if (n < -2000) {
                    n = -2000;
                }
                if (n2 > 5000) {
                    n2 = 5000;
                }
                if (n2 < -2000) {
                    n2 = -2000;
                }
                this.playerPositionPanel = new PositionPanel(new ElementImagePanel(null, string), n, n2);
            } else {
                this.scenesComboBox.setSelectedIndex(0);
                this.playerPositionPanel = new PositionPanel(new ElementImagePanel(null, string), 400, 500);
            }
            this.playerPositionPanel.loadImage(this.controller.getSceneImagePath(this.scenesComboBox.getSelectedItem().toString()));
            if (!bl) {
                jPanel.add((Component)this.playerPositionPanel, gridBagConstraints);
            }
            this.add((Component)jPanel, "Center");
            this.scenesComboBox.addActionListener(new ScenesComboBoxActionListener());
            this.setResizable(false);
            if (!bl) {
                this.setSize(640, 480);
            } else {
                this.setSize(250, 120);
            }
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
            this.setVisible(true);
        } else {
            this.controller.showErrorDialog(this.getTitle(), TC.get((String)"TriggerSceneEffect.ErrorNoScenes"));
        }
    }

    @Override
    protected void pressedOKButton() {
        this.properties = new HashMap();
        this.properties.put(0, this.scenesComboBox.getSelectedItem().toString());
        this.properties.put(3, String.valueOf(this.playerPositionPanel.getPositionX()));
        this.properties.put(4, String.valueOf(this.playerPositionPanel.getPositionY()));
    }

    private class ScenesComboBoxActionListener
    implements ActionListener {
        private ScenesComboBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TriggerSceneEffectDialog.this.playerPositionPanel.loadImage(TriggerSceneEffectDialog.this.controller.getSceneImagePath(TriggerSceneEffectDialog.this.scenesComboBox.getSelectedItem().toString()));
        }
    }
}

