/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs.effectdialogs;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.gui.auxiliar.components.TalkTextField;
import es.eucm.eadventure.editor.gui.editdialogs.effectdialogs.EffectDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class SpeakCharacterEffectDialog
extends EffectDialog {
    private static final long serialVersionUID = 1L;
    private JComboBox charactersComboBox;
    private JTextArea textArea;

    public SpeakCharacterEffectDialog(HashMap<Integer, Object> hashMap) {
        super(TC.get((String)"SpeakCharacterEffect.Title"), false);
        String[] stringArray = this.controller.getIdentifierSummary().getNPCIds();
        if (stringArray.length > 0) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"SpeakCharacterEffect.Description"))));
            gridBagConstraints.insets = new Insets(2, 4, 4, 4);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.charactersComboBox = new JComboBox<String>(stringArray);
            jPanel.add((Component)this.charactersComboBox, gridBagConstraints);
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weighty = 1.0;
            this.textArea = new JTextArea();
            this.textArea.setWrapStyleWord(true);
            this.textArea.setLineWrap(true);
            jPanel.add((Component)new TalkTextField(this.textArea), gridBagConstraints);
            this.add((Component)jPanel, "Center");
            if (hashMap != null) {
                if (hashMap.containsKey(2)) {
                    this.textArea.setText((String)hashMap.get(2));
                }
                if (hashMap.containsKey(0)) {
                    this.charactersComboBox.setSelectedItem(hashMap.get(0));
                }
            }
            this.setResizable(false);
            this.setSize(400, 300);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
            this.setVisible(true);
        } else {
            this.controller.showErrorDialog(this.getTitle(), TC.get((String)"SpeakCharacterEffect.ErrorNoCharacters"));
        }
    }

    @Override
    protected void pressedOKButton() {
        this.properties = new HashMap();
        this.properties.put(0, this.charactersComboBox.getSelectedItem().toString());
        this.properties.put(2, this.textArea.getText());
    }
}

