/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs.effectdialogs;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.gui.auxiliar.components.TextPreviewPanel;
import es.eucm.eadventure.editor.gui.editdialogs.ToolManagableDialog;
import es.eucm.eadventure.editor.gui.editdialogs.effectdialogs.EffectDialog;
import es.eucm.eadventure.editor.gui.otherpanels.positionimagepanels.TextImagePanel;
import es.eucm.eadventure.editor.gui.otherpanels.positionpanel.PositionPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ShowTextEffectDialog
extends EffectDialog {
    private static final long serialVersionUID = -7405590437950803927L;
    private JComboBox scenesComboBox;
    private PositionPanel textPositionPanel;
    private JTextField text;
    private TextPreviewPanel textPreviewPanel;
    private TextImagePanel imagePanel;
    private Color frontColor;
    private Color borderColor;

    public ShowTextEffectDialog(HashMap<Integer, Object> hashMap) {
        super(TC.get((String)"ShowTextEffect.Title"), true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"ShowTextEffect.Border"))));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.createTextColorPanel();
        jPanel.add((Component)jPanel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel(TC.get((String)"SceneLocation.SceneListDescription")), gridBagConstraints);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(TC.get((String)"SceneLocation.NoSceneSelected"));
        String[] stringArray = this.controller.getIdentifierSummary().getSceneIds();
        for (String string : stringArray) {
            arrayList.add(string);
        }
        stringArray = arrayList.toArray(new String[0]);
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.scenesComboBox = new JComboBox<String>(stringArray);
        this.scenesComboBox.addActionListener(new ScenesComboBoxListener());
        jPanel.add((Component)this.scenesComboBox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel(TC.get((String)"ShowTextEffect.TextLabel")), gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        this.text = new JTextField(30);
        this.text.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                ShowTextEffectDialog.this.imagePanel.setText(ShowTextEffectDialog.this.text.getText());
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.text.setEditable(true);
        jPanel3.add(this.text);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        if (hashMap != null) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (hashMap.containsKey(2)) {
                this.text.setText((String)hashMap.get(2));
            }
            if (hashMap.containsKey(3)) {
                n = Integer.parseInt((String)hashMap.get(3));
            }
            if (hashMap.containsKey(4)) {
                n2 = Integer.parseInt((String)hashMap.get(4));
            }
            if (hashMap.containsKey(9)) {
                n3 = Integer.parseInt((String)hashMap.get(9));
            }
            if (hashMap.containsKey(10)) {
                n4 = Integer.parseInt((String)hashMap.get(10));
            }
            this.frontColor = new Color(n3);
            this.borderColor = new Color(n4);
            this.imagePanel = new TextImagePanel(this.text.getText(), this.frontColor, this.borderColor);
            this.textPreviewPanel.setTextFrontColor(this.frontColor);
            this.textPreviewPanel.setTextBorderColor(this.borderColor);
            if (n > 5000) {
                n = 5000;
            }
            if (n < -2000) {
                n = -2000;
            }
            if (n2 > 5000) {
                n2 = 5000;
            }
            if (n2 < -2000) {
                n2 = -2000;
            }
            this.textPositionPanel = new PositionPanel(this.imagePanel, n, n2);
        } else {
            this.frontColor = Color.white;
            this.borderColor = Color.black;
            this.imagePanel = new TextImagePanel(this.text.getText(), this.frontColor, this.borderColor);
            this.textPositionPanel = new PositionPanel(this.imagePanel, 400, 500);
        }
        jPanel.add((Component)this.textPositionPanel, gridBagConstraints);
        this.imagePanel.repaint();
        this.add((Component)jPanel, "Center");
        this.setResizable(false);
        this.setSize(640, 640);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    private JPanel createTextColorPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.1;
        this.textPreviewPanel = new TextPreviewPanel(Color.WHITE, Color.black, false, null, null);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipady = 40;
        jPanel.add((Component)this.textPreviewPanel, gridBagConstraints);
        JButton jButton = new JButton(TC.get((String)"Player.FrontColor"));
        jButton.addActionListener(new ChangeTextColorListener(this, 0));
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.ipady = 0;
        jPanel.add((Component)jButton, gridBagConstraints);
        JButton jButton2 = new JButton(TC.get((String)"Player.BorderColor"));
        jButton2.addActionListener(new ChangeTextColorListener(this, 1));
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jButton2, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Player.TextColor")));
        return jPanel;
    }

    @Override
    protected void pressedOKButton() {
        this.properties = new HashMap();
        this.properties.put(2, this.text.getText());
        this.properties.put(3, String.valueOf(this.textPositionPanel.getPositionX()));
        this.properties.put(4, String.valueOf(this.textPositionPanel.getPositionY()));
        this.properties.put(9, String.valueOf(this.frontColor.getRGB()));
        this.properties.put(10, String.valueOf(this.borderColor.getRGB()));
    }

    private class ChangeTextColorListener
    implements ActionListener {
        public static final int FRONT_COLOR = 0;
        public static final int BORDER_COLOR = 1;
        private int color;
        private EffectColorChooser colorChooser;
        private TextPreviewPanel colorPreviewPanel;

        public ChangeTextColorListener(Window window, int n) {
            this.color = n;
            this.colorChooser = new EffectColorChooser(window, Color.WHITE, new UpdateColorListener());
            this.colorPreviewPanel = new TextPreviewPanel(Color.WHITE, Color.yellow, false, null, null);
            this.colorPreviewPanel.setPreferredSize(new Dimension(400, 40));
            this.colorPreviewPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.colorChooser.setPreviewPanel(this.colorPreviewPanel);
            this.colorChooser.getSelectionModel().addChangeListener(new UpdatePreviewPanelListener());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.color == 0) {
                this.colorChooser.setColor(ShowTextEffectDialog.this.frontColor);
            } else if (this.color == 1) {
                this.colorChooser.setColor(ShowTextEffectDialog.this.borderColor);
            }
            this.colorPreviewPanel.setTextFrontColor(ShowTextEffectDialog.this.frontColor);
            this.colorPreviewPanel.setTextBorderColor(ShowTextEffectDialog.this.borderColor);
            if (this.color == 0) {
                this.colorChooser.setTitle(TC.get((String)"Player.FrontColor"));
            } else if (this.color == 1) {
                this.colorChooser.setTitle(TC.get((String)"Player.BorderColor"));
            }
            this.colorChooser.setVisible(true);
        }

        private class UpdatePreviewPanelListener
        implements ChangeListener {
            private UpdatePreviewPanelListener() {
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (ChangeTextColorListener.this.color == 0) {
                    ChangeTextColorListener.this.colorPreviewPanel.setTextFrontColor(ChangeTextColorListener.this.colorChooser.getColor());
                } else if (ChangeTextColorListener.this.color == 1) {
                    ChangeTextColorListener.this.colorPreviewPanel.setTextBorderColor(ChangeTextColorListener.this.colorChooser.getColor());
                }
            }
        }

        private class UpdateColorListener
        implements ActionListener {
            private UpdateColorListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ChangeTextColorListener.this.color == 0) {
                    ShowTextEffectDialog.this.frontColor = ChangeTextColorListener.this.colorChooser.getColor();
                    ShowTextEffectDialog.this.textPreviewPanel.setTextFrontColor(ChangeTextColorListener.this.colorChooser.getColor());
                    ShowTextEffectDialog.this.imagePanel.setTextFrontColor(ChangeTextColorListener.this.colorChooser.getColor());
                } else if (ChangeTextColorListener.this.color == 1) {
                    ShowTextEffectDialog.this.borderColor = ChangeTextColorListener.this.colorChooser.getColor();
                    ShowTextEffectDialog.this.textPreviewPanel.setTextBorderColor(ChangeTextColorListener.this.colorChooser.getColor());
                    ShowTextEffectDialog.this.imagePanel.setTextBorderColor(ChangeTextColorListener.this.colorChooser.getColor());
                }
                ShowTextEffectDialog.this.imagePanel.repaint();
                ShowTextEffectDialog.this.textPreviewPanel.repaint();
            }
        }
    }

    private class EffectColorChooser
    extends ToolManagableDialog {
        private static final long serialVersionUID = 5119982246314726323L;
        JColorChooser colorChooser;

        public EffectColorChooser(Window window, Color color, ActionListener actionListener) {
            super(window, "", false);
            this.colorChooser = new JColorChooser(color);
            this.add((Component)this.colorChooser, "Center");
            JPanel jPanel = new JPanel();
            JButton jButton = new JButton("ok");
            jButton.addActionListener(actionListener);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EffectColorChooser.this.dispose();
                }
            });
            jPanel.add(jButton);
            this.add((Component)jPanel, "South");
            this.setResizable(false);
            this.setSize(450, 400);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        }

        public void setPreviewPanel(JComponent jComponent) {
            this.colorChooser.setPreviewPanel(jComponent);
        }

        public ColorSelectionModel getSelectionModel() {
            return this.colorChooser.getSelectionModel();
        }

        public void setColor(Color color) {
            this.colorChooser.setColor(color);
        }

        public Color getColor() {
            return this.colorChooser.getColor();
        }
    }

    private class ScenesComboBoxListener
    implements ActionListener {
        private ScenesComboBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = ShowTextEffectDialog.this.scenesComboBox.getSelectedIndex();
            if (n == 0) {
                ShowTextEffectDialog.this.textPositionPanel.removeImage();
            } else {
                ShowTextEffectDialog.this.textPositionPanel.loadImage(ShowTextEffectDialog.this.controller.getSceneImagePath(ShowTextEffectDialog.this.scenesComboBox.getSelectedItem().toString()));
            }
        }
    }
}

