/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs.effectdialogs;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.SingleEffectController;
import es.eucm.eadventure.editor.gui.editdialogs.effectdialogs.EffectDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class RandomEffectDialog
extends EffectDialog {
    private SingleEffectController positiveEffectController;
    private SingleEffectController negativeEffectController;
    private JTextField positiveEffectDescription;
    private JTextField negativeEffectDescription;
    private JSpinner probabilitySpinner;
    private static final long serialVersionUID = -5737206942292209020L;

    public RandomEffectDialog(int n, SingleEffectController singleEffectController, SingleEffectController singleEffectController2) {
        super(TC.get((String)"RandomEffect.Title"), false);
        this.positiveEffectController = singleEffectController;
        this.negativeEffectController = singleEffectController2;
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n, 1, 100, 1);
        this.probabilitySpinner = new JSpinner(spinnerNumberModel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"RandomEffect.Probability.Title"))));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 6, 4, 6);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        JLabel jLabel = new JLabel(TC.get((String)"RandomEffect.Probability.Description"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.probabilitySpinner, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        jPanel2.add(jPanel);
        jPanel2.add(Box.createVerticalStrut(2));
        jPanel2.add(this.createSingleEffectPanel(true));
        jPanel2.add(this.createSingleEffectPanel(false));
        this.add((Component)jPanel2, "Center");
        this.setResizable(false);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    private JPanel createSingleEffectPanel(boolean bl) {
        ImageIcon imageIcon = new ImageIcon("img/icons/deleteContent.png");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        if (bl) {
            jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"RandomEffect.Positive.Title"))));
        } else {
            jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"RandomEffect.Negative.Title"))));
        }
        JButton jButton = new JButton(imageIcon);
        jButton.addActionListener(new DeleteEffectListener(bl));
        jButton.setPreferredSize(new Dimension(20, 20));
        jButton.setToolTipText(TC.get((String)"RandomEffect.DeleteEffect"));
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jButton, gridBagConstraints);
        JTextField jTextField = new JTextField();
        jTextField.setEditable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jTextField, gridBagConstraints);
        JButton jButton2 = new JButton(TC.get((String)"RandomEffect.EditEffect"));
        jButton2.addActionListener(new EditEffectListener(bl));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jButton2, gridBagConstraints);
        if (bl) {
            this.positiveEffectDescription = jTextField;
            if (this.positiveEffectController.getEffectInfo() != null) {
                jTextField.setText(this.positiveEffectController.getEffectInfo());
            }
        } else {
            this.negativeEffectDescription = jTextField;
            if (this.negativeEffectController.getEffectInfo() != null) {
                jTextField.setText(this.negativeEffectController.getEffectInfo());
            }
        }
        return jPanel;
    }

    @Override
    protected void pressedOKButton() {
        this.properties = new HashMap();
        this.properties.put(6, this.probabilitySpinner.getValue().toString());
    }

    public void refresh() {
        if (this.positiveEffectController.getEffectInfo() != null) {
            this.positiveEffectDescription.setText(this.positiveEffectController.getEffectInfo());
        } else {
            this.positiveEffectDescription.setText("");
        }
        if (this.negativeEffectController.getEffectInfo() != null) {
            this.negativeEffectDescription.setText(this.negativeEffectController.getEffectInfo());
        } else {
            this.negativeEffectDescription.setText("");
        }
    }

    private class DeleteEffectListener
    implements ActionListener {
        private boolean positive = false;

        public DeleteEffectListener(boolean bl) {
            this.positive = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.positive) {
                RandomEffectDialog.this.positiveEffectController.deleteEffect();
            } else {
                RandomEffectDialog.this.negativeEffectController.deleteEffect();
            }
            RandomEffectDialog.this.refresh();
        }
    }

    private class EditEffectListener
    implements ActionListener {
        private boolean positive = false;

        public EditEffectListener(boolean bl) {
            this.positive = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.positive && RandomEffectDialog.this.positiveEffectController.editEffect() || !this.positive && RandomEffectDialog.this.negativeEffectController.editEffect()) {
                RandomEffectDialog.this.refresh();
            }
        }
    }
}

