/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs.effectdialogs;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.EffectsController;
import es.eucm.eadventure.editor.gui.displaydialogs.AudioDialog;
import es.eucm.eadventure.editor.gui.editdialogs.effectdialogs.EffectDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PlaySoundEffectDialog
extends EffectDialog {
    private static final long serialVersionUID = 1L;
    private EffectsController effectsController;
    private JCheckBox backgroundCheckBox;
    private JTextField pathTextField;
    private JButton viewButton;

    public PlaySoundEffectDialog(EffectsController effectsController, HashMap<Integer, Object> hashMap) {
        super(TC.get((String)"PlaySoundEffect.Title"), false);
        this.effectsController = effectsController;
        ImageIcon imageIcon = new ImageIcon("img/icons/deleteContent.png");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"PlaySoundEffect.Description"))));
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        this.backgroundCheckBox = new JCheckBox(TC.get((String)"PlaySoundEffect.BackgroundCheckBox"));
        jPanel.add((Component)this.backgroundCheckBox, gridBagConstraints);
        JButton jButton = new JButton(imageIcon);
        jButton.addActionListener(new DeleteContentButtonActionListener());
        jButton.setPreferredSize(new Dimension(20, 20));
        jButton.setToolTipText(TC.get((String)"Resources.DeleteAsset"));
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jButton, gridBagConstraints);
        this.pathTextField = new JTextField();
        this.pathTextField.setEditable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.pathTextField, gridBagConstraints);
        JButton jButton2 = new JButton(TC.get((String)"Resources.Select"));
        jButton2.addActionListener(new ExamineButtonActionListener());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jButton2, gridBagConstraints);
        this.viewButton = new JButton(TC.get((String)"Resources.PlayAsset"));
        this.viewButton.setEnabled(false);
        this.viewButton.addActionListener(new ViewButtonActionListener());
        gridBagConstraints.gridx = 3;
        jPanel.add((Component)this.viewButton, gridBagConstraints);
        this.add((Component)jPanel, "Center");
        if (hashMap != null) {
            if (hashMap.containsKey(1)) {
                this.pathTextField.setText((String)hashMap.get(1));
                this.viewButton.setEnabled(this.pathTextField.getText() != null);
            }
            if (hashMap.containsKey(5)) {
                this.backgroundCheckBox.setSelected(Boolean.parseBoolean((String)hashMap.get(5)));
            }
        }
        this.setResizable(false);
        this.setSize(400, 180);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    @Override
    protected void pressedOKButton() {
        this.properties = new HashMap();
        this.properties.put(1, this.pathTextField.getText());
        this.properties.put(5, String.valueOf(this.backgroundCheckBox.isSelected()));
    }

    private class ViewButtonActionListener
    implements ActionListener {
        private ViewButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new AudioDialog(PlaySoundEffectDialog.this.pathTextField.getText());
        }
    }

    private class ExamineButtonActionListener
    implements ActionListener {
        private ExamineButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = PlaySoundEffectDialog.this.effectsController.selectAsset(1);
            if (string != null) {
                PlaySoundEffectDialog.this.pathTextField.setText(string);
                PlaySoundEffectDialog.this.viewButton.setEnabled(true);
            }
        }
    }

    private class DeleteContentButtonActionListener
    implements ActionListener {
        private DeleteContentButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PlaySoundEffectDialog.this.pathTextField.setText(null);
            PlaySoundEffectDialog.this.viewButton.setEnabled(false);
        }
    }
}

