/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs.effectdialogs;

import es.eucm.eadventure.common.auxiliar.File;
import es.eucm.eadventure.common.data.animation.Animation;
import es.eucm.eadventure.common.data.animation.ImageLoaderFactory;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.EditorImageLoader;
import es.eucm.eadventure.editor.control.controllers.EffectsController;
import es.eucm.eadventure.editor.control.controllers.general.ResourcesDataControl;
import es.eucm.eadventure.editor.control.writer.AnimationWriter;
import es.eucm.eadventure.editor.gui.displaydialogs.AnimationDialog;
import es.eucm.eadventure.editor.gui.editdialogs.animationeditdialog.AnimationEditDialog;
import es.eucm.eadventure.editor.gui.editdialogs.effectdialogs.EffectDialog;
import es.eucm.eadventure.editor.gui.otherpanels.positionimagepanels.PointImagePanel;
import es.eucm.eadventure.editor.gui.otherpanels.positionpanel.PositionPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PlayAnimationEffectDialog
extends EffectDialog {
    private static final long serialVersionUID = 1L;
    private EffectsController effectsController;
    private JTextField pathTextField;
    private JButton viewButton;
    private JComboBox scenesComboBox;
    private PositionPanel pointPositionPanel;

    public PlayAnimationEffectDialog(EffectsController effectsController, HashMap<Integer, Object> hashMap) {
        super(TC.get((String)"PlayAnimationEffect.Title"), true);
        String[] stringArray;
        this.effectsController = effectsController;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(TC.get((String)"SceneLocation.NoSceneSelected"));
        for (String string : stringArray = this.controller.getIdentifierSummary().getSceneIds()) {
            arrayList.add(string);
        }
        stringArray = arrayList.toArray(new String[0]);
        ImageIcon imageIcon = new ImageIcon("img/icons/deleteContent.png");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"PlayAnimationEffect.Title")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JButton jButton = new JButton(imageIcon);
        jButton.addActionListener(new DeleteContentButtonActionListener());
        jButton.setPreferredSize(new Dimension(20, 20));
        jButton.setToolTipText(TC.get((String)"Resources.DeleteAsset"));
        jPanel.add((Component)jButton, gridBagConstraints);
        this.pathTextField = new JTextField();
        this.pathTextField.setEditable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.pathTextField, gridBagConstraints);
        JButton jButton2 = new JButton(TC.get((String)"Resources.Select"));
        jButton2.addActionListener(new ExamineButtonActionListener());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jButton2, gridBagConstraints);
        JButton jButton3 = new JButton(TC.get((String)"Resources.Create") + "/" + TC.get((String)"Resources.Edit"));
        jButton3.addActionListener(new EditButtonListener());
        gridBagConstraints.gridx = 3;
        jPanel.add(jButton3);
        this.viewButton = new JButton(TC.get((String)"Resources.ViewAsset"));
        this.viewButton.setEnabled(false);
        this.viewButton.addActionListener(new ViewButtonActionListener());
        gridBagConstraints.gridx = 4;
        jPanel.add((Component)this.viewButton, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"PlayAnimationEffect.Description"))));
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.scenesComboBox = new JComboBox<String>(stringArray);
        this.scenesComboBox.addActionListener(new ScenesComboBoxActionListener());
        jPanel2.add((Component)this.scenesComboBox, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        if (hashMap != null) {
            int n = 0;
            int n2 = 0;
            if (hashMap.containsKey(1)) {
                this.pathTextField.setText((String)hashMap.get(1));
                this.viewButton.setEnabled(this.pathTextField.getText() != null);
            }
            if (hashMap.containsKey(3)) {
                n = Integer.parseInt((String)hashMap.get(3));
            }
            if (hashMap.containsKey(4)) {
                n2 = Integer.parseInt((String)hashMap.get(4));
            }
            if (n > 5000) {
                n = 5000;
            }
            if (n < -2000) {
                n = -2000;
            }
            if (n2 > 5000) {
                n2 = 5000;
            }
            if (n2 < -2000) {
                n2 = -2000;
            }
            this.pointPositionPanel = new PositionPanel(new PointImagePanel(), n, n2);
        } else {
            this.pointPositionPanel = new PositionPanel(new PointImagePanel(), 400, 500);
        }
        jPanel2.add((Component)this.pointPositionPanel, gridBagConstraints);
        this.add((Component)jPanel2, "Center");
        this.setResizable(false);
        this.setSize(640, 480);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    @Override
    protected void pressedOKButton() {
        this.properties = new HashMap();
        this.properties.put(1, this.pathTextField.getText());
        this.properties.put(3, String.valueOf(this.pointPositionPanel.getPositionX()));
        this.properties.put(4, String.valueOf(this.pointPositionPanel.getPositionY()));
    }

    private class EditButtonListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = PlayAnimationEffectDialog.this.pathTextField.getText();
            if (string != null && string.toLowerCase().endsWith(".eaa") && !string.equals("assets/special/EmptyAnimation")) {
                new AnimationEditDialog(string, null);
            } else {
                File file;
                String string2 = null;
                String string3 = "anim" + new Random().nextInt(1000);
                if (string != null && !string.equals("")) {
                    file = string.split("/");
                    string3 = file[((String[])file).length - 1];
                    string2 = AssetsController.TempFileGenerator.generateTempFileOverwriteExisting(string3, "eaa");
                } else {
                    string3 = JOptionPane.showInputDialog(Controller.getInstance().peekWindow(), TC.get((String)"Animation.AskFilename"), TC.get((String)"Animation.AskFilenameTitle"), 3);
                    if (string3 != null && string3.length() > 0) {
                        string2 = AssetsController.TempFileGenerator.generateTempFileOverwriteExisting(string3, "eaa");
                    }
                }
                if (string2 != null) {
                    file = new File(string2);
                    file.create();
                    AnimationWriter.writeAnimation(string2, new Animation(string3, (ImageLoaderFactory)new EditorImageLoader()));
                    Animation animation = new Animation(string3, (ImageLoaderFactory)new EditorImageLoader());
                    if (string != null) {
                        ResourcesDataControl.framesFromImages(animation, string);
                        AnimationWriter.writeAnimation(string2, animation);
                    }
                    String string4 = new File(string2).getName();
                    PlayAnimationEffectDialog.this.pathTextField.setText("assets/animation/" + string4);
                    new AnimationEditDialog("assets/animation/" + string4, animation);
                }
            }
            PlayAnimationEffectDialog.this.viewButton.setEnabled(true);
        }
    }

    private class ScenesComboBoxActionListener
    implements ActionListener {
        private ScenesComboBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = PlayAnimationEffectDialog.this.scenesComboBox.getSelectedIndex();
            if (n == 0) {
                PlayAnimationEffectDialog.this.pointPositionPanel.removeImage();
            } else {
                PlayAnimationEffectDialog.this.pointPositionPanel.loadImage(PlayAnimationEffectDialog.this.controller.getSceneImagePath(PlayAnimationEffectDialog.this.scenesComboBox.getSelectedItem().toString()));
            }
        }
    }

    private class ViewButtonActionListener
    implements ActionListener {
        private ViewButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new AnimationDialog(PlayAnimationEffectDialog.this.pathTextField.getText());
        }
    }

    private class ExamineButtonActionListener
    implements ActionListener {
        private ExamineButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = PlayAnimationEffectDialog.this.effectsController.selectAsset(0);
            if (string != null) {
                PlayAnimationEffectDialog.this.pathTextField.setText(string);
                PlayAnimationEffectDialog.this.viewButton.setEnabled(true);
            }
        }
    }

    private class DeleteContentButtonActionListener
    implements ActionListener {
        private DeleteContentButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PlayAnimationEffectDialog.this.pathTextField.setText(null);
            PlayAnimationEffectDialog.this.viewButton.setEnabled(false);
        }
    }
}

