/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs.effectdialogs;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.gui.editdialogs.effectdialogs.EffectDialog;
import es.eucm.eadventure.editor.gui.otherpanels.positionimagepanels.ElementImagePanel;
import es.eucm.eadventure.editor.gui.otherpanels.positionpanel.PositionPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MoveNPCEffectDialog
extends EffectDialog {
    private static final long serialVersionUID = 1L;
    private JComboBox charactersComboBox;
    private JComboBox scenesComboBox;
    private PositionPanel npcPositionPanel;
    private ElementImagePanel elementPositionImagePanel;

    public MoveNPCEffectDialog(HashMap<Integer, Object> hashMap) {
        super(TC.get((String)"MoveNPCEffect.Title"), true);
        String[] stringArray = this.controller.getIdentifierSummary().getNPCIds();
        if (stringArray.length > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(TC.get((String)"SceneLocation.NoSceneSelected"));
            String[] stringArray2 = this.controller.getIdentifierSummary().getSceneIds();
            for (String string : stringArray2) {
                arrayList.add(string);
            }
            stringArray2 = arrayList.toArray(new String[0]);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"MoveNPCEffect.Description"))));
            gridBagConstraints.insets = new Insets(2, 4, 4, 4);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.charactersComboBox = new JComboBox<String>(stringArray);
            this.charactersComboBox.addActionListener(new CharactersComboBoxListener());
            jPanel.add((Component)this.charactersComboBox, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            jPanel.add((Component)new JLabel(TC.get((String)"SceneLocation.SceneListDescription")), gridBagConstraints);
            gridBagConstraints.gridy = 2;
            this.scenesComboBox = new JComboBox<String>(stringArray2);
            this.scenesComboBox.addActionListener(new ScenesComboBoxListener());
            jPanel.add((Component)this.scenesComboBox, gridBagConstraints);
            this.elementPositionImagePanel = new ElementImagePanel(null, null);
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            if (hashMap != null) {
                int n = 0;
                int n2 = 0;
                if (hashMap.containsKey(0)) {
                    this.charactersComboBox.setSelectedItem(hashMap.get(0));
                }
                if (hashMap.containsKey(3)) {
                    n = Integer.parseInt((String)hashMap.get(3));
                }
                if (hashMap.containsKey(4)) {
                    n2 = Integer.parseInt((String)hashMap.get(4));
                }
                if (n > 5000) {
                    n = 5000;
                }
                if (n < -2000) {
                    n = -2000;
                }
                if (n2 > 5000) {
                    n2 = 5000;
                }
                if (n2 < -2000) {
                    n2 = -2000;
                }
                this.npcPositionPanel = new PositionPanel(this.elementPositionImagePanel, n, n2);
            } else {
                this.npcPositionPanel = new PositionPanel(this.elementPositionImagePanel, 400, 500);
            }
            jPanel.add((Component)this.npcPositionPanel, gridBagConstraints);
            this.add((Component)jPanel, "Center");
            String string = this.controller.getElementImagePath(this.charactersComboBox.getSelectedItem().toString());
            this.elementPositionImagePanel.loadElement(string);
            this.elementPositionImagePanel.repaint();
            this.setResizable(false);
            this.setSize(640, 480);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
            this.setVisible(true);
        } else {
            this.controller.showErrorDialog(TC.get((String)"MoveNPCEffect.Title"), TC.get((String)"MoveNPCEffect.ErrorNoCharacters"));
        }
    }

    @Override
    protected void pressedOKButton() {
        this.properties = new HashMap();
        this.properties.put(0, this.charactersComboBox.getSelectedItem().toString());
        this.properties.put(3, String.valueOf(this.npcPositionPanel.getPositionX()));
        this.properties.put(4, String.valueOf(this.npcPositionPanel.getPositionY()));
    }

    private class ScenesComboBoxListener
    implements ActionListener {
        private ScenesComboBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = MoveNPCEffectDialog.this.scenesComboBox.getSelectedIndex();
            if (n == 0) {
                MoveNPCEffectDialog.this.npcPositionPanel.removeImage();
            } else {
                MoveNPCEffectDialog.this.npcPositionPanel.loadImage(MoveNPCEffectDialog.this.controller.getSceneImagePath(MoveNPCEffectDialog.this.scenesComboBox.getSelectedItem().toString()));
            }
        }
    }

    private class CharactersComboBoxListener
    implements ActionListener {
        private CharactersComboBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = MoveNPCEffectDialog.this.controller.getElementImagePath(MoveNPCEffectDialog.this.charactersComboBox.getSelectedItem().toString());
            MoveNPCEffectDialog.this.elementPositionImagePanel.loadElement(string);
            MoveNPCEffectDialog.this.elementPositionImagePanel.repaint();
        }
    }
}

