/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs.effectdialogs;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.gui.editdialogs.effectdialogs.EffectDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextPane;

public class HighlightItemEffectDialog
extends EffectDialog {
    private static final long serialVersionUID = 1L;
    public static final int HIGHLIGHT = 0;
    public static final int DEHIGHLIGHT = 1;
    private static final String[] dialogTitles = new String[]{"HighlightItemEffect.Title", "DeHighlightItemEffect.Title"};
    private static final String[] dialogDescriptions = new String[]{"HighlightItemEffect.Description", "DeHighlightItemEffect.Description"};
    private JComboBox itemsComboBox;
    private JComboBox typesComboBox;
    private JCheckBox animatedCheckBox;

    public HighlightItemEffectDialog(int n, HashMap<Integer, Object> hashMap) {
        super(TC.get((String)dialogTitles[n]), false);
        String[] stringArray = this.controller.getIdentifierSummary().getItemIds();
        if (stringArray.length > 0) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"HighlightItemEffect.ShortDescription"))));
            gridBagConstraints.insets = new Insets(2, 4, 4, 4);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 0;
            JTextPane jTextPane = new JTextPane();
            jTextPane.setEditable(false);
            jTextPane.setBackground(this.getBackground());
            jTextPane.setText(TC.get((String)dialogDescriptions[n]));
            jPanel.add((Component)jTextPane, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.itemsComboBox = new JComboBox<String>(this.controller.getIdentifierSummary().getItemIds());
            jPanel.add((Component)this.itemsComboBox, gridBagConstraints);
            ++gridBagConstraints.gridy;
            String[] stringArray2 = new String[]{TC.get((String)"HighlightItemEffect.None"), TC.get((String)"HighlightItemEffect.Blue"), TC.get((String)"HighlightItemEffect.Red"), TC.get((String)"HighlightItemEffect.Green"), TC.get((String)"HighlightItemEffect.Border")};
            this.typesComboBox = new JComboBox<String>(stringArray2);
            jPanel.add((Component)this.typesComboBox, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.animatedCheckBox = new JCheckBox(TC.get((String)"HighlightItemEffect.Animated"));
            jPanel.add((Component)this.animatedCheckBox, gridBagConstraints);
            this.add((Component)jPanel, "Center");
            if (hashMap != null) {
                if (hashMap.containsKey(0)) {
                    this.itemsComboBox.setSelectedItem(hashMap.get(0));
                }
                if (hashMap.containsKey(14)) {
                    this.typesComboBox.setSelectedIndex((Integer)hashMap.get(14));
                }
                if (hashMap.containsKey(15)) {
                    this.animatedCheckBox.setSelected((Boolean)hashMap.get(15));
                }
            }
            this.setResizable(false);
            this.pack();
            this.setSize(400, 300);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
            this.setVisible(true);
        } else {
            this.controller.showErrorDialog(this.getTitle(), TC.get((String)"HighlightItemEffect.ErrorNoItems"));
        }
    }

    @Override
    protected void pressedOKButton() {
        this.properties = new HashMap();
        this.properties.put(0, this.itemsComboBox.getSelectedItem().toString());
        this.properties.put(15, this.animatedCheckBox.isSelected());
        this.properties.put(14, this.typesComboBox.getSelectedIndex());
    }
}

