/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs.effectdialogs;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.VarFlagsController;
import es.eucm.eadventure.editor.gui.editdialogs.effectdialogs.EffectDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class FlagEffectDialog
extends EffectDialog {
    private static final long serialVersionUID = 1L;
    public static final int ACTIVATE = 0;
    public static final int DEACTIVATE = 1;
    private static final String[] dialogTitles = new String[]{"ActivateEffect.Title", "DeactivateEffect.Title"};
    private static final String[] dialogDescriptions = new String[]{"ActivateEffect.Description", "DeactivateEffect.Description"};
    private JComboBox flagsComboBox;

    public FlagEffectDialog(int n, HashMap<Integer, Object> hashMap) {
        super(TC.get((String)dialogTitles[n]), false);
        String[] stringArray = this.controller.getVarFlagSummary().getFlags();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)dialogDescriptions[n]))));
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        gridBagConstraints.weightx = 1.0;
        this.flagsComboBox = new JComboBox<String>(stringArray);
        this.flagsComboBox.setEditable(true);
        jPanel.add((Component)this.flagsComboBox, gridBagConstraints);
        this.add((Component)jPanel, "Center");
        if (hashMap != null && hashMap.containsKey(0)) {
            this.flagsComboBox.setSelectedItem(hashMap.get(0));
        }
        this.setResizable(false);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    @Override
    protected void pressedOKButton() {
        this.properties = new HashMap();
        VarFlagsController varFlagsController = new VarFlagsController(Controller.getInstance().getVarFlagSummary());
        String string = null;
        if (this.flagsComboBox.getSelectedItem() != null) {
            string = this.flagsComboBox.getSelectedItem().toString();
        }
        if (varFlagsController.existsFlag(string)) {
            this.properties.put(0, string);
        } else {
            String string2 = varFlagsController.addShortCutFlagVar(true, string);
            if (string2 != null) {
                this.properties.put(0, string2);
            } else {
                this.properties = null;
            }
        }
    }
}

