/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs.customizeguidialog;

import es.eucm.eadventure.common.data.adventure.DescriptorData;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.AdventureDataControl;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.displaydialogs.ImageDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class InventoryPanel
extends JScrollPane
implements Updateable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_SPACE = 0;
    private String[] arrowTypes;
    private AdventureDataControl adventureData;
    private JTextField[] arrowFields;
    private JButton[] viewButtons;
    private JComboBox whereInventory;

    public InventoryPanel(AdventureDataControl adventureDataControl) {
        super(20, 31);
        String[] stringArray;
        JPanel jPanel = new JPanel();
        this.adventureData = adventureDataControl;
        this.arrowTypes = DescriptorData.getArrowTypes();
        ImageIcon imageIcon = new ImageIcon("img/icons/deleteContent.png");
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setBackground(jPanel.getBackground());
        jTextPane.setText(TC.get((String)"Inventory.Information"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"GeneralText.Information")));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jTextPane, "Center");
        jPanel.add((Component)jPanel2, gridBagConstraints);
        int n = this.arrowTypes.length;
        this.arrowFields = new JTextField[n];
        this.viewButtons = new JButton[n];
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(2, 4, 2, 4);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weighty = 0.0;
        for (int i = 0; i < this.arrowTypes.length; ++i) {
            stringArray = new JPanel();
            stringArray.setLayout(new GridBagLayout());
            stringArray.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)("Inventory." + this.arrowTypes[i] + ".Description"))));
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.weightx = 0.0;
            gridBagConstraints3.weighty = 0.0;
            JButton jButton = new JButton(imageIcon);
            jButton.addActionListener(new DeleteContentButtonListener(i));
            jButton.setPreferredSize(new Dimension(20, 20));
            jButton.setToolTipText(TC.get((String)"Buttons.DeleteButton"));
            stringArray.add((Component)jButton, gridBagConstraints3);
            this.arrowFields[i] = new JTextField(0);
            if (adventureDataControl.getArrowPath(this.arrowTypes[i]) != null) {
                this.arrowFields[i].setText(adventureDataControl.getArrowPath(this.arrowTypes[i]));
            }
            this.arrowFields[i].setEditable(false);
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.weightx = 1.0;
            stringArray.add((Component)this.arrowFields[i], gridBagConstraints3);
            JButton jButton2 = new JButton(TC.get((String)"Inventory.Select"));
            jButton2.addActionListener(new ExamineButtonListener(i));
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.weightx = 0.0;
            stringArray.add((Component)jButton2, gridBagConstraints3);
            this.viewButtons[i] = new JButton(TC.get((String)"Inventory.Preview"));
            this.viewButtons[i].setEnabled(adventureDataControl.getArrowPath(this.arrowTypes[i]) != null);
            this.viewButtons[i].addActionListener(new ViewButtonListener(i));
            gridBagConstraints3.gridx = 3;
            stringArray.add((Component)this.viewButtons[i], gridBagConstraints3);
            stringArray.setToolTipText(TC.get((String)("Inventory." + this.arrowTypes[i] + ".Tip")));
            jPanel3.add((Component)stringArray, gridBagConstraints2);
            ++gridBagConstraints2.gridy;
        }
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Inventory.Position")));
        jPanel4.setLayout(new BorderLayout());
        stringArray = new String[]{TC.get((String)"Inventory.NoInventory"), TC.get((String)"Inventory.TopAndBottom"), TC.get((String)"Inventory.OnlyTop"), TC.get((String)"Inventory.OnlyBottom")};
        this.whereInventory = new JComboBox<String>(stringArray);
        this.whereInventory.setSelectedIndex(adventureDataControl.getInventoryPosition());
        this.whereInventory.addActionListener(new ComboBoxActionListener());
        jPanel4.add((Component)this.whereInventory, "Center");
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.setViewportView(jPanel);
    }

    @Override
    public boolean updateFields() {
        int n = this.arrowTypes.length;
        for (int i = 0; i < n; ++i) {
            if (this.adventureData.getArrowPath(this.arrowTypes[i]) != null) {
                this.arrowFields[i].setText(this.adventureData.getArrowPath(this.arrowTypes[i]));
                this.viewButtons[i].setEnabled(true);
                continue;
            }
            this.arrowFields[i].setText(null);
            this.viewButtons[i].setEnabled(false);
        }
        this.whereInventory.setSelectedIndex(this.adventureData.getInventoryPosition());
        return true;
    }

    private class ComboBoxActionListener
    implements ActionListener {
        private ComboBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InventoryPanel.this.adventureData.setInventoryPosition(InventoryPanel.this.whereInventory.getSelectedIndex());
        }
    }

    private class ViewButtonListener
    implements ActionListener {
        private int assetIndex;

        public ViewButtonListener(int n) {
            this.assetIndex = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = InventoryPanel.this.adventureData.getArrowPath(InventoryPanel.this.arrowTypes[this.assetIndex]);
            new ImageDialog(string);
        }
    }

    private class ExamineButtonListener
    implements ActionListener {
        private int assetIndex;

        public ExamineButtonListener(int n) {
            this.assetIndex = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InventoryPanel.this.adventureData.editArrowPath(InventoryPanel.this.arrowTypes[this.assetIndex]);
            if (InventoryPanel.this.adventureData.getArrowPath(InventoryPanel.this.arrowTypes[this.assetIndex]) != null) {
                InventoryPanel.this.arrowFields[this.assetIndex].setText(InventoryPanel.this.adventureData.getArrowPath(InventoryPanel.this.arrowTypes[this.assetIndex]));
                InventoryPanel.this.viewButtons[this.assetIndex].setEnabled(InventoryPanel.this.adventureData.getArrowPath(InventoryPanel.this.arrowTypes[this.assetIndex]) != null);
            }
        }
    }

    private class DeleteContentButtonListener
    implements ActionListener {
        private int assetIndex;

        public DeleteContentButtonListener(int n) {
            this.assetIndex = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InventoryPanel.this.adventureData.deleteArrow(InventoryPanel.this.arrowTypes[this.assetIndex]);
            InventoryPanel.this.arrowFields[this.assetIndex].setText(null);
            InventoryPanel.this.viewButtons[this.assetIndex].setEnabled(false);
        }
    }
}

