/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs.customizeguidialog;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.AdventureDataControl;
import es.eucm.eadventure.editor.gui.editdialogs.ToolManagableDialog;
import es.eucm.eadventure.editor.gui.editdialogs.customizeguidialog.ButtonsPanel;
import es.eucm.eadventure.editor.gui.editdialogs.customizeguidialog.CursorsPanel;
import es.eucm.eadventure.editor.gui.editdialogs.customizeguidialog.InventoryPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JTabbedPane;

public class CustomizeGUIDialog
extends ToolManagableDialog {
    private static final long serialVersionUID = 1L;
    private AdventureDataControl dataControl;
    private CursorsPanel cursorsPanel;
    private ButtonsPanel buttonsPanel;
    private InventoryPanel inventoryPanel;

    public CustomizeGUIDialog(AdventureDataControl adventureDataControl) {
        super(Controller.getInstance().peekWindow(), TC.get((String)"CustomizeGUI.Title"), false);
        this.dataControl = adventureDataControl;
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.cursorsPanel = new CursorsPanel(this.dataControl);
        this.buttonsPanel = new ButtonsPanel(this.dataControl);
        this.inventoryPanel = null;
        jTabbedPane.insertTab(TC.get((String)"Cursors.Title"), null, this.cursorsPanel, TC.get((String)"Cursors.Tip"), 0);
        jTabbedPane.insertTab(TC.get((String)"Buttons.Title"), null, this.buttonsPanel, TC.get((String)"Buttons.Tip"), 1);
        if (this.dataControl.getGUIType() == 1) {
            this.inventoryPanel = new InventoryPanel(this.dataControl);
            jTabbedPane.insertTab(TC.get((String)"Inventory.Title"), null, this.inventoryPanel, TC.get((String)"Inventory.Tip"), 2);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jTabbedPane, "Center");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((int)dimension.getWidth() / 2 - 350, (int)dimension.getHeight() / 2 - 250);
        this.setSize(700, 500);
        this.setVisible(true);
    }

    @Override
    public boolean updateFields() {
        return this.cursorsPanel.updateFields() && this.buttonsPanel.updateFields() && (this.inventoryPanel == null || this.inventoryPanel.updateFields());
    }
}

