/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs.customizeguidialog;

import es.eucm.eadventure.common.data.adventure.DescriptorData;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.AdventureDataControl;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.displaydialogs.ImageDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class CursorsPanel
extends JScrollPane
implements Updateable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_SPACE = 0;
    private String[] cursorTypes;
    private AdventureDataControl adventureData;
    private JTextField[] cursorFields;
    private JButton[] viewButtons;

    public CursorsPanel(AdventureDataControl adventureDataControl) {
        super(20, 31);
        JPanel jPanel = new JPanel();
        this.adventureData = adventureDataControl;
        this.cursorTypes = DescriptorData.getCursorTypes();
        ImageIcon imageIcon = new ImageIcon("img/icons/deleteContent.png");
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setBackground(jPanel.getBackground());
        jTextPane.setText(TC.get((String)"Cursors.Information"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"GeneralText.Information")));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jTextPane, "Center");
        jPanel.add((Component)jPanel2, gridBagConstraints);
        int n = this.cursorTypes.length;
        this.cursorFields = new JTextField[n];
        this.viewButtons = new JButton[n];
        for (int i = 0; i < n; ++i) {
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new GridBagLayout());
            jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)("Cursor." + this.cursorTypes[i] + ".Description"))));
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.weighty = 0.0;
            JButton jButton = new JButton(imageIcon);
            jButton.addActionListener(new DeleteContentButtonListener(i));
            jButton.setPreferredSize(new Dimension(20, 20));
            jButton.setToolTipText(TC.get((String)"Cursors.DeleteCursor"));
            jButton.setEnabled(adventureDataControl.isCursorTypeAllowed(i));
            jPanel3.add((Component)jButton, gridBagConstraints2);
            this.cursorFields[i] = new JTextField(0);
            if (adventureDataControl.isCursorTypeAllowed(i)) {
                if (adventureDataControl.getCursorPath(i) != null) {
                    this.cursorFields[i].setText(adventureDataControl.getCursorPath(i));
                }
            } else {
                this.cursorFields[i].setText(TC.get((String)"Cursors.TypeNotAllowed"));
            }
            this.cursorFields[i].setEditable(false);
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            jPanel3.add((Component)this.cursorFields[i], gridBagConstraints2);
            JButton jButton2 = new JButton(TC.get((String)"Cursors.Select"));
            jButton2.addActionListener(new ExamineButtonListener(i));
            jButton2.setEnabled(adventureDataControl.isCursorTypeAllowed(i));
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.weightx = 0.0;
            jPanel3.add((Component)jButton2, gridBagConstraints2);
            this.viewButtons[i] = new JButton(TC.get((String)"Cursors.Preview"));
            this.viewButtons[i].setEnabled(adventureDataControl.isCursorTypeAllowed(i) && adventureDataControl.getCursorPath(i) != null);
            this.viewButtons[i].addActionListener(new ViewButtonListener(i));
            gridBagConstraints2.gridx = 3;
            jPanel3.add((Component)this.viewButtons[i], gridBagConstraints2);
            ++gridBagConstraints.gridy;
            jPanel3.setToolTipText(TC.get((String)("Cursor." + this.cursorTypes[i] + ".Tip")));
            jPanel.add((Component)jPanel3, gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.setViewportView(jPanel);
    }

    @Override
    public boolean updateFields() {
        int n = this.cursorTypes.length;
        for (int i = 0; i < n; ++i) {
            if (this.adventureData.isCursorTypeAllowed(i)) {
                if (this.adventureData.getCursorPath(i) != null) {
                    this.cursorFields[i].setText(this.adventureData.getCursorPath(i));
                    this.viewButtons[i].setEnabled(true);
                    continue;
                }
                this.cursorFields[i].setText(null);
                this.viewButtons[i].setEnabled(false);
                continue;
            }
            this.cursorFields[i].setText(TC.get((String)"Cursors.TypeNotAllowed"));
            this.viewButtons[i].setEnabled(false);
        }
        return true;
    }

    private class ViewButtonListener
    implements ActionListener {
        private int assetIndex;

        public ViewButtonListener(int n) {
            this.assetIndex = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = CursorsPanel.this.adventureData.getCursorPath(this.assetIndex);
            new ImageDialog(string);
        }
    }

    private class ExamineButtonListener
    implements ActionListener {
        private int assetIndex;

        public ExamineButtonListener(int n) {
            this.assetIndex = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CursorsPanel.this.adventureData.editCursorPath(this.assetIndex);
            if (CursorsPanel.this.adventureData.isCursorTypeAllowed(this.assetIndex)) {
                CursorsPanel.this.cursorFields[this.assetIndex].setText(CursorsPanel.this.adventureData.getCursorPath(this.assetIndex));
                CursorsPanel.this.viewButtons[this.assetIndex].setEnabled(CursorsPanel.this.adventureData.getCursorPath(this.assetIndex) != null);
            }
        }
    }

    private class DeleteContentButtonListener
    implements ActionListener {
        private int assetIndex;

        public DeleteContentButtonListener(int n) {
            this.assetIndex = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (CursorsPanel.this.adventureData.isCursorTypeAllowed(this.assetIndex)) {
                CursorsPanel.this.adventureData.deleteCursor(this.assetIndex);
                CursorsPanel.this.cursorFields[this.assetIndex].setText(null);
                CursorsPanel.this.viewButtons[this.assetIndex].setEnabled(false);
            }
        }
    }
}

