/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs.customizeguidialog;

import es.eucm.eadventure.common.data.adventure.DescriptorData;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.AdventureDataControl;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.displaydialogs.ImageDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class ButtonsPanel
extends JScrollPane
implements Updateable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_SPACE = 0;
    private String[] buttonTypes;
    private String[] actionTypes;
    private AdventureDataControl adventureData;
    private JTextField[] buttonFields;
    private JButton[] viewButtons;

    public ButtonsPanel(AdventureDataControl adventureDataControl) {
        super(20, 31);
        JPanel jPanel = new JPanel();
        this.adventureData = adventureDataControl;
        this.actionTypes = DescriptorData.getActionTypes();
        this.buttonTypes = DescriptorData.getButtonTypes();
        ImageIcon imageIcon = new ImageIcon("img/icons/deleteContent.png");
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setBackground(jPanel.getBackground());
        jTextPane.setText(TC.get((String)"Buttons.Information"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"GeneralText.Information")));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jTextPane, "Center");
        jPanel.add((Component)jPanel2, gridBagConstraints);
        int n = this.buttonTypes.length * this.actionTypes.length;
        this.buttonFields = new JTextField[n];
        this.viewButtons = new JButton[n];
        for (int i = 0; i < this.actionTypes.length; ++i) {
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new GridBagLayout());
            jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)("Button." + this.actionTypes[i] + ".Description"))));
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(2, 4, 2, 4);
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weighty = 0.0;
            for (int j = 0; j < this.buttonTypes.length; ++j) {
                int n2 = i * this.buttonTypes.length + j;
                JPanel jPanel4 = new JPanel();
                jPanel4.setLayout(new GridBagLayout());
                jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)("Button." + this.actionTypes[i] + "." + this.buttonTypes[j] + ".Description"))));
                GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
                gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
                gridBagConstraints3.fill = 0;
                gridBagConstraints3.weightx = 0.0;
                gridBagConstraints3.weighty = 0.0;
                JButton jButton = new JButton(imageIcon);
                jButton.addActionListener(new DeleteContentButtonListener(n2, i, j));
                jButton.setPreferredSize(new Dimension(20, 20));
                jButton.setToolTipText(TC.get((String)"Buttons.DeleteButton"));
                jPanel4.add((Component)jButton, gridBagConstraints3);
                this.buttonFields[n2] = new JTextField(0);
                if (adventureDataControl.getButtonPath(this.actionTypes[i], this.buttonTypes[j]) != null) {
                    this.buttonFields[n2].setText(adventureDataControl.getButtonPath(this.actionTypes[i], this.buttonTypes[j]));
                }
                this.buttonFields[n2].setEditable(false);
                gridBagConstraints3.gridx = 1;
                gridBagConstraints3.fill = 2;
                gridBagConstraints3.weightx = 1.0;
                jPanel4.add((Component)this.buttonFields[n2], gridBagConstraints3);
                JButton jButton2 = new JButton(TC.get((String)"Buttons.Select"));
                jButton2.addActionListener(new ExamineButtonListener(n2, i, j));
                gridBagConstraints3.gridx = 2;
                gridBagConstraints3.fill = 0;
                gridBagConstraints3.weightx = 0.0;
                jPanel4.add((Component)jButton2, gridBagConstraints3);
                this.viewButtons[n2] = new JButton(TC.get((String)"Buttons.Preview"));
                this.viewButtons[n2].setEnabled(adventureDataControl.getButtonPath(this.actionTypes[i], this.buttonTypes[j]) != null);
                this.viewButtons[n2].addActionListener(new ViewButtonListener(n2, i, j));
                gridBagConstraints3.gridx = 3;
                jPanel4.add((Component)this.viewButtons[n2], gridBagConstraints3);
                jPanel4.setToolTipText(TC.get((String)("Button." + this.actionTypes[i] + "." + this.buttonTypes[j] + ".Tip")));
                jPanel3.add((Component)jPanel4, gridBagConstraints2);
                ++gridBagConstraints2.gridy;
            }
            ++gridBagConstraints.gridy;
            jPanel.add((Component)jPanel3, gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.setViewportView(jPanel);
    }

    @Override
    public boolean updateFields() {
        for (int i = 0; i < this.actionTypes.length; ++i) {
            for (int j = 0; j < this.buttonTypes.length; ++j) {
                int n = i * this.buttonTypes.length + j;
                if (this.adventureData.getButtonPath(this.actionTypes[i], this.buttonTypes[j]) != null) {
                    this.buttonFields[n].setText(this.adventureData.getButtonPath(this.actionTypes[i], this.buttonTypes[j]));
                    this.viewButtons[n].setEnabled(true);
                    continue;
                }
                this.buttonFields[n].setText(null);
                this.viewButtons[n].setEnabled(false);
            }
        }
        return true;
    }

    private class ViewButtonListener
    implements ActionListener {
        private int action;
        private int type;

        public ViewButtonListener(int n, int n2, int n3) {
            this.action = n2;
            this.type = n3;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = ButtonsPanel.this.adventureData.getButtonPath(ButtonsPanel.this.actionTypes[this.action], ButtonsPanel.this.buttonTypes[this.type]);
            new ImageDialog(string);
        }
    }

    private class ExamineButtonListener
    implements ActionListener {
        private int assetIndex;
        private int action;
        private int type;

        public ExamineButtonListener(int n, int n2, int n3) {
            this.assetIndex = n;
            this.action = n2;
            this.type = n3;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ButtonsPanel.this.adventureData.editButtonPath(ButtonsPanel.this.actionTypes[this.action], ButtonsPanel.this.buttonTypes[this.type]);
            if (ButtonsPanel.this.adventureData.getButtonPath(ButtonsPanel.this.actionTypes[this.action], ButtonsPanel.this.buttonTypes[this.type]) != null) {
                ButtonsPanel.this.buttonFields[this.assetIndex].setText(ButtonsPanel.this.adventureData.getButtonPath(ButtonsPanel.this.actionTypes[this.action], ButtonsPanel.this.buttonTypes[this.type]));
            }
            ButtonsPanel.this.viewButtons[this.assetIndex].setEnabled(ButtonsPanel.this.adventureData.getButtonPath(ButtonsPanel.this.actionTypes[this.action], ButtonsPanel.this.buttonTypes[this.type]) != null);
        }
    }

    private class DeleteContentButtonListener
    implements ActionListener {
        private int assetIndex;
        private int action;
        private int type;

        public DeleteContentButtonListener(int n, int n2, int n3) {
            this.action = n2;
            this.type = n3;
            this.assetIndex = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ButtonsPanel.this.adventureData.deleteButton(ButtonsPanel.this.actionTypes[this.action], ButtonsPanel.this.buttonTypes[this.type]);
            ButtonsPanel.this.buttonFields[this.assetIndex].setText(null);
            ButtonsPanel.this.viewButtons[this.assetIndex].setEnabled(false);
        }
    }
}

