/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs.animationeditdialog;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.animation.TransitionDataControl;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TransitionConfigPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private TransitionDataControl transition;
    private JList list;
    private JComboBox comboBox;
    private JSpinner spinner;

    public TransitionConfigPanel(TransitionDataControl transitionDataControl, JList jList) {
        this.transition = transitionDataControl;
        this.list = jList;
        this.setLayout(new GridLayout(1, 1));
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(TC.get((String)"Animation.Duration") + ": "));
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(transitionDataControl.getTime(), 0.0, 10000.0, 100.0);
        this.spinner = new JSpinner(spinnerNumberModel);
        this.spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TransitionConfigPanel.this.modifyTransitionTime();
            }
        });
        jPanel.add(this.spinner);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        this.comboBox = new JComboBox();
        this.comboBox.addItem("NONE");
        this.comboBox.addItem("FADEIN");
        this.comboBox.addItem("HORIZONTAL");
        this.comboBox.addItem("VERTICAL");
        switch (transitionDataControl.getType()) {
            case 0: {
                this.comboBox.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.comboBox.setSelectedIndex(1);
                break;
            }
            case 3: {
                this.comboBox.setSelectedIndex(2);
                break;
            }
            case 2: {
                this.comboBox.setSelectedIndex(3);
            }
        }
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransitionConfigPanel.this.modifyTransition();
            }
        });
        jPanel2.add(this.comboBox);
        this.add(jPanel2);
    }

    protected void modifyTransitionTime() {
        this.transition.setTime(((Double)this.spinner.getModel().getValue()).longValue());
        this.list.updateUI();
    }

    protected void modifyTransition() {
        switch (this.comboBox.getSelectedIndex()) {
            case 0: {
                this.transition.setType(0);
                break;
            }
            case 1: {
                this.transition.setType(1);
                break;
            }
            case 2: {
                this.transition.setType(3);
                break;
            }
            case 3: {
                this.transition.setType(2);
            }
        }
        this.list.updateUI();
    }
}

