/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs.animationeditdialog;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.animation.FrameDataControl;
import es.eucm.eadventure.editor.gui.displaydialogs.EditImageDialog;
import es.eucm.eadventure.editor.gui.editdialogs.animationeditdialog.AnimationEditDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FrameConfigPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private FrameDataControl frame;
    private JList list;
    private JSpinner frameTimeSpinner;
    private JTextField imageUriTextField;
    private JTextField soundUriTextField;
    private AnimationEditDialog aed;
    private JCheckBox checkbox;

    public FrameConfigPanel(FrameDataControl frameDataControl, JList jList, AnimationEditDialog animationEditDialog) {
        this.frame = frameDataControl;
        this.list = jList;
        this.aed = animationEditDialog;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(TC.get((String)"Animation.Duration") + ": "));
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(frameDataControl.getTime(), 0.0, 10000.0, 100.0);
        this.frameTimeSpinner = new JSpinner(spinnerNumberModel);
        this.frameTimeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FrameConfigPanel.this.modifyFrame();
            }
        });
        jPanel.add(this.frameTimeSpinner);
        if (animationEditDialog.getAnimationDataControl().isSlides()) {
            this.checkbox = new JCheckBox(TC.get((String)"Animation.WaitForClick"));
            if (frameDataControl.isWaitForClick()) {
                this.checkbox.setSelected(true);
                this.frameTimeSpinner.setEnabled(false);
            } else {
                this.checkbox.setSelected(false);
            }
            this.checkbox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    FrameConfigPanel.this.changeWaitForClick();
                }
            });
            jPanel.add(this.checkbox);
        }
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel2 = this.createImageAssetPanel(frameDataControl);
        this.add((Component)jPanel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.createSoundAssetPanel(frameDataControl), gridBagConstraints);
    }

    private JPanel createImageAssetPanel(final FrameDataControl frameDataControl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Animation.Image")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.imageUriTextField = new JTextField(30);
        this.imageUriTextField.setText(frameDataControl.getImageURI());
        this.imageUriTextField.setEditable(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.imageUriTextField, gridBagConstraints);
        final JButton jButton = new JButton(TC.get((String)"Resources.Edit"));
        JButton jButton2 = new JButton(TC.get((String)"Resources.Select"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameConfigPanel.this.selectImage();
                if (frameDataControl.getImageURI() != null && !frameDataControl.getImageURI().equals("")) {
                    jButton.setEnabled(true);
                } else {
                    jButton.setEnabled(false);
                }
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jButton2, gridBagConstraints);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new EditImageDialog(frameDataControl);
            }
        });
        if (frameDataControl.getImageURI() != null && !frameDataControl.getImageURI().equals("")) {
            jButton.setEnabled(true);
        } else {
            jButton.setEnabled(false);
        }
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jButton, gridBagConstraints);
        return jPanel;
    }

    private JPanel createSoundAssetPanel(FrameDataControl frameDataControl) {
        ImageIcon imageIcon = new ImageIcon("img/icons/deleteContent.png");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Animation.Sound")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JButton jButton = new JButton(imageIcon);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameConfigPanel.this.deleteSound();
            }
        });
        jButton.setPreferredSize(new Dimension(20, 20));
        jButton.setToolTipText(TC.get((String)"Resources.DeleteAsset"));
        jPanel.add((Component)jButton, gridBagConstraints);
        this.soundUriTextField = new JTextField(30);
        this.soundUriTextField.setText(frameDataControl.getSoundUri());
        this.soundUriTextField.setEditable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.soundUriTextField, gridBagConstraints);
        JButton jButton2 = new JButton(TC.get((String)"Resources.Select"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameConfigPanel.this.selectSound();
            }
        });
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jButton2, gridBagConstraints);
        return jPanel;
    }

    protected void changeWaitForClick() {
        this.frame.setWaitForClick(this.checkbox.isSelected());
        if (this.checkbox.isSelected()) {
            this.frameTimeSpinner.setEnabled(false);
        } else {
            this.frameTimeSpinner.setEnabled(true);
        }
    }

    protected void selectImage() {
        String string = this.aed.getAnimationDataControl().getImagePath(this.aed);
        if (string != null) {
            this.frame.setImageURI(string);
            this.list.updateUI();
            this.imageUriTextField.setText(string);
            this.list.updateUI();
        }
    }

    protected void selectSound() {
        String string = this.aed.getAnimationDataControl().getSoundPath(this.aed);
        if (string != null) {
            this.frame.setSoundURI(string);
            this.list.updateUI();
            this.soundUriTextField.setText(string);
            this.list.updateUI();
        }
    }

    protected void deleteSound() {
        this.frame.setSoundURI("");
        this.list.updateUI();
        this.soundUriTextField.setText("");
        this.list.updateUI();
    }

    protected void modifyFrame() {
        this.frame.setTime(((Double)this.frameTimeSpinner.getModel().getValue()).longValue());
        this.list.updateUI();
    }
}

