/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs.animationeditdialog;

import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.animation.FrameDataControl;
import es.eucm.eadventure.editor.control.controllers.animation.TransitionDataControl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class AnimationListRenderer
implements ListCellRenderer {
    private static final long serialVersionUID = 1L;
    private HashMap<String, Image> chache = new HashMap();
    private ImageIcon soundIcon = new ImageIcon("img/icons/hasSound.png");
    private ImageIcon noImage = new ImageIcon("img/icons/noImageFrame.png");
    private ImageIcon[] transitions = new ImageIcon[5];

    public AnimationListRenderer() {
        this.transitions[0] = new ImageIcon("img/icons/transitionNone.png");
        this.transitions[1] = new ImageIcon("img/icons/transitionFadein.png");
        this.transitions[3] = new ImageIcon("img/icons/transitionHorizontal.png");
        this.transitions[2] = new ImageIcon("img/icons/transitionVertical.png");
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        if (bl) {
            jPanel.setBackground(jList.getSelectionBackground());
            jPanel.setForeground(jList.getSelectionForeground());
        } else {
            jPanel.setBackground(jList.getBackground());
            jPanel.setForeground(jList.getForeground());
        }
        if (object instanceof FrameDataControl) {
            jPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 3));
            FrameDataControl frameDataControl = (FrameDataControl)object;
            JLabel jLabel = new JLabel();
            jLabel.setIcon(this.getImage(frameDataControl.getImageURI(), frameDataControl.getSoundUri()));
            jPanel.add((Component)jLabel, "Center");
            jLabel = new JLabel("" + frameDataControl.getTime());
            jLabel.setHorizontalAlignment(0);
            jPanel.add((Component)jLabel, "South");
        } else if (object instanceof TransitionDataControl) {
            JLabel jLabel = new JLabel();
            jLabel.setHorizontalAlignment(0);
            jLabel.setVerticalAlignment(0);
            TransitionDataControl transitionDataControl = (TransitionDataControl)object;
            ImageIcon imageIcon = this.transitions[transitionDataControl.getType()];
            jLabel.setIcon(imageIcon);
            jPanel.add((Component)jLabel, "Center");
            jLabel = new JLabel("" + transitionDataControl.getTime());
            jLabel.setHorizontalAlignment(0);
            jPanel.add((Component)jLabel, "South");
        }
        return jPanel;
    }

    private ImageIcon getImage(String string, String string2) {
        Image image = null;
        if (string != null && string.length() > 0) {
            Graphics graphics;
            Image image2;
            image = this.chache.get(string);
            if (image == null) {
                image2 = AssetsController.getImage(string);
                if (image2 != null && (image2 = image2.getScaledInstance(100, -1, 4)).getHeight(null) > 100) {
                    image2 = image2.getScaledInstance(-1, 100, 4);
                }
                image = new BufferedImage(image2.getWidth(null), image2.getHeight(null), 1);
                graphics = image.getGraphics();
                graphics.setColor(Color.WHITE);
                graphics.fillRect(0, 0, image.getWidth(null), image.getHeight(null));
                graphics.drawImage(image2, 0, 0, null);
                this.chache.put(string, image);
                image2 = null;
            }
            if (string2 != null && !string2.equals("") && image != null) {
                image2 = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
                graphics = image2.getGraphics();
                graphics.setColor(Color.WHITE);
                graphics.fillRect(0, 0, image.getWidth(null), image.getHeight(null));
                graphics.drawImage(image, 0, 0, null);
                graphics.drawImage(this.soundIcon.getImage(), 0, 0, null);
                image = image2;
            }
        }
        ImageIcon imageIcon = image == null ? this.noImage : new ImageIcon(image);
        return imageIcon;
    }
}

