/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs.animationeditdialog;

import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.data.animation.Animation;
import es.eucm.eadventure.common.data.animation.Frame;
import es.eucm.eadventure.common.data.animation.ImageLoaderFactory;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.common.loader.InputStreamCreator;
import es.eucm.eadventure.common.loader.Loader;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.EditorImageLoader;
import es.eucm.eadventure.editor.control.controllers.animation.AnimationDataControl;
import es.eucm.eadventure.editor.control.controllers.animation.FrameDataControl;
import es.eucm.eadventure.editor.control.tools.listeners.DocumentationChangeListener;
import es.eucm.eadventure.editor.control.writer.AnimationWriter;
import es.eucm.eadventure.editor.gui.displaydialogs.AnimationDialog;
import es.eucm.eadventure.editor.gui.editdialogs.HelpDialog;
import es.eucm.eadventure.editor.gui.editdialogs.ToolManagableDialog;
import es.eucm.eadventure.editor.gui.editdialogs.animationeditdialog.AnimationListRenderer;
import es.eucm.eadventure.editor.gui.editdialogs.animationeditdialog.FrameConfigPanel;
import es.eucm.eadventure.editor.gui.editdialogs.animationeditdialog.TransitionConfigPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AnimationEditDialog
extends ToolManagableDialog {
    private static final long serialVersionUID = 1L;
    private JList frameList;
    private JPanel frameListPanel;
    private JPanel descriptionPanel;
    private JPanel configurationPanel;
    private JButton moveLeftButton;
    private JButton moveRightButton;
    private JButton deleteButton;
    private JButton addButton;
    private JButton duplicateButton;
    private JCheckBox useTransitions;
    private JCheckBox slides;
    private JTextField documentationTextField;
    private AnimationDataControl animationDataControl;
    private FrameConfigPanel frameConfigPanel;

    public AnimationEditDialog() {
        super(Controller.getInstance().peekWindow(), "", true);
        this.animationDataControl = new AnimationDataControl(new Animation("id", new Frame((ImageLoaderFactory)new EditorImageLoader()), (ImageLoaderFactory)new EditorImageLoader()));
        this.buildInterface();
    }

    public AnimationEditDialog(String string, Animation animation) {
        super(Controller.getInstance().peekWindow(), TC.get((String)"Animation.DialogTitle", (String)string), true);
        this.animationDataControl = animation == null ? new AnimationDataControl(Loader.loadAnimation((InputStreamCreator)AssetsController.getInputStreamCreator(), (String)string, (ImageLoaderFactory)new EditorImageLoader())) : new AnimationDataControl(animation);
        this.animationDataControl.setFilename(string);
        this.buildInterface();
    }

    private void buildInterface() {
        this.setLayout(new GridBagLayout());
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setResizable(false);
        this.setTitle(TC.get((String)"Animation.DialogTitle", (String)this.animationDataControl.getFilename()));
        this.createDescriptionPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.descriptionPanel, gridBagConstraints);
        AnimationListModel animationListModel = new AnimationListModel(this.animationDataControl);
        this.frameList = new JList(animationListModel);
        this.frameList.setSelectionMode(0);
        this.frameList.getSelectionModel().addListSelectionListener(new AnimationListSelectionListener(this));
        this.frameList.setLayoutOrientation(2);
        this.frameList.setCellRenderer(new AnimationListRenderer());
        this.frameList.setVisibleRowCount(1);
        JScrollPane jScrollPane = new JScrollPane(this.frameList);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        jScrollPane.setPreferredSize(new Dimension(520, 160));
        this.frameListPanel = new JPanel();
        this.frameListPanel.add((Component)jScrollPane, "Center");
        this.frameListPanel.add((Component)this.createButtonPanel(), "South");
        this.frameListPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Animation.Timeline")));
        this.frameListPanel.setMinimumSize(new Dimension(600, 240));
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.frameListPanel, gridBagConstraints);
        this.configurationPanel = new JPanel();
        this.configurationPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Animation.Details")));
        this.configurationPanel.setMinimumSize(new Dimension(600, 200));
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.7;
        this.add((Component)this.configurationPanel, gridBagConstraints);
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(TC.get((String)"Animation.Preview"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new AnimationDialog((Animation)AnimationEditDialog.this.animationDataControl.getContent());
            }
        });
        jPanel.add(jButton);
        jPanel.setMinimumSize(new Dimension(600, 50));
        JButton jButton2 = new JButton(TC.get((String)"GeneralText.OK"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnimationEditDialog.this.saveAndClose();
            }
        });
        jPanel.add(jButton2);
        JButton jButton3 = new JButton(TC.get((String)"GeneralText.Cancel"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnimationEditDialog.this.setVisible(false);
            }
        });
        jPanel.add(jButton3);
        JButton jButton4 = new JButton(new ImageIcon("img/icons/information.png"));
        jButton4.setContentAreaFilled(false);
        jButton4.setMargin(new Insets(0, 0, 0, 0));
        jButton4.setFocusable(false);
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new HelpDialog("general/Animation_Editor.html");
            }
        });
        jPanel.add(jButton4);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 0.3;
        this.add((Component)jPanel, gridBagConstraints);
        this.setSize(600, 650);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    private void createDescriptionPanel() {
        this.descriptionPanel = new JPanel();
        this.descriptionPanel.setLayout(new GridLayout(2, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)new JLabel(TC.get((String)"Animation.Documentation")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.documentationTextField = new JTextField(this.animationDataControl.getDocumentation());
        this.documentationTextField.getDocument().addDocumentListener(new DocumentationChangeListener(this.documentationTextField, (Documented)this.animationDataControl.getContent()));
        jPanel.add((Component)this.documentationTextField, gridBagConstraints);
        this.descriptionPanel.add(jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        this.useTransitions = new JCheckBox(TC.get((String)"Animation.UseTransitions"));
        if (this.animationDataControl.isUseTransitions()) {
            this.useTransitions.setSelected(true);
        } else {
            this.useTransitions.setSelected(false);
        }
        this.useTransitions.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                AnimationEditDialog.this.changeUseTransitions();
            }
        });
        jPanel.add((Component)this.useTransitions, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        this.slides = new JCheckBox(TC.get((String)"Animation.Slides"));
        if (this.animationDataControl.isSlides()) {
            this.slides.setSelected(true);
        } else {
            this.slides.setSelected(false);
        }
        this.slides.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                AnimationEditDialog.this.changeSlides();
            }
        });
        jPanel.add((Component)this.slides, gridBagConstraints);
        this.descriptionPanel.add(jPanel);
        this.descriptionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Animation.GeneralInfo")));
        this.descriptionPanel.setMinimumSize(new Dimension(600, 100));
    }

    protected void changeSlides() {
        if (this.slides.isSelected() != this.animationDataControl.isSlides()) {
            this.animationDataControl.setSlides(this.slides.isSelected());
            this.frameList.getSelectionModel().clearSelection();
            this.configurationPanel.removeAll();
            this.validate();
            this.repaint();
        }
    }

    protected void changeUseTransitions() {
        if (this.useTransitions.isSelected() != this.animationDataControl.isUseTransitions()) {
            this.animationDataControl.setUseTransitions(this.useTransitions.isSelected());
            this.frameList.getSelectionModel().clearSelection();
            this.frameList.updateUI();
            this.configurationPanel.removeAll();
            this.validate();
            this.repaint();
        }
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        this.moveLeftButton = new JButton(new ImageIcon("img/icons/moveNodeLeft.png"));
        this.moveLeftButton.setContentAreaFilled(false);
        this.moveLeftButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveLeftButton.setBorder(BorderFactory.createEmptyBorder());
        this.moveLeftButton.setToolTipText(TC.get((String)"Animation.MoveFrameLeft"));
        this.moveLeftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnimationEditDialog.this.moveFrameLeft();
            }
        });
        this.moveLeftButton.setEnabled(false);
        jPanel.add(this.moveLeftButton);
        this.deleteButton = new JButton(new ImageIcon("img/icons/deleteNode.png"));
        this.deleteButton.setContentAreaFilled(false);
        this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteButton.setBorder(BorderFactory.createEmptyBorder());
        this.deleteButton.setToolTipText(TC.get((String)"Animation.DeleteFrame"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnimationEditDialog.this.deleteFrame();
            }
        });
        this.deleteButton.setEnabled(false);
        jPanel.add(this.deleteButton);
        this.addButton = new JButton(new ImageIcon("img/icons/addNode.png"));
        this.addButton.setContentAreaFilled(false);
        this.addButton.setMargin(new Insets(0, 0, 0, 0));
        this.addButton.setBorder(BorderFactory.createEmptyBorder());
        this.addButton.setToolTipText(TC.get((String)"Animation.AddFrame"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnimationEditDialog.this.addFrame();
            }
        });
        jPanel.add(this.addButton);
        this.duplicateButton = new JButton(new ImageIcon("img/icons/duplicateNode.png"));
        this.duplicateButton.setContentAreaFilled(false);
        this.duplicateButton.setMargin(new Insets(0, 0, 0, 0));
        this.duplicateButton.setBorder(BorderFactory.createEmptyBorder());
        this.duplicateButton.setToolTipText(TC.get((String)"Animation.DuplicateFrame"));
        this.duplicateButton.setEnabled(false);
        this.duplicateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnimationEditDialog.this.duplicateFrame();
            }
        });
        jPanel.add(this.duplicateButton);
        this.moveRightButton = new JButton(new ImageIcon("img/icons/moveNodeRight.png"));
        this.moveRightButton.setContentAreaFilled(false);
        this.moveRightButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveRightButton.setBorder(BorderFactory.createEmptyBorder());
        this.moveRightButton.setToolTipText(TC.get((String)"Animation.MoveFrameRight"));
        this.moveRightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnimationEditDialog.this.moveFrameRight();
            }
        });
        this.moveRightButton.setEnabled(false);
        jPanel.add(this.moveRightButton);
        return jPanel;
    }

    protected void saveAndClose() {
        if (this.animationDataControl.getFilename() != null) {
            AnimationWriter.writeAnimation(this.animationDataControl.getFilename(), (Animation)this.animationDataControl.getContent());
        }
        this.setVisible(false);
    }

    protected void addFrame() {
        Frame frame = new Frame(this.animationDataControl.getImageLoaderFactory());
        int n = this.frameList.getSelectedIndex() / 2;
        if (!this.animationDataControl.isUseTransitions()) {
            n = this.frameList.getSelectedIndex();
        }
        if (this.frameList.getSelectedIndex() == -1) {
            n = this.animationDataControl.getFrameCount() - 1;
        }
        this.animationDataControl.addFrame(n, frame);
        this.frameList.updateUI();
        int n2 = this.animationDataControl.indexOfFrame(frame);
        this.frameList.setSelectedIndex(n2);
    }

    protected void duplicateFrame() {
        Frame frame = new Frame(this.animationDataControl.getImageLoaderFactory());
        int n = this.frameList.getSelectedIndex() / 2;
        if (!this.animationDataControl.isUseTransitions()) {
            n = this.frameList.getSelectedIndex();
        }
        if (this.frameList.getSelectedIndex() == -1) {
            n = this.animationDataControl.getFrameCount() - 1;
        }
        FrameDataControl frameDataControl = this.animationDataControl.getFrameDataControl(n);
        frame.setUri(frameDataControl.getImageURI());
        frame.setSoundUri(frameDataControl.getSoundUri());
        frame.setTime(frameDataControl.getTime());
        this.animationDataControl.duplicateFrame(n, frame);
        this.frameList.updateUI();
        int n2 = this.animationDataControl.indexOfFrame(frame);
        this.frameList.setSelectedIndex(n2);
    }

    protected void deleteFrame() {
        if (this.frameList.getSelectedValue() instanceof FrameDataControl) {
            this.animationDataControl.deleteFrame((FrameDataControl)this.frameList.getSelectedValue());
            this.frameList.getSelectionModel().clearSelection();
            this.configurationPanel.removeAll();
            this.validate();
            this.repaint();
        }
    }

    protected void moveFrameLeft() {
        FrameDataControl frameDataControl = (FrameDataControl)this.frameList.getSelectedValue();
        this.animationDataControl.moveFrameLeft(frameDataControl);
        this.frameList.setSelectedValue(frameDataControl, true);
        this.frameList.updateUI();
    }

    protected void moveFrameRight() {
        FrameDataControl frameDataControl = (FrameDataControl)this.frameList.getSelectedValue();
        this.animationDataControl.moveFrameRight(frameDataControl);
        this.frameList.setSelectedValue(frameDataControl, true);
        this.frameList.updateUI();
    }

    public void selectionChanged(int n) {
        if (this.animationDataControl.isUseTransitions()) {
            if (n < 0 || n >= this.animationDataControl.getFrameCount() * 2 + 1) {
                this.selectedNothing();
                return;
            }
            if (n % 2 == 0) {
                this.selectedFrame(n / 2);
            } else {
                this.selectedTransition((n - 1) / 2 + 1);
            }
        } else {
            if (n < 0 || n >= this.animationDataControl.getFrameCount()) {
                this.selectedNothing();
                return;
            }
            this.selectedFrame(n);
        }
    }

    public void selectedFrame(int n) {
        if (n < this.animationDataControl.getFrameCount() - 1) {
            this.moveRightButton.setEnabled(true);
        } else {
            this.moveRightButton.setEnabled(false);
        }
        if (n > 0) {
            this.moveLeftButton.setEnabled(true);
        } else {
            this.moveLeftButton.setEnabled(false);
        }
        this.deleteButton.setEnabled(true);
        this.duplicateButton.setEnabled(true);
        this.configurationPanel.removeAll();
        this.frameConfigPanel = new FrameConfigPanel(this.animationDataControl.getFrameDataControl(n), this.frameList, this);
        this.configurationPanel.add(this.frameConfigPanel);
        this.validate();
        this.repaint();
    }

    public void selectedNothing() {
        this.moveRightButton.setEnabled(false);
        this.moveLeftButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.duplicateButton.setEnabled(false);
        this.configurationPanel.removeAll();
        this.validate();
        this.repaint();
    }

    public void selectedTransition(int n) {
        this.moveRightButton.setEnabled(false);
        this.moveLeftButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.duplicateButton.setEnabled(false);
        this.configurationPanel.removeAll();
        this.configurationPanel.add(new TransitionConfigPanel(this.animationDataControl.getTransitionDataControls().get(n), this.frameList));
        this.validate();
        this.repaint();
    }

    public AnimationDataControl getAnimationDataControl() {
        return this.animationDataControl;
    }

    @Override
    public boolean updateFields() {
        if (this.descriptionPanel != null) {
            this.documentationTextField.setText(this.animationDataControl.getDocumentation());
            this.useTransitions.setSelected(this.animationDataControl.isUseTransitions());
            this.slides.setSelected(this.animationDataControl.isSlides());
            this.descriptionPanel.updateUI();
        }
        if (this.configurationPanel != null) {
            this.selectionChanged(this.frameList.getSelectedIndex());
        }
        if (this.frameListPanel != null) {
            this.frameListPanel.updateUI();
            this.frameList.updateUI();
        }
        this.validate();
        this.repaint();
        return true;
    }

    private class AnimationListSelectionListener
    implements ListSelectionListener {
        private AnimationEditDialog aed;

        public AnimationListSelectionListener(AnimationEditDialog animationEditDialog2) {
            this.aed = animationEditDialog2;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (!listSelectionModel.isSelectionEmpty()) {
                int n = listSelectionModel.getMinSelectionIndex();
                this.aed.selectionChanged(n);
            }
        }
    }

    private class AnimationListModel
    extends AbstractListModel {
        private static final long serialVersionUID = -2832912217451105062L;
        private AnimationDataControl animation;

        public AnimationListModel(AnimationDataControl animationDataControl) {
            this.animation = animationDataControl;
        }

        @Override
        public Object getElementAt(int n) {
            if (this.animation.isUseTransitions()) {
                if (n % 2 == 0) {
                    return this.animation.getFrameDataControl(n / 2);
                }
                return this.animation.getTransitionDataControls().get((n - 1) / 2 + 1);
            }
            return this.animation.getFrameDataControl(n);
        }

        @Override
        public int getSize() {
            if (this.animation.isUseTransitions()) {
                return this.animation.getFrameCount() * 2 - 1;
            }
            return this.animation.getFrameCount();
        }
    }
}

