/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.VarFlagsController;
import es.eucm.eadventure.editor.gui.editdialogs.HelpDialog;
import es.eucm.eadventure.editor.gui.elementpanels.condition.ConditionsPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class VarsFlagsDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final String flagsHelpPath = "flagsVars/flags.html";
    private static final String varsHelpPath = "flagsVars/vars.html";
    private VarFlagsController varFlagsController;
    private JTable flagsTable;
    private JTable varsTable;

    public VarsFlagsDialog(VarFlagsController varFlagsController) {
        super(Controller.getInstance().peekWindow(), TC.get((String)"Ids.Title"), Dialog.ModalityType.TOOLKIT_MODAL);
        Controller.getInstance().pushWindow(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Controller.getInstance().popWindow();
            }
        });
        this.varFlagsController = varFlagsController;
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Flags.Title")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.flagsTable = new JTable(new FlagsTableModel());
        this.flagsTable.getColumnModel().getColumn(1).setMaxWidth(60);
        this.flagsTable.setSelectionMode(0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new JScrollPane(this.flagsTable, 22, 31), gridBagConstraints);
        JButton jButton = new JButton(TC.get((String)"Flags.AddFlag"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (VarsFlagsDialog.this.varFlagsController.addVarFlag(true)) {
                    VarsFlagsDialog.this.flagsTable.updateUI();
                }
            }
        });
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jButton, gridBagConstraints);
        JButton jButton2 = new JButton(TC.get((String)"Flags.DeleteFlag"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (VarsFlagsDialog.this.flagsTable.getSelectedRow() >= 0 && VarsFlagsDialog.this.varFlagsController.deleteFlag(VarsFlagsDialog.this.flagsTable.getSelectedRow())) {
                    VarsFlagsDialog.this.flagsTable.updateUI();
                }
            }
        });
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jButton2, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Vars.Title")));
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.varsTable = new JTable(new VarsTableModel());
        this.varsTable.getColumnModel().getColumn(1).setMaxWidth(60);
        this.varsTable.setSelectionMode(0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)new JScrollPane(this.varsTable, 22, 31), gridBagConstraints);
        JButton jButton3 = new JButton(TC.get((String)"Vars.AddVar"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (VarsFlagsDialog.this.varFlagsController.addVarFlag(false)) {
                    VarsFlagsDialog.this.varsTable.updateUI();
                }
            }
        });
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)jButton3, gridBagConstraints);
        JButton jButton4 = new JButton(TC.get((String)"Vars.DeleteVar"));
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (VarsFlagsDialog.this.varsTable.getSelectedRow() >= 0 && VarsFlagsDialog.this.varFlagsController.deleteVar(VarsFlagsDialog.this.varsTable.getSelectedRow())) {
                    VarsFlagsDialog.this.varsTable.updateUI();
                }
            }
        });
        gridBagConstraints.gridy = 2;
        jPanel2.add((Component)jButton4, gridBagConstraints);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(TC.get((String)"Flags.Flag"), null, jPanel, TC.get((String)"Flags.FlagTip"));
        jTabbedPane.addTab(TC.get((String)"Vars.Var"), null, jPanel2, TC.get((String)"Vars.VarTip"));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        JLabel jLabel = new JLabel(TC.get((String)"Flags.Flag"));
        jLabel.setHorizontalTextPosition(0);
        jLabel.setAlignmentX(0.5f);
        jLabel.setHorizontalAlignment(0);
        ImageIcon imageIcon = new ImageIcon("img/icons/flag16.png");
        jPanel3.add((Component)new JLabel(imageIcon), gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        jPanel3.add((Component)jLabel, gridBagConstraints2);
        jPanel3.setBackground(ConditionsPanel.FLAG_COLOR);
        jTabbedPane.setTabComponentAt(0, jPanel3);
        JButton jButton5 = new JButton(new ImageIcon("img/icons/information.png"));
        jButton5.setContentAreaFilled(false);
        jButton5.setMargin(new Insets(0, 0, 0, 0));
        jButton5.setFocusable(false);
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new HelpDialog(VarsFlagsDialog.flagsHelpPath);
            }
        });
        ++gridBagConstraints2.gridx;
        jPanel3.add((Component)jButton5, gridBagConstraints2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        JLabel jLabel2 = new JLabel(TC.get((String)"Vars.Var"));
        jLabel2.setHorizontalTextPosition(0);
        jLabel2.setAlignmentX(0.5f);
        jLabel2.setHorizontalAlignment(0);
        ImageIcon imageIcon2 = new ImageIcon("img/icons/var16.png");
        jPanel4.add((Component)new JLabel(imageIcon2), gridBagConstraints3);
        ++gridBagConstraints3.gridx;
        jPanel4.add((Component)jLabel2, gridBagConstraints3);
        jPanel4.setBackground(ConditionsPanel.VAR_COLOR);
        jTabbedPane.setTabComponentAt(1, jPanel4);
        JButton jButton6 = new JButton(new ImageIcon("img/icons/information.png"));
        jButton6.setContentAreaFilled(false);
        jButton6.setMargin(new Insets(0, 0, 0, 0));
        jButton6.setFocusable(false);
        jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new HelpDialog(VarsFlagsDialog.varsHelpPath);
            }
        });
        ++gridBagConstraints3.gridx;
        jPanel4.add((Component)jButton6, gridBagConstraints3);
        this.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jTabbedPane, gridBagConstraints);
        this.setResizable(false);
        this.setSize(500, 400);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    private class VarsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private VarsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return VarsFlagsDialog.this.varFlagsController.getVarCount();
        }

        @Override
        public String getColumnName(int n) {
            String string = "";
            if (n == 0) {
                string = TC.get((String)"Vars.VarName");
            } else if (n == 1) {
                string = TC.get((String)"Vars.VarReferences");
            }
            return string;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object object = null;
            if (n2 == 0) {
                object = VarsFlagsDialog.this.varFlagsController.getVar(n);
            } else if (n2 == 1) {
                object = VarsFlagsDialog.this.varFlagsController.getVarReferences(n);
            }
            return object;
        }
    }

    private class FlagsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private FlagsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return VarsFlagsDialog.this.varFlagsController.getFlagCount();
        }

        @Override
        public String getColumnName(int n) {
            String string = "";
            if (n == 0) {
                string = TC.get((String)"Flags.FlagName");
            } else if (n == 1) {
                string = TC.get((String)"Flags.FlagReferences");
            }
            return string;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object object = null;
            if (n2 == 0) {
                object = VarsFlagsDialog.this.varFlagsController.getFlag(n);
            } else if (n2 == 1) {
                object = VarsFlagsDialog.this.varFlagsController.getFlagReferences(n);
            }
            return object;
        }
    }
}

