/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class VarDialog
extends JDialog {
    private static final long serialVersionUID = 2389765067746677296L;
    public static final String CLOSE = "close";
    private WholeNumberField value;
    private JComboBox actions;
    private boolean isVar = true;
    private boolean close = false;

    public VarDialog(int n, String[] stringArray, String string) {
        super(Controller.getInstance().peekWindow(), TC.get((String)"VarDialog.Title"), Dialog.ModalityType.TOOLKIT_MODAL);
        JPanel jPanel;
        JComponent jComponent;
        if (n == -1) {
            this.isVar = false;
        }
        Controller.getInstance().pushWindow(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Controller.getInstance().popWindow();
                VarDialog.this.close = true;
            }
        });
        this.actions = new JComboBox<String>(stringArray);
        this.actions.setSelectedItem(string);
        JPanel jPanel2 = new JPanel();
        jPanel2.add((Component)this.actions, "Center");
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"VarDialog.Value")));
        if (this.isVar) {
            this.value = new WholeNumberField(n, 5);
            jComponent = new JPanel();
            jComponent.add((Component)this.value, "Center");
            jComponent.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"VarDialog.Value")));
            jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(0, 2));
            jPanel.add(jPanel2);
            jPanel.add(jComponent);
            this.add(jPanel);
        } else {
            this.add(jPanel2);
        }
        jComponent = new JButton("OK");
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VarDialog.this.dispose();
            }
        });
        jPanel = new JPanel();
        jPanel.add(jComponent);
        this.add((Component)jComponent, "South");
        this.setResizable(false);
        this.setSize(250, 100);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setVisible(true);
        jComponent.requestFocus();
    }

    public String getValue() {
        if (this.close) {
            return CLOSE;
        }
        if (this.isVar) {
            return (String)this.actions.getSelectedItem() + " " + this.value.getText();
        }
        return (String)this.actions.getSelectedItem();
    }

    public class WholeNumberField
    extends JTextField {
        private static final long serialVersionUID = 5121937653771983070L;
        private Toolkit toolkit;
        private NumberFormat integerFormatter;

        public WholeNumberField(int n, int n2) {
            super(n2);
            this.toolkit = Toolkit.getDefaultToolkit();
            this.integerFormatter = NumberFormat.getNumberInstance(Locale.US);
            this.integerFormatter.setParseIntegerOnly(true);
            this.setValue(n);
        }

        public int getValue() {
            int n = 0;
            try {
                n = this.integerFormatter.parse(this.getText()).intValue();
            }
            catch (ParseException parseException) {
                this.toolkit.beep();
            }
            return n;
        }

        public void setValue(int n) {
            this.setText(this.integerFormatter.format(n));
        }

        @Override
        protected Document createDefaultModel() {
            return new WholeNumberDocument();
        }

        protected class WholeNumberDocument
        extends PlainDocument {
            private static final long serialVersionUID = 3398461058646116687L;

            protected WholeNumberDocument() {
            }

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                char[] cArray = string.toCharArray();
                char[] cArray2 = new char[cArray.length];
                int n2 = 0;
                for (int i = 0; i < cArray2.length; ++i) {
                    if (Character.isDigit(cArray[i])) {
                        cArray2[n2++] = cArray[i];
                        continue;
                    }
                    WholeNumberField.this.toolkit.beep();
                    Controller.getInstance().showErrorDialog(TC.get((String)"VarDialog.Err.Title"), TC.get((String)"VarDialog.Err.Message"));
                }
                super.insertString(n, new String(cArray2, 0, n2), attributeSet);
            }
        }
    }
}

