/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs;

import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.gui.Updateable;
import java.awt.Dialog;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public abstract class ToolManagableDialog
extends JDialog
implements Updateable,
WindowListener {
    private static final long serialVersionUID = 1L;
    private boolean worksInLocal;
    private KeyEventDispatcher undoRedoDispatcher = null;

    private static KeyEventDispatcher createKeyDispatcher() {
        return new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                boolean bl = false;
                if (keyEvent.getID() == 402 && keyEvent.isControlDown() && keyEvent.getKeyCode() == 90) {
                    Controller.getInstance().undoTool();
                    keyEvent.consume();
                    bl = true;
                } else if (keyEvent.getID() == 402 && keyEvent.isControlDown() && keyEvent.getKeyCode() == 89) {
                    Controller.getInstance().redoTool();
                    keyEvent.consume();
                    bl = true;
                }
                return bl;
            }
        };
    }

    private void addUndoRedoDispatcher() {
        this.undoRedoDispatcher = ToolManagableDialog.createKeyDispatcher();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.undoRedoDispatcher);
    }

    public ToolManagableDialog(Window window, String string) {
        this(window, string, true);
    }

    public ToolManagableDialog(Window window, String string, boolean bl) {
        super(window, string, Dialog.ModalityType.TOOLKIT_MODAL);
        this.worksInLocal = bl;
        this.addWindowListener(this);
        super.setVisible(false);
    }

    @Override
    public boolean updateFields() {
        return false;
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(string);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            if (bl) {
                this.addUndoRedoDispatcher();
            } else {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.undoRedoDispatcher);
            }
            if (bl && Controller.getInstance().peekWindow() != this) {
                Controller.getInstance().pushWindow(this);
            } else if (!bl && Controller.getInstance().peekWindow() == this) {
                Controller.getInstance().popWindow();
            }
            if (this.worksInLocal) {
                if (bl) {
                    Controller.getInstance().pushLocalToolManager();
                } else {
                    Controller.getInstance().popLocalToolManager();
                }
            }
            if (bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ToolManagableDialog.this.repaint();
                    }
                });
            }
            super.setVisible(bl);
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.undoRedoDispatcher);
        if (Controller.getInstance().peekWindow() == this) {
            Controller.getInstance().popWindow();
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.undoRedoDispatcher);
        if (Controller.getInstance().peekWindow() == this) {
            Controller.getInstance().popWindow();
        }
        this.setVisible(false);
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }
}

