/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.config.ConfigData;
import es.eucm.eadventure.editor.control.config.ProjectConfigData;
import es.eucm.eadventure.editor.control.controllers.EffectsController;
import es.eucm.eadventure.editor.control.controllers.SelectedEffectsController;
import es.eucm.eadventure.editor.control.controllers.SingleEffectController;
import es.eucm.eadventure.editor.gui.editdialogs.ToolManagableDialog;
import es.eucm.eadventure.editor.gui.editdialogs.effectdialogs.EffectDialog;
import es.eucm.eadventure.editor.gui.structurepanel.EffectInfoPanel;
import es.eucm.eadventure.editor.gui.structurepanel.EffectsStructurePanel;
import es.eucm.eadventure.editor.gui.structurepanel.MostVisitedPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SelectEffectsDialog
extends ToolManagableDialog {
    private static final long serialVersionUID = 1L;
    private static SelectEffectsDialog instance = null;
    private EffectsStructurePanel effectsStructurePanel;
    private EffectsStructurePanel allEffectsStructurePanel;
    private boolean isOk;
    private MostVisitedPanel visitPanel;
    private JTabbedPane tabPane;
    private JPanel infoPlusButtons;
    private EffectsController controller;
    private JButton ok;
    private HashMap<Integer, Object> effectProperties;

    public SelectEffectsDialog(EffectsController effectsController) {
        super(Controller.getInstance().peekWindow(), TC.get((String)"SelectEffectDialog.Title"), false);
        this.controller = effectsController;
        this.effectsStructurePanel = new EffectsStructurePanel(false, this);
        this.allEffectsStructurePanel = new EffectsStructurePanel(true, this);
        this.isOk = false;
        this.visitPanel = new MostVisitedPanel(this);
        this.tabPane = new JTabbedPane(1);
        this.tabPane.insertTab(TC.get((String)"SelectEffectDialog.ByCategory"), null, this.effectsStructurePanel, TC.get((String)"SelectEffectDialog.ByCategory.ToolTipText"), 0);
        this.tabPane.insertTab(TC.get((String)"SelectEffectDialog.Recent"), null, this.visitPanel, TC.get((String)"SelectEffectDialog.Recent.ToolTipText"), 1);
        this.tabPane.insertTab(TC.get((String)"SelectEffectDialog.AllEffects"), null, this.allEffectsStructurePanel, TC.get((String)"SelectEffectDialog.AllEffects.ToolTipText"), 2);
        if (ConfigData.getEffectSelectorTab() <= 2 && ConfigData.getEffectSelectorTab() >= 0) {
            this.tabPane.setSelectedIndex(ConfigData.getEffectSelectorTab());
        }
        this.tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (SelectEffectsDialog.this.infoPlusButtons != null) {
                    if (SelectEffectsDialog.this.tabPane.getSelectedComponent() == SelectEffectsDialog.this.effectsStructurePanel) {
                        SelectEffectsDialog.this.createInfoPlusButtons(SelectEffectsDialog.this.effectsStructurePanel.getInfoPanel());
                        SelectEffectsDialog.this.ok.setEnabled(true);
                    } else if (SelectEffectsDialog.this.tabPane.getSelectedComponent() == SelectEffectsDialog.this.allEffectsStructurePanel) {
                        SelectEffectsDialog.this.createInfoPlusButtons(SelectEffectsDialog.this.allEffectsStructurePanel.getInfoPanel());
                        SelectEffectsDialog.this.ok.setEnabled(true);
                    }
                }
                if (SelectEffectsDialog.this.ok != null && SelectEffectsDialog.this.tabPane.getSelectedComponent() == SelectEffectsDialog.this.visitPanel) {
                    SelectEffectsDialog.this.ok.setEnabled(false);
                }
                ConfigData.setEffectSelectorTab(SelectEffectsDialog.this.tabPane.getSelectedIndex());
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 2;
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.tabPane, "Center");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.gridx = 1;
        this.infoPlusButtons = new JPanel(new BorderLayout());
        if (this.tabPane.getSelectedIndex() == 0) {
            this.createInfoPlusButtons(this.effectsStructurePanel.getInfoPanel());
        } else if (this.tabPane.getSelectedIndex() == 1) {
            this.createInfoPlusButtons(this.allEffectsStructurePanel.getInfoPanel());
        } else if (this.tabPane.getSelectedIndex() == 2) {
            this.createInfoPlusButtons(this.allEffectsStructurePanel.getInfoPanel());
        }
        JSplitPane jSplitPane = new JSplitPane(1, jPanel, this.infoPlusButtons);
        jPanel.setMaximumSize(new Dimension(225, 0));
        jPanel.setMinimumSize(new Dimension(200, 0));
        jSplitPane.setDividerLocation(200);
        this.add(jSplitPane);
        this.setResizable(false);
        this.setSize(new Dimension(600, 400));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    private void createInfoPlusButtons(EffectInfoPanel effectInfoPanel) {
        this.infoPlusButtons.removeAll();
        this.infoPlusButtons.add((Component)effectInfoPanel, "Center");
        JPanel jPanel = new JPanel(new GridLayout(0, 2));
        this.ok = new JButton(TC.get((String)"GeneralText.OK"));
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectEffectsDialog.this.setOk(true);
            }
        });
        JButton jButton = new JButton(TC.get((String)"GeneralText.Cancel"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectEffectsDialog.this.setOk(false);
            }
        });
        jPanel.add(this.ok);
        jPanel.add(jButton);
        this.infoPlusButtons.add((Component)jPanel, "South");
    }

    public void setOk(boolean bl) {
        this.isOk = bl;
        this.effectProperties = this.buildEffectProperties();
        this.dispose();
    }

    public boolean isOk() {
        return this.isOk;
    }

    protected String getSelection() {
        if (!this.visitPanel.isPressed() && this.tabPane.getSelectedComponent() == this.effectsStructurePanel) {
            return this.effectsStructurePanel.getSelectedEffect();
        }
        if (!this.visitPanel.isPressed() && this.tabPane.getSelectedComponent() == this.allEffectsStructurePanel) {
            return this.allEffectsStructurePanel.getSelectedEffect();
        }
        if (this.visitPanel.isPressed() && this.tabPane.getSelectedComponent() == this.visitPanel) {
            return this.visitPanel.getSelectedName();
        }
        return null;
    }

    public HashMap<Integer, Object> buildEffectProperties() {
        SingleEffectController singleEffectController;
        SingleEffectController singleEffectController2;
        String[] stringArray = new String[]{TC.get((String)"Effect.Activate"), TC.get((String)"Effect.Deactivate"), TC.get((String)"Effect.SetValue"), TC.get((String)"Effect.IncrementVar"), TC.get((String)"Effect.DecrementVar"), TC.get((String)"Effect.MacroReference"), TC.get((String)"Effect.ConsumeObject"), TC.get((String)"Effect.GenerateObject"), TC.get((String)"Effect.CancelAction"), TC.get((String)"Effect.SpeakPlayer"), TC.get((String)"Effect.SpeakCharacter"), TC.get((String)"Effect.TriggerBook"), TC.get((String)"Effect.PlaySound"), TC.get((String)"Effect.PlayAnimation"), TC.get((String)"Effect.MovePlayer"), TC.get((String)"Effect.MoveCharacter"), TC.get((String)"Effect.TriggerConversation"), TC.get((String)"Effect.TriggerCutscene"), TC.get((String)"Effect.TriggerScene"), TC.get((String)"Effect.TriggerLastScene"), TC.get((String)"Effect.RandomEffect"), TC.get((String)"Effect.ShowText"), TC.get((String)"Effect.WaitTime"), TC.get((String)"Effect.HighlightItem"), TC.get((String)"Effect.MoveObject")};
        int[] nArray = new int[]{0, 1, 17, 18, 19, 20, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 22, 21, 23, 24};
        String string = this.getSelectedEffect();
        HashMap<Integer, Object> hashMap = null;
        if (string != null && !string.equals(TC.get((String)"Effect.RandomEffect"))) {
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                n = nArray[i];
            }
            if (n == 10 && Controller.getInstance().isPlayTransparent()) {
                Controller.getInstance().showErrorDialog(TC.get((String)"Error.EffectMovePlayerNotAllowed.Title"), TC.get((String)"Error.EffectMovePlayerNotAllowed.Message"));
            } else {
                hashMap = EffectDialog.showAddEffectDialog(this.controller, n);
                if (hashMap != null) {
                    hashMap.put(11, Integer.toString(n));
                }
            }
        } else if (string != null && (hashMap = EffectDialog.showEditRandomEffectDialog(50, singleEffectController2 = new SingleEffectController(), singleEffectController = new SingleEffectController())) != null) {
            hashMap.put(11, Integer.toString(16));
            if (singleEffectController2.getEffect() != null) {
                hashMap.put(12, singleEffectController2.getEffect());
            }
            if (singleEffectController.getEffect() != null) {
                hashMap.put(13, singleEffectController.getEffect());
            }
        }
        return hashMap;
    }

    private String getSelectedEffect() {
        if (this.isOk()) {
            String string = this.getSelection();
            if (string != null) {
                int n = 0;
                String string2 = SelectedEffectsController.convertNames(string);
                String string3 = ProjectConfigData.getProperty(string2);
                if (string3 != null) {
                    n = Integer.parseInt(string3);
                }
                ProjectConfigData.setProperty(string2, String.valueOf(n + 1));
            }
            return string;
        }
        return null;
    }

    public static HashMap<Integer, Object> getNewEffectProperties(EffectsController effectsController) {
        instance = new SelectEffectsDialog(effectsController);
        return SelectEffectsDialog.instance.effectProperties;
    }
}

