/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.gui.structurepanel.StructureControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class SearchDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Controller controller = Controller.getInstance();
    private JTextField textField;
    private JCheckBox caseSensitive;
    private JCheckBox fullMatch;
    private JTable table;
    private DefaultTableModel dtm;
    private List<Searchable> dataControls;

    public SearchDialog() {
        this.setLayout(new BorderLayout());
        this.setTitle(TC.get((String)"Search.DialogTitle"));
        JPanel jPanel = new JPanel();
        this.textField = new JTextField(15);
        this.textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchDialog.this.search();
            }
        });
        jPanel.add(this.textField);
        this.caseSensitive = new JCheckBox(TC.get((String)"Search.CaseSensitive"));
        jPanel.add(this.caseSensitive);
        this.fullMatch = new JCheckBox(TC.get((String)"Search.FullMatch"));
        jPanel.add(this.fullMatch);
        JButton jButton = new JButton(TC.get((String)"Search.Search"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchDialog.this.search();
            }
        });
        jPanel.add(jButton);
        this.add((Component)jPanel, "North");
        this.dataControls = new ArrayList<Searchable>();
        this.dtm = new DefaultTableModel();
        this.dtm.setColumnCount(2);
        Object[] objectArray = new String[]{TC.get((String)"Search.Where"), TC.get((String)"Search.Places")};
        this.dtm.setColumnIdentifiers(objectArray);
        this.table = new JTable(this.dtm){
            private static final long serialVersionUID = -4886780250056223726L;

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        JScrollPane jScrollPane = new JScrollPane(this.table);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting() && SearchDialog.this.table.getSelectedRow() != -1) {
                    StructureControl.getInstance().changeDataControl((Searchable)SearchDialog.this.dataControls.get(SearchDialog.this.table.getSelectedRow()));
                }
            }
        });
        this.table.setFillsViewportHeight(true);
        this.add((Component)jScrollPane, "Center");
        this.setSize(460, 600);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension.width - 460, (dimension.height - 600) / 2);
        this.setVisible(true);
        Controller.getInstance().pushWindow(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Controller.getInstance().popWindow();
            }
        });
    }

    protected void search() {
        String string = this.textField.getText();
        if (string != null && !string.equals("")) {
            this.table.clearSelection();
            while (this.dtm.getRowCount() > 0) {
                this.dtm.removeRow(0);
            }
            this.dataControls.clear();
            boolean bl = this.caseSensitive.isSelected();
            boolean bl2 = this.fullMatch.isSelected();
            HashMap<Searchable, List<String>> hashMap = this.controller.getSelectedChapterDataControl().search(string, bl, bl2);
            for (Searchable searchable : hashMap.keySet()) {
                String string2 = "";
                for (String string3 : hashMap.get(searchable)) {
                    string2 = string2 + string3 + "|";
                }
                if (string2.length() > 1) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                Object[] objectArray = new Object[]{searchable.getClass().getSimpleName().replace("DataControl", ""), string2};
                this.dtm.addRow(objectArray);
                this.dataControls.add(searchable);
            }
            this.dtm.fireTableDataChanged();
        }
    }
}

