/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs;

import es.eucm.eadventure.common.auxiliar.File;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpDialog
extends JDialog
implements HyperlinkListener {
    private static final long serialVersionUID = -1705431401552161788L;
    private static final int HELP_WIDTH = 720;
    private static final int HELP_HEIGHT = 600;
    private JEditorPane pane;
    private List<URL> backList = new ArrayList<URL>();
    private List<URL> forwardList = new ArrayList<URL>();
    private JButton goBack;
    private JButton goForward;

    public HelpDialog(String string) {
        super(Controller.getInstance().peekWindow(), TC.get((String)"HelpDialog.Title"), Dialog.ModalityType.TOOLKIT_MODAL);
        File file;
        this.setSize(720, 600);
        this.setLayout(new BorderLayout());
        this.addButtonPanel();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((int)(dimension.getWidth() - 720.0) / 2, (int)(dimension.getHeight() - 600.0) / 2);
        String string2 = "help/" + Controller.getInstance().getLanguage() + "/";
        File file2 = new File(string2);
        if (!file2.exists()) {
            string2 = "help/" + Controller.getInstance().getDefaultLanguage() + "/";
        }
        if ((file = new File(string2 + string)).exists()) {
            this.pane = new JEditorPane();
            try {
                this.pane.setPage(file.toURI().toURL());
                this.backList.add(file.toURI().toURL());
                this.pane.setEditable(false);
                this.pane.setHighlighter(null);
                this.pane.addHyperlinkListener(this);
                this.add((Component)new JScrollPane(this.pane, 22, 31), "Center");
            }
            catch (MalformedURLException malformedURLException) {
                this.writeFileNotFound(string2 + string);
            }
            catch (IOException iOException) {
                this.writeFileNotFound(string2 + string);
            }
        } else {
            this.writeFileNotFound(string2 + string);
        }
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HelpDialog.this.dispose();
            }
        });
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                if (hyperlinkEvent.getDescription().toLowerCase().contains("http:")) {
                    this.openURI(hyperlinkEvent.getDescription());
                } else {
                    this.pane.setPage(hyperlinkEvent.getURL());
                    this.backList.add(hyperlinkEvent.getURL());
                    this.forwardList.clear();
                    this.updateButtons();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void goBack() {
        if (this.backList.size() > 1) {
            try {
                this.pane.setPage(this.backList.get(this.backList.size() - 2));
                this.forwardList.add(this.backList.get(this.backList.size() - 1));
                this.backList.remove(this.backList.size() - 1);
                this.updateButtons();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void goForward() {
        if (this.forwardList.size() > 0) {
            try {
                this.pane.setPage(this.forwardList.get(this.forwardList.size() - 1));
                this.backList.add(this.forwardList.get(this.forwardList.size() - 1));
                this.forwardList.remove(this.forwardList.size() - 1);
                this.updateButtons();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void addButtonPanel() {
        JPanel jPanel = new JPanel();
        this.goBack = new JButton(TC.get((String)"Tools.Back"));
        this.goBack.setEnabled(false);
        this.goBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpDialog.this.goBack();
            }
        });
        jPanel.add(this.goBack);
        this.goForward = new JButton(TC.get((String)"Tools.Forward"));
        this.goForward.setEnabled(false);
        this.goForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpDialog.this.goForward();
            }
        });
        jPanel.add(this.goForward);
        this.add((Component)jPanel, "North");
    }

    private void updateButtons() {
        if (this.backList.size() > 1) {
            this.goBack.setEnabled(true);
        } else {
            this.goBack.setEnabled(false);
        }
        if (this.forwardList.size() > 0) {
            this.goForward.setEnabled(true);
        } else {
            this.goForward.setEnabled(false);
        }
    }

    public void writeFileNotFound(String string) {
        this.add(new JLabel(TC.get((String)"HelpDialog.FileNotFound") + " " + string));
    }

    public void openURI(String string) {
        Desktop desktop;
        if (!Desktop.isDesktopSupported()) {
            System.err.println("Desktop is not supported (fatal)");
            System.exit(1);
        }
        if (!(desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            System.err.println("Desktop doesn't support the browse action (fatal)");
            System.exit(1);
        }
        try {
            URI uRI = new URI(string);
            desktop.browse(uRI);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

