/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs;

import de.xeinfach.kafenio.KafenioPanel;
import de.xeinfach.kafenio.component.MutableFilter;
import de.xeinfach.kafenio.interfaces.KafenioPanelConfigurationInterface;
import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.HTMLEditController;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import javax.swing.text.BadLocationException;

public class HTMLEditPanel
extends KafenioPanel {
    private HTMLEditController htmlEditController;
    private static final long serialVersionUID = -248722263397313316L;

    public void setHtmlEditController(HTMLEditController hTMLEditController) {
        this.htmlEditController = hTMLEditController;
    }

    public static HTMLEditPanel getInstance(File file) {
        KafenioPanelConfigurationInterface kafenioPanelConfigurationInterface = null;
        try {
            kafenioPanelConfigurationInterface = (KafenioPanelConfigurationInterface)Class.forName("de.xeinfach.kafenio.KafenioPanelConfiguration").newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        kafenioPanelConfigurationInterface.setImageDir("file://");
        kafenioPanelConfigurationInterface.setCustomMenuItems("edit view font format search tools help");
        kafenioPanelConfigurationInterface.setCustomToolBar1("SAVE,SEPARATOR,CUT,COPY,PASTE,SEPARATOR,BOLD,ITALIC,UNDERLINE,SEPARATOR,LEFT,CENTER,RIGHT,JUSTIFY,SEPARATOR,TABLE");
        kafenioPanelConfigurationInterface.setCustomToolBar2("ulist,olist,spearator,deindent,indent,separator,image,separator,viewsource,separator,strike,superscript,subscript,insertcharacter,separator,find,color");
        File file2 = null;
        if (file != null) {
            file2 = new File(file.getAbsolutePath());
        }
        HTMLEditPanel hTMLEditPanel = new HTMLEditPanel(kafenioPanelConfigurationInterface, file2);
        return hTMLEditPanel;
    }

    public HTMLEditPanel(KafenioPanelConfigurationInterface kafenioPanelConfigurationInterface, File file) {
        super(kafenioPanelConfigurationInterface);
        if (file != null) {
            try {
                this.loadDocument(file, null);
            }
            catch (IOException iOException) {
                ReportDialog.GenerateErrorReport((Exception)iOException, (boolean)true, (String)"UNKNOWERROR");
            }
            catch (BadLocationException badLocationException) {
                ReportDialog.GenerateErrorReport((Exception)badLocationException, (boolean)true, (String)"UNKNOWERROR");
            }
        }
    }

    protected void insertLocalImage(File file) throws IOException, BadLocationException, RuntimeException {
        file = this.getImageFromChooser(".", MutableFilter.EXT_IMG, this.translatrix.getTranslationString("FiletypeIMG"));
        super.insertLocalImage(file);
        this.htmlEditController.addImage(file);
    }

    public void saveAll() {
        try {
            super.writeOut(new File(this.htmlEditController.getFilename()));
            File file = new File(this.htmlEditController.getFilename());
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            InputStreamReader inputStreamReader = new InputStreamReader(bufferedInputStream);
            int n = (int)file.length();
            char[] cArray = new char[n];
            inputStreamReader.read(cArray, 0, n);
            inputStreamReader.close();
            bufferedInputStream.close();
            fileInputStream.close();
            String string = new String(cArray);
            string = string.replace("\\\\", "/");
            for (File object2 : this.htmlEditController.getImages()) {
                String string2 = object2.getAbsolutePath().replace("\\\\", "/");
                String string3 = object2.getName();
                string = string.replace(string2, string3);
                AssetsController.addSingleAsset(7, object2.getAbsolutePath());
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            outputStreamWriter.write(string, 0, string.length());
            outputStreamWriter.close();
            fileOutputStream.close();
            if (this.htmlEditController.isNewFile()) {
                AssetsController.addSingleAsset(7, file.getAbsolutePath());
            }
        }
        catch (IOException iOException) {
            ReportDialog.GenerateErrorReport((Exception)iOException, (boolean)true, (String)"UNKNOWERROR");
        }
        catch (BadLocationException badLocationException) {
            ReportDialog.GenerateErrorReport((Exception)badLocationException, (boolean)true, (String)"UNKNOWERROR");
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }
}

