/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.HTMLEditController;
import es.eucm.eadventure.editor.gui.editdialogs.HTMLEditPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class HTMLEditDialog
extends JDialog
implements WindowListener {
    private static final long serialVersionUID = 1L;
    private HTMLEditController htmlEditController;
    private HTMLEditPanel kafenio;

    public HTMLEditController getHtmlEditController() {
        return this.htmlEditController;
    }

    public HTMLEditDialog(String string, JFrame jFrame) {
        super((Frame)jFrame, true);
        Serializable serializable;
        this.setTitle(TC.get((String)"HTMLEditor.Title", (String)string));
        this.htmlEditController = new HTMLEditController();
        Controller.getInstance().pushWindow(this);
        boolean bl = false;
        if (string == null) {
            string = AssetsController.TempFileGenerator.generateTempFileAbsolutePath("html");
            serializable = new File(string);
            try {
                serializable.createNewFile();
            }
            catch (IOException iOException) {
                ReportDialog.GenerateErrorReport((Exception)iOException, (boolean)true, (String)"UNKNOWERROR");
            }
            bl = true;
        }
        this.htmlEditController.setFilename(string);
        this.htmlEditController.setNewFile(bl);
        this.setLayout(new BorderLayout());
        this.kafenio = HTMLEditPanel.getInstance(new File(string));
        this.kafenio.setHtmlEditController(this.htmlEditController);
        this.add((Component)((Object)this.kafenio), "Center");
        this.setJMenuBar(this.kafenio.getJMenuBar());
        this.addWindowListener(this);
        this.setSize(800, 600);
        this.setResizable(true);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setVisible(true);
        serializable = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((((Dimension)serializable).width - this.getWidth()) / 2, (((Dimension)serializable).height - this.getHeight()) / 2);
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        int n = JOptionPane.showConfirmDialog(this, TC.get((String)"HTMLEditor.QuitMessage"), TC.get((String)"HTMLEditor.QuitMessageTitle"), 0, 3);
        if (n == 0) {
            this.kafenio.saveAll();
        }
        Controller.getInstance().popWindow();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }
}

